/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.util.Collections;
import java.util.Map;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsMessage;

public abstract class BasicNlsMessage
extends AbstractNlsMessage {
    private static final long serialVersionUID = 7021159510028831610L;
    private NlsTemplate template;
    private String message;
    private Map<String, Object> arguments;

    protected BasicNlsMessage() {
    }

    public BasicNlsMessage(NlsTemplate template, Map<String, Object> messageArguments) {
        this(template, null, messageArguments);
        assert (template != null);
    }

    public BasicNlsMessage(String internationalizedMessage, Map<String, Object> messageArguments) {
        this(null, internationalizedMessage, messageArguments);
        assert (internationalizedMessage != null);
    }

    private BasicNlsMessage(NlsTemplate template, String internationalizedMessage, Map<String, Object> messageArguments) {
        this.template = template;
        this.message = internationalizedMessage;
        this.arguments = messageArguments == null ? Collections.emptyMap() : messageArguments;
    }

    @Override
    public Object getArgument(String key) {
        return this.arguments.get(key);
    }

    @Override
    public String getInternationalizedMessage() {
        if (this.message == null) {
            this.message = this.template.translate(LOCALE_ROOT);
        }
        return this.message;
    }

    protected final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public NlsTemplate getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NlsTemplate getTemplate(NlsTemplateResolver resolver) {
        if (this.template == null) {
            BasicNlsMessage basicNlsMessage = this;
            synchronized (basicNlsMessage) {
                if (this.template == null) {
                    NlsTemplateResolver templateResolver = resolver == null ? NlsAccess.getTemplateResolver() : resolver;
                    this.template = templateResolver.resolveTemplate(this.message);
                }
            }
        }
        return this.template;
    }
}

