/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.ObjectMismatchException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;
import net.sf.mmm.util.lang.api.DatatypeDescriptor;
import net.sf.mmm.util.lang.api.DatatypeSegmentDescriptor;
import net.sf.mmm.util.reflect.api.InstantiationFailedException;

public abstract class AbstractDatatypeDescriptor<T>
implements DatatypeDescriptor<T> {
    private final Class<T> datatype;
    private final List<DatatypeSegmentDescriptor<T, ?>> segmentDescriptorList;
    private final int requiredSegmentCount;

    @SafeVarargs
    public AbstractDatatypeDescriptor(Class<T> datatype, DatatypeSegmentDescriptor<T, ?> ... segmentDescriptors) {
        this.datatype = datatype;
        this.segmentDescriptorList = Collections.unmodifiableList(Arrays.asList(segmentDescriptors));
        int requiredCount = segmentDescriptors.length;
        int i = 0;
        for (DatatypeSegmentDescriptor<T, ?> segment : segmentDescriptors) {
            if (segment.isOptional()) {
                if (requiredCount == segmentDescriptors.length) {
                    requiredCount = i;
                }
            } else if (requiredCount != segmentDescriptors.length) {
                throw new IllegalArgumentException("segment[" + i + "] (" + segment.getName() + ") is required but previous segment was optional!");
            }
            ++i;
        }
        this.requiredSegmentCount = requiredCount;
    }

    @Override
    public Class<T> getDatatype() {
        return this.datatype;
    }

    @Override
    public List<DatatypeSegmentDescriptor<T, ?>> getSegmentDescriptors() {
        return this.segmentDescriptorList;
    }

    @Override
    public Object getSegment(T datatypeInstance, int index) {
        return this.segmentDescriptorList.get(index).getSegment(datatypeInstance);
    }

    @Override
    public T create(Object ... segments) {
        try {
            NlsNullPointerException.checkNotNull("segments", segments);
            if (segments.length != this.segmentDescriptorList.size()) {
                if (this.requiredSegmentCount == this.segmentDescriptorList.size()) {
                    throw new ObjectMismatchException(segments.length, (Object)this.segmentDescriptorList.size(), (Object)"segments.length");
                }
                if (segments.length < this.requiredSegmentCount) {
                    throw new ValueOutOfRangeException(segments.length, this.requiredSegmentCount, this.segmentDescriptorList.size(), "segments.length");
                }
            }
            return this.doCreate(segments);
        }
        catch (Exception e) {
            throw new InstantiationFailedException((Throwable)e, this.getDatatype());
        }
    }

    protected abstract T doCreate(Object ... var1);

    public String toString() {
        return "DatatypeDescriptor for " + this.datatype.getName();
    }
}

