/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.List;
import javax.inject.Inject;
import net.sf.mmm.util.exception.api.ValueNotSetException;
import net.sf.mmm.util.lang.api.DatatypeDescriptor;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeSegmentDescriptor;

public class DatatypeJsonDeserializer<T>
extends JsonDeserializer<T> {
    private final Class<T> datatype;
    private DatatypeDescriptorManager datatypeDescriptorManager;

    public DatatypeJsonDeserializer(Class<T> datatype) {
        this.datatype = datatype;
    }

    public DatatypeJsonDeserializer(Class<T> datatype, DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatype = datatype;
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    @Inject
    public void setDatatypeDescriptorManager(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    protected <V> V getValue(JsonNode node, String fieldName, Class<V> type, boolean required) {
        JsonNode childNode = node.get(fieldName);
        if (childNode == null || childNode.isNull()) {
            if (required) {
                throw new ValueNotSetException((Object)fieldName);
            }
            return null;
        }
        return this.getValue(childNode, type);
    }

    protected <V> V getValue(JsonNode valueNode, Class<V> type) {
        Object value;
        block15: {
            value = null;
            try {
                if (type == String.class) {
                    value = valueNode.asText();
                    break block15;
                }
                if (type == BigDecimal.class) {
                    value = valueNode.isNumber() ? valueNode.decimalValue() : new BigDecimal(valueNode.asText());
                    break block15;
                }
                if (type == BigInteger.class) {
                    value = valueNode.isNumber() ? valueNode.bigIntegerValue() : new BigInteger(valueNode.asText());
                    break block15;
                }
                if (type == Boolean.class) {
                    value = valueNode.isBoolean() ? Boolean.valueOf(valueNode.booleanValue()) : Boolean.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Integer.class) {
                    value = valueNode.isInt() ? Integer.valueOf(valueNode.intValue()) : Integer.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Long.class) {
                    value = valueNode.isLong() ? Long.valueOf(valueNode.longValue()) : Long.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Double.class) {
                    value = valueNode.isDouble() ? Double.valueOf(valueNode.doubleValue()) : Double.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Float.class) {
                    value = valueNode.isFloat() ? Float.valueOf(valueNode.floatValue()) : Float.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Short.class) {
                    value = valueNode.isShort() ? Short.valueOf(valueNode.shortValue()) : Short.valueOf(valueNode.asText());
                    break block15;
                }
                if (type == Character.class) {
                    String text = valueNode.asText();
                    if (text.length() > 1) {
                        text = text.trim();
                    }
                    if (text.length() == 1) {
                        value = Character.valueOf(text.charAt(0));
                    }
                    break block15;
                }
                if (type == Currency.class) {
                    value = Currency.getInstance(valueNode.asText());
                    break block15;
                }
                throw new IllegalArgumentException("Unsupported value type " + type.getName());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to convert value to type " + type.getName(), e);
            }
        }
        return (V)value;
    }

    public <V> V deserializeGeneric(JsonParser parser, DeserializationContext context, Class<V> type, JsonNode parentNode, DatatypeSegmentDescriptor<?, ?> segment) throws IOException {
        DatatypeDescriptor<V> descriptor = this.datatypeDescriptorManager.getDatatypeDescriptor(type);
        List<DatatypeSegmentDescriptor<V, ?>> segmentList = descriptor.getSegmentDescriptors();
        int segmentCount = segmentList.size();
        if (segmentCount == 0) {
            if (parentNode != null) {
                return this.getValue(parentNode, segment.getName(), type, !segment.isOptional());
            }
            return (V)parser.readValueAs(type);
        }
        if (segmentCount == 1) {
            DatatypeSegmentDescriptor<V, ?> childSegment = segmentList.get(0);
            Object value = this.deserializeGeneric(parser, context, childSegment.getType(), parentNode, segment);
            return descriptor.create(value);
        }
        JsonNode node = parentNode == null ? (JsonNode)parser.getCodec().readTree(parser) : parentNode.get(segment.getName());
        Object[] values = new Object[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            DatatypeSegmentDescriptor<V, ?> childSegment = segmentList.get(i);
            values[i] = this.deserializeGeneric(parser, context, childSegment.getType(), node, childSegment);
        }
        return descriptor.create(values);
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        return this.deserializeGeneric(parser, context, this.datatype, null, null);
    }
}

