/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.util.Locale;
import javax.inject.Inject;
import net.sf.mmm.util.component.api.ResourceMissingException;
import net.sf.mmm.util.lang.base.AbstractEnvironmentDetector;
import org.springframework.core.env.Environment;

public class EnvironmentDetectorSpringProfileImpl
extends AbstractEnvironmentDetector {
    @Inject
    private Environment environment;
    private String environmentType;

    @Override
    public String getEnvironmentType() {
        if (this.environmentType == null) {
            String result = this.getEnvironmentTypeSynchronized();
            this.logEnvironmentStatus();
            return result;
        }
        return this.environmentType;
    }

    protected synchronized String getEnvironmentTypeSynchronized() {
        if (this.environmentType == null) {
            this.environmentType = this.detectEnvironmentType(this.environment.getActiveProfiles());
        }
        return this.environmentType;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Inject
    public void setEnvironment(Environment environment) {
        this.getInitializationState().requireNotInitilized();
        this.environment = environment;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.environment == null) {
            throw new ResourceMissingException("environment");
        }
    }

    @Override
    protected void logEnvironmentStatus() {
        super.logEnvironmentStatus();
        if (this.isDevelopmentEnvironment()) {
            this.getLogger().warn("ATTENTION: You are currently running in DEVELOPMENT mode.");
            this.getLogger().warn("Ensure to manage your environments properly via spring profiles (e.g. by setting the system property 'spring.profiles.active'");
        }
    }

    protected String detectEnvironmentType(String[] names) {
        String detectedEnvironmentType = null;
        for (String name : names) {
            String newType = this.detectEnvironmentType(name);
            if (newType == null) continue;
            if (detectedEnvironmentType == null) {
                detectedEnvironmentType = newType;
                this.getLogger().info("Profile '{}' triggered environment type '{}'.", (Object)name, (Object)newType);
                continue;
            }
            if (detectedEnvironmentType.equals(newType)) continue;
            throw new IllegalStateException("Environment type is " + detectedEnvironmentType + " but profile " + name + " triggered different environment type " + newType);
        }
        if (detectedEnvironmentType == null) {
            detectedEnvironmentType = "development";
        }
        return detectedEnvironmentType;
    }

    protected String detectEnvironmentType(String name) {
        String lowercaseName = name.toLowerCase(Locale.US);
        if (lowercaseName.contains("pre-live") || lowercaseName.contains("pre-prod") || lowercaseName.contains("prelive") || lowercaseName.contains("preprod")) {
            return "pre-production";
        }
        if (lowercaseName.contains("prod") || lowercaseName.contains("live")) {
            return "production";
        }
        if (lowercaseName.contains("dev")) {
            return "development";
        }
        if (lowercaseName.contains("accept")) {
            return "acceptance";
        }
        if (lowercaseName.contains("test")) {
            return "test";
        }
        if (lowercaseName.contains("staging") || lowercaseName.contains("stage")) {
            return "staging";
        }
        return null;
    }
}

