/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.AbstractIterator;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.ObjectNotFoundException;
import net.sf.mmm.util.lang.api.BasicHelper;
import net.sf.mmm.util.lang.api.EnumDefinition;
import net.sf.mmm.util.lang.api.EnumProvider;
import net.sf.mmm.util.lang.api.EnumTypeWithCategory;
import net.sf.mmm.util.lang.api.Formatter;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.api.attribute.AttributeReadDeprecated;
import net.sf.mmm.util.lang.base.AbstractEnumDefinition;
import net.sf.mmm.util.lang.base.BooleanEnumDefinition;
import net.sf.mmm.util.lang.base.EnumEnumDefinition;
import net.sf.mmm.util.lang.base.StringUtilImpl;

public abstract class AbstractEnumProvider
extends AbstractLoggableComponent
implements EnumProvider {
    private final Map<String, EnumContainer> enumContainerMap;
    private StringUtil stringUtil;

    public AbstractEnumProvider() {
        this(ConcurrentHashMapFactory.INSTANCE);
    }

    public AbstractEnumProvider(MapFactory<?> mapFactory) {
        this.enumContainerMap = mapFactory.createGeneric();
    }

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) {
        this.stringUtil = stringUtil;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
        this.registerEnumDefinitions();
    }

    protected void registerEnumDefinitions() {
        this.registerEnumDefinition(new BooleanEnumDefinition());
    }

    @Override
    public final Iterator<EnumDefinition<?, ?>> iterator() {
        return this.getEnumDefinitions();
    }

    @Override
    public Iterator<EnumDefinition<?, ?>> getEnumDefinitions() {
        return new EnumDefinitionIterator(this.enumContainerMap.values().iterator());
    }

    protected <ENUM extends Enum<ENUM>> void registerEnum(Class<ENUM> enumClass) {
        this.registerEnumDefinition(new EnumEnumDefinition(enumClass, this.stringUtil));
    }

    protected void registerEnumDefinition(AbstractEnumDefinition<?, ?> enumDefinition) {
        String key;
        EnumContainer old;
        NlsNullPointerException.checkNotNull(EnumDefinition.class, enumDefinition);
        EnumContainer container = new EnumContainer(enumDefinition);
        List<?> enumValues = enumDefinition.getEnumValues();
        if (enumValues != null) {
            container.setAllValues(enumValues);
        }
        if ((old = this.enumContainerMap.get(key = enumDefinition.getValue())) != null) {
            throw new DuplicateObjectException(enumDefinition, key, old.enumDefinition);
        }
        this.enumContainerMap.put(key, container);
    }

    @Override
    public <CATEGORY, ENUM extends EnumTypeWithCategory<?, CATEGORY>> EnumDefinition<ENUM, CATEGORY> getEnumDefinitionWithCategory(Class<? extends ENUM> enumType) throws ObjectNotFoundException {
        return this.getEnumDefinition(enumType);
    }

    @Override
    public <TYPE> EnumDefinition<TYPE, ?> getEnumDefinition(Class<TYPE> enumType) throws ObjectNotFoundException {
        NlsNullPointerException.checkNotNull("enumType", enumType);
        String key = enumType.getName();
        EnumContainer container = this.enumContainerMap.get(key);
        if (this.isSupportEnumAutoRegistration() && container == null && enumType.isEnum()) {
            this.registerEnum(enumType);
            container = this.enumContainerMap.get(key);
        }
        if (container == null) {
            throw new ObjectNotFoundException(EnumDefinition.class, (Object)key);
        }
        return container.enumDefinition;
    }

    protected boolean isSupportEnumAutoRegistration() {
        return true;
    }

    protected EnumContainer getEnumContainer(String key) {
        EnumContainer container = this.enumContainerMap.get(key);
        if (container == null) {
            throw new ObjectNotFoundException(EnumDefinition.class, (Object)key);
        }
        return container;
    }

    @Override
    public EnumDefinition<?, ?> getEnumDefinition(String key) throws ObjectNotFoundException {
        EnumContainer container = this.getEnumContainer(key);
        return container.enumDefinition;
    }

    @Override
    public boolean isAvailable(EnumDefinition<?, ?> enumDefinition) {
        NlsNullPointerException.checkNotNull(EnumDefinition.class, enumDefinition);
        EnumContainer container = this.enumContainerMap.get(enumDefinition.getValue());
        if (container != null) {
            return container.allValues != null;
        }
        return false;
    }

    @Override
    public <ENUM> ENUM getEnumValue(Class<ENUM> enumType, String value, boolean required) throws IllegalCaseException {
        return this.getEnumValue(this.getEnumDefinition(enumType), value, required);
    }

    @Override
    public <ENUM> ENUM getEnumValue(EnumDefinition<ENUM, ?> enumDefinition, String value, boolean required) {
        if (value == null) {
            return null;
        }
        List enumValues = this.getEnumContainer(enumDefinition.getValue()).allValues;
        Formatter<ENUM> formatter = enumDefinition.getFormatter();
        for (Object enumVal : enumValues) {
            String string = formatter.format(enumVal);
            if (!value.equals(string)) continue;
            return (ENUM)enumVal;
        }
        boolean isEnum = enumDefinition.getEnumType().isEnum();
        ENUM result = null;
        String valueNormalized = this.normalizeStringRepresentation(value);
        for (Object enumVal : enumValues) {
            String string = formatter.format(enumVal);
            String stringNormalized = this.normalizeStringRepresentation(string);
            if (!valueNormalized.equals(stringNormalized) && (!isEnum || !valueNormalized.equals(this.normalizeStringRepresentation(((Enum)enumVal).name())))) continue;
            if (result == null) {
                result = (ENUM)enumVal;
                continue;
            }
            this.getLogger().warn("Ambiguous constant '{}' for enum {}", (Object)value, enumDefinition.getEnumType());
            throw new IllegalCaseException(value);
        }
        if (result == null && required) {
            throw new IllegalCaseException(value);
        }
        return result;
    }

    private String normalizeStringRepresentation(String value) {
        if (value == null) {
            return null;
        }
        return BasicHelper.toLowerCase(value.replaceAll("[-_ .]", ""));
    }

    @Override
    public <ENUM> List<ENUM> getEnumValues(EnumDefinition<ENUM, ?> enumDefinition) {
        NlsNullPointerException.checkNotNull(EnumDefinition.class, enumDefinition);
        EnumContainer container = this.enumContainerMap.get(enumDefinition.getValue());
        NlsNullPointerException.checkNotNull(EnumContainer.class, container);
        if (container.activeValues == null) {
            this.loadEnumValues(container);
        }
        return container.activeValues;
    }

    protected abstract void loadEnumValues(EnumContainer var1);

    @Override
    public <CATEGORY, ENUM extends EnumTypeWithCategory<?, CATEGORY>> List<ENUM> getEnumValues(EnumDefinition<ENUM, CATEGORY> enumDefinition, CATEGORY ... categories) {
        assert (enumDefinition.getCategory() != null);
        List<ENUM> allEnumValues = this.getEnumValues(enumDefinition);
        LinkedList<EnumTypeWithCategory> result = new LinkedList<EnumTypeWithCategory>();
        HashSet<CATEGORY> categorySet = new HashSet<CATEGORY>();
        for (CATEGORY currentCategory : categories) {
            categorySet.add(currentCategory);
        }
        for (Object value : allEnumValues) {
            EnumTypeWithCategory enumValue = (EnumTypeWithCategory)value;
            Object category = enumValue.getCategory();
            if (!categorySet.contains(category)) continue;
            result.add(enumValue);
        }
        return result;
    }

    @Override
    public void clear(EnumDefinition<?, ?> enumDefinition) {
        NlsNullPointerException.checkNotNull(EnumDefinition.class, enumDefinition);
        EnumContainer container = this.enumContainerMap.get(enumDefinition.getValue());
        NlsNullPointerException.checkNotNull(EnumContainer.class, container);
        if (container.enumDefinition.isMutable()) {
            container.setAllValues(null);
        }
    }

    @Override
    public void require(EnumDefinition<?, ?> ... enumDefinitions) {
        this.require((Runnable)null, enumDefinitions);
    }

    private static class EnumDefinitionIterator
    extends AbstractIterator<EnumDefinition<?, ?>> {
        private final Iterator<EnumContainer> containerIterator;

        public EnumDefinitionIterator(Iterator<EnumContainer> containers) {
            this.containerIterator = containers;
            this.findFirst();
        }

        @Override
        protected EnumDefinition<?, ?> findNext() {
            if (this.containerIterator.hasNext()) {
                return this.containerIterator.next().enumDefinition;
            }
            return null;
        }
    }

    protected static class EnumContainer {
        private final EnumDefinition<?, ?> enumDefinition;
        private volatile List<?> allValues;
        private volatile List<?> activeValues;

        public EnumContainer(EnumDefinition<?, ?> enumDefinition) {
            this.enumDefinition = enumDefinition;
        }

        public EnumDefinition<?, ?> getEnumDefinition() {
            return this.enumDefinition;
        }

        public void setAllValues(List<?> values) {
            this.allValues = values;
            if (values == null) {
                this.activeValues = null;
            } else {
                ArrayList nonDeprecatedValues = new ArrayList(this.allValues.size());
                Boolean implementsDeprecated = null;
                for (Object value : this.allValues) {
                    if (implementsDeprecated == null) {
                        implementsDeprecated = value instanceof AttributeReadDeprecated;
                    }
                    boolean deprecated = false;
                    if (implementsDeprecated.booleanValue()) {
                        deprecated = ((AttributeReadDeprecated)value).isDeprecated();
                    }
                    if (deprecated) continue;
                    nonDeprecatedValues.add(value);
                }
                this.activeValues = Collections.unmodifiableList(nonDeprecatedValues);
            }
        }

        public List<?> getValues() {
            return this.activeValues;
        }
    }
}

