/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.Calendar;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.mmm.util.lang.api.CompareOperator;

final class ComparatorHelper {
    private ComparatorHelper() {
    }

    static Object convert(Object object, Class<?> otherType) {
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)object).toGregorianCalendar().getTime();
        }
        return object;
    }

    static boolean evalComparable(CompareOperator comparator, Comparable arg1, Comparable arg2) {
        int delta;
        Class<?> type2;
        Class<?> type1 = arg1.getClass();
        if (type1.equals(type2 = arg2.getClass()) || type1.isAssignableFrom(type2)) {
            delta = arg1.compareTo(arg2);
        } else if (type2.isAssignableFrom(type1)) {
            int compareTo = arg2.compareTo(arg1);
            delta = compareTo == Integer.MIN_VALUE ? Integer.MAX_VALUE : -compareTo;
        } else {
            return arg1.equals(arg2) == comparator.isTrueIfEquals();
        }
        if (delta == 0) {
            return comparator.isTrueIfEquals();
        }
        if (delta < 0) {
            return comparator.isTrueIfLess();
        }
        return comparator.isTrueIfGreater();
    }
}

