/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.lang.api.Direction;
import net.sf.mmm.util.lang.api.HorizontalAlignment;
import net.sf.mmm.util.lang.api.Orientation;
import net.sf.mmm.util.lang.api.SimpleDatatype;
import net.sf.mmm.util.lang.api.VerticalAlignment;

public enum Alignment implements SimpleDatatype<String>
{
    CENTER("-~", "center"){

        @Override
        public Alignment getMirrored() {
            return CENTER;
        }
    }
    ,
    TOP("^~", "top"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM;
        }
    }
    ,
    BOTTOM("_~", "bottom"){

        @Override
        public Alignment getMirrored() {
            return TOP;
        }
    }
    ,
    LEFT("--", "left"){

        @Override
        public Alignment getMirrored() {
            return RIGHT;
        }
    }
    ,
    RIGHT("-+", "right"){

        @Override
        public Alignment getMirrored() {
            return LEFT;
        }
    }
    ,
    TOP_LEFT("^-", "top left"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM_RIGHT;
        }
    }
    ,
    TOP_RIGHT("^+", "top right"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM_LEFT;
        }
    }
    ,
    BOTTOM_LEFT("_-", "bottom left"){

        @Override
        public Alignment getMirrored() {
            return TOP_RIGHT;
        }
    }
    ,
    BOTTOM_RIGHT("_+", "bottom right"){

        @Override
        public Alignment getMirrored() {
            return TOP_LEFT;
        }
    };

    private final String value;
    private final String title;

    private Alignment(String value, String title) {
        this.value = value;
        this.title = title;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.title;
    }

    public static Alignment fromValue(String value) {
        for (Alignment alignment : Alignment.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        if (this == TOP_LEFT || this == LEFT || this == BOTTOM_LEFT) {
            return HorizontalAlignment.LEFT;
        }
        if (this == TOP_RIGHT || this == RIGHT || this == BOTTOM_RIGHT) {
            return HorizontalAlignment.RIGHT;
        }
        return HorizontalAlignment.CENTER;
    }

    public VerticalAlignment getVerticalAlignment() {
        if (this == TOP_LEFT || this == TOP || this == TOP_RIGHT) {
            return VerticalAlignment.TOP;
        }
        if (this == BOTTOM_LEFT || this == BOTTOM || this == BOTTOM_RIGHT) {
            return VerticalAlignment.BOTTOM;
        }
        return VerticalAlignment.CENTER;
    }

    public Alignment getPart(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL) {
            return this.getHorizontalAlignment().getAlignment();
        }
        return this.getVerticalAlignment().getAlignment();
    }

    public abstract Alignment getMirrored();

    public Direction toDirection() {
        switch (this) {
            case BOTTOM: {
                return Direction.SOUTH;
            }
            case BOTTOM_LEFT: {
                return Direction.SOUTH_WEST;
            }
            case BOTTOM_RIGHT: {
                return Direction.SOUTH_EAST;
            }
            case CENTER: {
                return null;
            }
            case LEFT: {
                return Direction.WEST;
            }
            case RIGHT: {
                return Direction.EAST;
            }
            case TOP: {
                return Direction.NORTH;
            }
            case TOP_LEFT: {
                return Direction.NORTH_WEST;
            }
            case TOP_RIGHT: {
                return Direction.NORTH_EAST;
            }
        }
        throw new IllegalCaseException(Alignment.class, this);
    }

    public static Alignment fromDirection(Direction direction) {
        if (direction == null) {
            return CENTER;
        }
        switch (direction) {
            case EAST: {
                return RIGHT;
            }
            case WEST: {
                return LEFT;
            }
            case NORTH: {
                return BOTTOM;
            }
            case SOUTH: {
                return TOP;
            }
            case SOUTH_EAST: {
                return BOTTOM_RIGHT;
            }
            case SOUTH_WEST: {
                return BOTTOM_LEFT;
            }
            case NORTH_EAST: {
                return TOP_RIGHT;
            }
            case NORTH_WEST: {
                return TOP_LEFT;
            }
        }
        throw new IllegalCaseException(Direction.class, direction);
    }
}

