/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.api;

import java.lang.reflect.Method;
import javax.persistence.OptimisticLockException;
import net.sf.mmm.util.exception.NlsBundleUtilExceptionRoot;
import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.exception.api.OptimisticLockingExceptionHibernate;
import net.sf.mmm.util.exception.api.OptimisticLockingExceptionJpa;
import net.sf.mmm.util.exception.api.OptimisticLockingExceptionSpring;
import net.sf.mmm.util.reflect.api.ReflectionUtilLimited;
import org.hibernate.Hibernate;
import org.hibernate.StaleObjectStateException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public class OptimisticLockingException
extends NlsRuntimeException {
    private static final long serialVersionUID = 1L;

    public OptimisticLockingException(Throwable cause, Object entity, Object id) {
        super(cause, OptimisticLockingException.createBundle(NlsBundleUtilExceptionRoot.class).errorOptimisticLocking(entity, id));
    }

    static Object getId(Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            Method method = entity.getClass().getMethod("getId", ReflectionUtilLimited.NO_PARAMETERS);
            return method.invoke(entity, ReflectionUtilLimited.NO_ARGUMENTS);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static String getEntityRepresentation(Object entity) {
        Class<?> type;
        if (entity == null) {
            return null;
        }
        if (entity instanceof CharSequence) {
            String name = entity.toString();
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0) {
                return name.substring(lastDot + 1);
            }
            return name;
        }
        try {
            type = Hibernate.getClass((Object)entity);
        }
        catch (Throwable t) {
            type = entity.getClass();
        }
        return type.getSimpleName();
    }

    @Override
    public boolean isForUser() {
        return true;
    }

    public static OptimisticLockingException of(Throwable optimisticLockError) {
        if (optimisticLockError instanceof OptimisticLockingException) {
            return (OptimisticLockingException)optimisticLockError;
        }
        try {
            if (optimisticLockError instanceof StaleObjectStateException) {
                return new OptimisticLockingExceptionHibernate((StaleObjectStateException)optimisticLockError);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (optimisticLockError instanceof OptimisticLockException) {
                return new OptimisticLockingExceptionJpa((OptimisticLockException)optimisticLockError);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (optimisticLockError instanceof ObjectOptimisticLockingFailureException) {
                return new OptimisticLockingExceptionSpring((ObjectOptimisticLockingFailureException)optimisticLockError);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }
}

