/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.io.Serializable;
import net.sf.mmm.util.lang.api.EqualsChecker;
import net.sf.mmm.util.lang.api.HashCodeFunction;

public abstract class AbstractHashKey<T>
implements Serializable {
    private static final long serialVersionUID = -2858598306180975505L;
    private T delegate;
    private int hashCode;

    protected AbstractHashKey() {
    }

    public AbstractHashKey(T object) {
        this.delegate = object;
    }

    public T getDelegate() {
        return this.delegate;
    }

    protected abstract EqualsChecker<T> getEqualsChecker();

    protected abstract HashCodeFunction<T> getHashCodeFunction();

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = this.getHashCodeFunction().hashCode(this.delegate);
            if (hash == 0) {
                hash = 1;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        try {
            AbstractHashKey otherKey = (AbstractHashKey)other;
            return this.getEqualsChecker().isEqual(this.delegate, otherKey.delegate);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        if (this.delegate == null) {
            return "<null>";
        }
        return this.delegate.toString();
    }
}

