/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.property;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.IntrospectorPropertyResolver;

public class RegexPropertyResolver
extends IntrospectorPropertyResolver {
    private final Pattern readPattern;
    private final Pattern writePattern;
    private final boolean includeJavaBeans;
    private int writeMethodRegexCaptureGroupIndex;
    private int readMethodRegexCaptureGroupIndex;

    public RegexPropertyResolver(String readMethodRegex, String writeMethodRegex, boolean includeJavaBeans, boolean includePublicFields) {
        this(readMethodRegex, writeMethodRegex, includeJavaBeans, includePublicFields, 1, 1);
    }

    public RegexPropertyResolver(String readMethodRegex, String writeMethodRegex, boolean includeJavaBeans, boolean includePublicFields, int readMethodRegexCaptureGroupIndex, int writeMethodRegexCaptureGroupIndex) {
        super(includePublicFields);
        this.includeJavaBeans = includeJavaBeans;
        this.readPattern = Pattern.compile(readMethodRegex);
        this.writePattern = Pattern.compile(writeMethodRegex);
        this.readMethodRegexCaptureGroupIndex = readMethodRegexCaptureGroupIndex;
        this.writeMethodRegexCaptureGroupIndex = writeMethodRegexCaptureGroupIndex;
    }

    protected String uncapitalize(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
    }

    @Override
    protected void collectProperties(Class<?> type, Type<?> referenceType, Map<String, Property> properties) {
        LinkedHashMap<String, Property.Builder> collectedMethods = new LinkedHashMap<String, Property.Builder>();
        for (Method m : type.getMethods()) {
            Matcher writeMatcher;
            Property.Builder builder;
            String name;
            if (m.getParameterTypes().length == 0 && m.getReturnType() != null && m.getReturnType() != Void.TYPE) {
                Matcher readMatcher = this.readPattern.matcher(m.getName());
                if (!readMatcher.matches()) continue;
                name = readMatcher.group(this.readMethodRegexCaptureGroupIndex);
                if (name != null) {
                    builder = (Property.Builder)collectedMethods.get(name = this.uncapitalize(name));
                    if (builder == null) {
                        builder = new Property.Builder(TypeFactory.resolveValueOf(type, referenceType), name);
                        collectedMethods.put(name, builder);
                    }
                    builder.getter(m);
                    continue;
                }
                throw new IllegalStateException("the configured readMethod regex '" + this.readPattern + "' does not define group (1) containing the property's name");
            }
            if (m.getParameterTypes().length != 1 || !(writeMatcher = this.writePattern.matcher(m.getName())).matches()) continue;
            name = writeMatcher.group(this.writeMethodRegexCaptureGroupIndex);
            if (name != null) {
                builder = (Property.Builder)collectedMethods.get(name = this.uncapitalize(name));
                if (builder == null) {
                    builder = new Property.Builder(TypeFactory.resolveValueOf(type, referenceType), name);
                    collectedMethods.put(name, builder);
                }
                builder.setter(m);
                continue;
            }
            throw new IllegalStateException("the configured writeMethod regex '" + this.writePattern + "' does not define group (1) containing the property's name");
        }
        for (Map.Entry entry : collectedMethods.entrySet()) {
            Property property = ((Property.Builder)entry.getValue()).build(this);
            this.processProperty(property.getName(), (Class<?>)property.getType().getRawType(), ((Property.Builder)entry.getValue()).getReadMethod(), ((Property.Builder)entry.getValue()).getWriteMethod(), type, referenceType, properties);
        }
        if (this.includeJavaBeans) {
            super.collectProperties(type, referenceType, properties);
        }
    }
}

