/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

abstract class TypeUtil {
    private static final Set<Type<?>> IGNORED_TYPES = new HashSet<Type>(Arrays.asList(TypeFactory.valueOf(Cloneable.class), TypeFactory.valueOf(Serializable.class), TypeFactory.valueOf(Externalizable.class)));
    private static final Map<String, Class<?>> PRIMITIVES_CLASSES = new HashMap<String, Class<?>>(){
        {
            this.put(Boolean.TYPE.getName(), Boolean.TYPE);
            this.put(Short.TYPE.getName(), Short.TYPE);
            this.put(Integer.TYPE.getName(), Integer.TYPE);
            this.put(Long.TYPE.getName(), Long.TYPE);
            this.put(Float.TYPE.getName(), Float.TYPE);
            this.put(Double.TYPE.getName(), Double.TYPE);
        }
    };

    TypeUtil() {
    }

    static java.lang.reflect.Type[] resolveActualTypeArguments(ParameterizedType type, Type<?> reference) {
        return TypeUtil.resolveActualTypeArguments(((Class)type.getRawType()).getTypeParameters(), type.getActualTypeArguments(), reference);
    }

    static java.lang.reflect.Type[] resolveActualTypeArguments(TypeVariable<?>[] vars, java.lang.reflect.Type[] typeArguments, Type<?> reference) {
        int i;
        int len;
        java.lang.reflect.Type[] actualTypeArguments = new java.lang.reflect.Type[typeArguments.length];
        java.lang.reflect.Type[] defaultTypeArguments = new java.lang.reflect.Type[typeArguments.length];
        boolean hasUnresolvedTypes = false;
        Type<?> currentReference = reference;
        do {
            hasUnresolvedTypes = false;
            len = actualTypeArguments.length;
            for (i = 0; i < len; ++i) {
                java.lang.reflect.Type typeArg = typeArguments[i];
                TypeVariable var = vars[i];
                if (typeArg instanceof ParameterizedType || typeArg instanceof Class) {
                    actualTypeArguments[i] = TypeFactory.valueOf(typeArg);
                    continue;
                }
                if (typeArg instanceof TypeVariable) {
                    var = (TypeVariable)typeArg;
                }
                Type typeFromReference = null;
                Type<Object> targetReference = currentReference;
                while (!TypeFactory.TYPE_OF_OBJECT.equals(targetReference) && (typeFromReference = (Type)targetReference.getTypeByVariable(var)) == null) {
                    targetReference = TypeFactory.valueOf(((Class)targetReference.getRawType()).getGenericSuperclass());
                }
                if (typeFromReference != null && typeArg.equals(var)) {
                    if (actualTypeArguments[i] != null && (!(actualTypeArguments[i] instanceof Type) || !((Type)actualTypeArguments[i]).isAssignableFrom(typeFromReference))) continue;
                    actualTypeArguments[i] = typeFromReference;
                    continue;
                }
                Type typeFromArgument = TypeFactory.valueOf(typeArg);
                try {
                    defaultTypeArguments[i] = TypeUtil.getMostSpecificType(typeFromReference, typeFromArgument, IGNORED_TYPES);
                }
                catch (IllegalArgumentException e) {
                    defaultTypeArguments[i] = typeFromArgument;
                }
                if (defaultTypeArguments[i] != null && !defaultTypeArguments[i].equals(TypeFactory.TYPE_OF_OBJECT)) continue;
                hasUnresolvedTypes = true;
            }
            if (!hasUnresolvedTypes) continue;
            currentReference = currentReference.getSuperType();
        } while (hasUnresolvedTypes && !currentReference.equals(TypeFactory.TYPE_OF_OBJECT));
        len = actualTypeArguments.length;
        for (i = 0; i < len; ++i) {
            if (actualTypeArguments[i] != null) continue;
            actualTypeArguments[i] = defaultTypeArguments[i];
        }
        return actualTypeArguments;
    }

    static Type<?> getMostSpecificType(Type<?> type0, Type<?> type1) {
        return TypeUtil.getMostSpecificType(type0, type1, IGNORED_TYPES);
    }

    private static Type<?> getMostSpecificType(Type<?> type0, Type<?> type1, Set<Type<?>> ignoredTypes) {
        if (type1 == null && type0 == null) {
            return null;
        }
        if (type0 == null && type1 != null) {
            return type1;
        }
        if (type1 == null && type0 != null) {
            return type0;
        }
        if (type1 == null && type0 == null) {
            return null;
        }
        if (ignoredTypes.contains(type1) && ignoredTypes.contains(type0)) {
            return TypeFactory.TYPE_OF_OBJECT;
        }
        if (ignoredTypes.contains(type1)) {
            return type0;
        }
        if (ignoredTypes.contains(type0)) {
            return type1;
        }
        if (type0.isAssignableFrom(type1)) {
            return type1;
        }
        if (type1.isAssignableFrom(type0)) {
            return type0;
        }
        throw new IllegalArgumentException("types " + type0 + " and " + type1 + " are not comparable");
    }

    static Type<?>[] convertTypeArguments(Class<?> rawType, java.lang.reflect.Type[] actualTypeArguments, Set<java.lang.reflect.Type> recursiveBounds) {
        TypeVariable<Class<?>>[] typeVariables = rawType.getTypeParameters();
        Type[] resultTypeArguments = new Type[typeVariables.length];
        if (recursiveBounds.contains(rawType)) {
            return new Type[0];
        }
        if (actualTypeArguments.length == 0 && typeVariables.length > 0) {
            recursiveBounds.add(rawType);
            resultTypeArguments = TypeUtil.convertTypeArgumentsFromAncestry(rawType, recursiveBounds);
            recursiveBounds.remove(rawType);
        } else {
            if (actualTypeArguments.length < typeVariables.length) {
                throw new IllegalArgumentException("Must provide all type-arguments or none");
            }
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                java.lang.reflect.Type t = actualTypeArguments[i];
                if (t instanceof TypeVariable) {
                    recursiveBounds.add(rawType);
                    resultTypeArguments[i] = TypeFactory.limitedValueOf(t, recursiveBounds);
                    recursiveBounds.remove(rawType);
                    continue;
                }
                resultTypeArguments[i] = TypeFactory.limitedValueOf(t, recursiveBounds);
            }
        }
        return resultTypeArguments;
    }

    private static Type<?>[] convertTypeArgumentsFromAncestry(Class<?> rawType, Set<java.lang.reflect.Type> bounds) {
        LinkedHashMap typesByVariable = new LinkedHashMap();
        for (TypeVariable<Class<?>> var : rawType.getTypeParameters()) {
            typesByVariable.put(var, TypeFactory.limitedValueOf(var, bounds));
        }
        LinkedHashSet<java.lang.reflect.Type> genericAncestors = new LinkedHashSet<java.lang.reflect.Type>();
        genericAncestors.add(rawType.getGenericSuperclass());
        genericAncestors.add(rawType.getSuperclass());
        genericAncestors.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        genericAncestors.addAll(Arrays.asList(rawType.getInterfaces()));
        Iterator iter = genericAncestors.iterator();
        while (iter.hasNext()) {
            TypeVariable<Class<T>>[] variables;
            java.lang.reflect.Type superType;
            java.lang.reflect.Type ancestor = (java.lang.reflect.Type)iter.next();
            iter.remove();
            if (ancestor instanceof ParameterizedType) {
                superType = (ParameterizedType)ancestor;
                variables = ((Class)superType.getRawType()).getTypeParameters();
                java.lang.reflect.Type[] actuals = superType.getActualTypeArguments();
                for (int i = 0; i < variables.length; ++i) {
                    Type resolvedActual = TypeFactory.limitedValueOf(actuals[i], bounds);
                    TypeVariable var = actuals[i] instanceof TypeVariable ? actuals[i] : variables[i];
                    Type currentActual = (Type)typesByVariable.get(var);
                    if (currentActual == null) continue;
                    typesByVariable.put(var, TypeUtil.getMostSpecificType(currentActual, resolvedActual));
                }
                continue;
            }
            if (!(ancestor instanceof Class)) continue;
            superType = (Class)ancestor;
            variables = ((Class)superType).getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                Type resolvedActual = TypeFactory.limitedValueOf(variables[i], bounds);
                Type currentActual = (Type)typesByVariable.get(variables[i]);
                if (currentActual == null) continue;
                typesByVariable.put(variables[i], TypeUtil.getMostSpecificType(currentActual, resolvedActual));
            }
        }
        return typesByVariable.values().toArray(new Type[0]);
    }

    static Type<?> parseTypeDescriptor(String typeDescriptor) throws InvalidTypeDescriptorException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        StringBuilder descriptor = new StringBuilder(typeDescriptor);
        int split = descriptor.indexOf("<");
        if (split >= 0) {
            String className = descriptor.substring(0, split);
            if (!descriptor.subSequence(descriptor.length() - 1, descriptor.length()).equals(">")) {
                throw new InvalidTypeDescriptorException();
            }
            descriptor.setLength(descriptor.length() - 1);
            descriptor.replace(0, split + 1, "");
            String[] subDescriptors = TypeUtil.splitTypeArguments(descriptor.toString());
            java.lang.reflect.Type[] typeArguments = new Type[subDescriptors.length];
            int index = -1;
            for (String subDescriptor : subDescriptors) {
                typeArguments[++index] = TypeUtil.parseTypeDescriptor(subDescriptor);
            }
            return TypeFactory.valueOf(TypeUtil.loadClass(className, cl), typeArguments);
        }
        return TypeFactory.valueOf(TypeUtil.loadClass(typeDescriptor, cl));
    }

    private static String[] splitTypeArguments(String nestedTypes) {
        StringBuilder string = new StringBuilder(nestedTypes.replaceAll("\\s*", ""));
        ArrayList<String> arguments = new ArrayList<String>();
        while (string.length() > 0) {
            int nextComma = string.indexOf(",");
            int nextOpen = string.indexOf("<");
            if (nextComma == -1) {
                arguments.add(string.toString());
                string.setLength(0);
                continue;
            }
            if (nextOpen == -1 || nextComma < nextOpen) {
                arguments.add(string.substring(0, nextComma));
                string.replace(0, nextComma + 1, "");
                continue;
            }
            int depth = 1;
            int index = nextOpen;
            while (depth > 0 && index < string.length() - 1) {
                char nextChar;
                if ('<' == (nextChar = string.charAt(++index))) {
                    ++depth;
                    continue;
                }
                if ('>' != nextChar) continue;
                --depth;
            }
            arguments.add(string.substring(0, index + 1));
            string.replace(0, index + 1, "");
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private static Class<?> loadClass(String name, ClassLoader cl) {
        Class<?> cls = PRIMITIVES_CLASSES.get(name);
        if (cls != null) {
            return cls;
        }
        try {
            return Class.forName(name, false, cl);
        }
        catch (ClassNotFoundException e) {
            if (!name.contains(".")) {
                try {
                    return Class.forName("java.lang." + name, false, cl);
                }
                catch (ClassNotFoundException e1) {
                    try {
                        return Class.forName("java.util." + name, false, cl);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            } else {
                int lastDot = name.lastIndexOf(46);
                String modifiedName = name;
                while (lastDot > 0) {
                    modifiedName = modifiedName.substring(0, lastDot) + "$" + modifiedName.substring(lastDot + 1);
                    try {
                        return Class.forName(modifiedName, false, cl);
                    }
                    catch (ClassNotFoundException e2) {
                        lastDot = modifiedName.lastIndexOf(46);
                    }
                }
            }
            throw new IllegalArgumentException("'" + name + "' is non-existent or inaccessible");
        }
    }

    static class InvalidTypeDescriptorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTypeDescriptorException() {
        }
    }
}

