/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public class CaseInsensitiveClassMapBuilder<A, B>
extends ClassMapBuilder<A, B> {
    private Map<String, String> lowercasePropertiesForA = this.lowercasePropertiesFor(this.getAType());
    private Map<String, String> lowercasePropertiesForB = this.lowercasePropertiesFor(this.getBType());
    private boolean initialized = true;

    protected CaseInsensitiveClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
    }

    @Override
    public ClassMapBuilder<A, B> byDefault(MappingDirection direction, DefaultFieldMapper ... withDefaults) {
        super.byDefault(direction, withDefaults);
        for (String propertyNameA : this.getPropertiesForTypeA()) {
            String lowercaseName;
            if (this.getMappedPropertiesForTypeA().contains(propertyNameA) || !this.lowercasePropertiesForB.containsKey(lowercaseName = propertyNameA.toLowerCase())) continue;
            String propertyNameB = this.lowercasePropertiesForB.get(lowercaseName);
            if (this.getMappedPropertiesForTypeB().contains(propertyNameB) || propertyNameA.equals("class")) continue;
            this.fieldMap(propertyNameA, propertyNameB, true).direction(direction).add();
        }
        return this;
    }

    @Override
    protected Property resolveProperty(java.lang.reflect.Type type, String expr) {
        Map<String, String> lowercaseProps;
        String resolvedExpression;
        String expression = expr;
        if (this.initialized && (resolvedExpression = (lowercaseProps = type.equals(this.getAType()) ? this.lowercasePropertiesForA : this.lowercasePropertiesForB).get(expr.toLowerCase())) != null) {
            expression = resolvedExpression;
        }
        return super.resolveProperty(type, expression);
    }

    private Map<String, String> lowercasePropertiesFor(Type type) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String property : this.getPropertyExpressions(type).keySet()) {
            properties.put(property.toLowerCase(), property);
        }
        return properties;
    }

    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new CaseInsensitiveClassMapBuilder<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

