/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class StringToEnum
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getBType().isEnum() && fieldMap.getAType().isString();
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return "(Enum.valueOf(%s.class, \"\"+%s) == " + destination + ")";
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "converting String to enum " + destination.type());
        }
        String assignEnum = destination.assign("Enum.valueOf(%s.class, \"\"+%s)", destination.typeName(), source);
        String mapNull = StringToEnum.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", destination.assignIfPossible("null", new Object[0])) : "";
        return SourceCodeContext.statement("%s { %s; } %s", source.ifNotNull(), assignEnum, mapNull);
    }
}

