/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.TypeFactory;

public class ObjectToMultiOccurrenceElement
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return (fieldMap.getDestination().isMapKey() || fieldMap.getDestination().isArrayElement() || fieldMap.getDestination().isListElement()) && TypeFactory.TYPE_OF_OBJECT.equals(fieldMap.getDestination().getType());
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "mapping object to multi-occurrence element of type Object");
        }
        StringBuilder out = new StringBuilder();
        if (!source.isPrimitive()) {
            out.append(source.ifNotNull() + "{");
        }
        out.append(SourceCodeContext.statement(destination.assign(source), new Object[0]));
        if (!source.isPrimitive()) {
            out.append("}");
            if (ObjectToMultiOccurrenceElement.shouldMapNulls(fieldMap, code) && !destination.isPrimitive()) {
                SourceCodeContext.append(out, " else {\n", destination.assignIfPossible("null", new Object[0]), "}\n");
            }
        }
        return out.toString();
    }
}

