/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class CopyByReference
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().getType().isImmutable() && fieldMap.getDestination().isAssignableFrom(fieldMap.getSource());
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (source.type().isPrimitive() || source.type().isPrimitiveWrapper()) {
            return source + " == " + destination;
        }
        return source + ".equals(" + destination + ")";
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "copying " + source.elementTypeName() + " by reference");
        }
        StringBuilder out = new StringBuilder();
        if (!source.isPrimitive()) {
            out.append(source.ifNotNull() + "{");
        }
        out.append(SourceCodeContext.statement(destination.assign(source), new Object[0]));
        if (!source.isPrimitive()) {
            out.append("\n }");
            if (CopyByReference.shouldMapNulls(fieldMap, code) && !destination.isPrimitive()) {
                SourceCodeContext.append(out, " else {", destination.assignIfPossible("null", new Object[0]), "\n }");
            }
        }
        return out.toString();
    }
}

