/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.externalprocess;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.exception.InputReaderException;
import com.devonfw.cobigen.api.extension.InputReader;
import com.devonfw.cobigen.api.externalprocess.ExternalProcess;
import com.devonfw.cobigen.api.externalprocess.to.InputFileTo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class ExternalServerInputReaderProxy
implements InputReader {
    protected ExternalProcess externalProcess;

    public ExternalServerInputReaderProxy(ExternalProcess externalProcess) {
        this.externalProcess = externalProcess;
    }

    public boolean isValidInput(Object input) {
        throw new CobiGenRuntimeException("This method should be implemented in Java for performance reasons!");
    }

    public Object read(Path path, Charset inputCharset, Object ... additionalArguments) throws InputReaderException {
        String fileContents;
        String fileName = path.toString();
        try {
            fileContents = String.join((CharSequence)"", Files.readAllLines(path, inputCharset));
        }
        catch (IOException e) {
            throw new InputReaderException("Could not read input file!" + fileName, (Throwable)e);
        }
        InputFileTo inputFile = new InputFileTo(fileName, fileContents, inputCharset.name());
        return this.externalProcess.postJsonRequest("getInputModel", inputFile);
    }

    public boolean isMostLikelyReadable(Path path) {
        throw new CobiGenRuntimeException("This method should be implemented in Java for performance reasons!");
    }
}

