/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplatesJarUtil {
    static FilenameFilter fileNameFilterJar = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lowercaseName = name.toLowerCase();
            String regex = "templates-([^-]+)-(\\d+\\.?)+.jar$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(lowercaseName);
            return m.find();
        }
    };
    static FilenameFilter fileNameFilterSources = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lowercaseName = name.toLowerCase();
            String regex = "templates-([^-]+)-(\\d+\\.?)+-sources.jar$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(lowercaseName);
            return m.find();
        }
    };

    private static String downloadJar(String groupId, String artifactId, String version, boolean isDownloadSource, File templatesDirectory) {
        String fileName;
        block13: {
            if (version.isEmpty() || version == null) {
                version = "LATEST";
            }
            String mavenUrl = "https://repository.sonatype.org/service/local/artifact/maven/redirect?r=central-proxy&g=" + groupId + "&a=" + artifactId + "&v=" + version;
            if (isDownloadSource) {
                mavenUrl = mavenUrl + "&c=sources";
            }
            fileName = "";
            File[] jarFiles = isDownloadSource ? templatesDirectory.listFiles(fileNameFilterSources) : templatesDirectory.listFiles(fileNameFilterJar);
            try {
                if (jarFiles.length <= 0 || TemplatesJarUtil.isJarOutdated(jarFiles[0], mavenUrl, isDownloadSource, templatesDirectory)) {
                    HttpURLConnection conn = TemplatesJarUtil.initializeConnection(mavenUrl);
                    try (InputStream inputStream = conn.getInputStream();){
                        fileName = conn.getURL().getFile().substring(conn.getURL().getFile().lastIndexOf("/") + 1);
                        File file = new File(templatesDirectory.getPath() + File.separator + fileName);
                        Path targetPath = file.toPath();
                        if (!file.exists()) {
                            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    conn.disconnect();
                    break block13;
                }
                fileName = jarFiles[0].getPath().substring(jarFiles[0].getPath().lastIndexOf(File.separator) + 1);
            }
            catch (IOException e) {
                throw new CobiGenRuntimeException("Could not download file from " + mavenUrl, e);
            }
        }
        return fileName;
    }

    public static String downloadLatestDevon4jTemplates(boolean isDownloadSource, File templatesDirectory) {
        return TemplatesJarUtil.downloadJar("com.devonfw.cobigen", "templates-devon4j", "LATEST", isDownloadSource, templatesDirectory);
    }

    private static boolean isJarOutdated(File jarFile, String mavenUrl, boolean isDownloadSource, File templatesDirectory) throws MalformedURLException, ProtocolException, IOException {
        String fileName = jarFile.getPath().substring(jarFile.getPath().lastIndexOf(File.separator) + 1);
        Matcher m = TemplatesJarUtil.matchJarVersion(fileName, isDownloadSource);
        if (!m.find() || m.group(2).isEmpty()) {
            return true;
        }
        int[] versionNumbers = Arrays.stream(m.group(2).split("\\.")).mapToInt(Integer::parseInt).toArray();
        HttpURLConnection conn = TemplatesJarUtil.initializeConnection(mavenUrl);
        try (InputStream inputStream = conn.getInputStream();){
            String latestJar = conn.getURL().getFile().substring(conn.getURL().getFile().lastIndexOf("/") + 1);
            m = TemplatesJarUtil.matchJarVersion(latestJar, isDownloadSource);
        }
        if (!m.find() || m.group(2).isEmpty()) {
            return false;
        }
        int[] versionNumbersLatest = Arrays.stream(m.group(2).split("\\.")).mapToInt(Integer::parseInt).toArray();
        for (int i = 0; i < versionNumbersLatest.length; ++i) {
            if (versionNumbersLatest[i] <= versionNumbers[i]) continue;
            if (!isDownloadSource) {
                TemplatesJarUtil.downloadLatestDevon4jTemplates(true, templatesDirectory);
            }
            jarFile.delete();
            return true;
        }
        return false;
    }

    private static Matcher matchJarVersion(String fileName, boolean isDownloadSource) {
        String lowercaseName = fileName.toLowerCase();
        String regex = "templates-([^-]+)-(\\d+|\\d+(\\.\\d+)*)?\\.jar$";
        if (isDownloadSource) {
            regex = "templates-([^-]+)-(\\d+|\\d+(\\.\\d+)*)?\\-sources.jar$";
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(lowercaseName);
        return m;
    }

    private static HttpURLConnection initializeConnection(String mavenUrl) throws MalformedURLException, IOException, ProtocolException {
        URL url = new URL(mavenUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        return conn;
    }

    public static File getJarFile(boolean isSource, File templatesDirectory) {
        File[] jarFiles = isSource ? templatesDirectory.listFiles(fileNameFilterSources) : templatesDirectory.listFiles(fileNameFilterJar);
        if (jarFiles.length > 0) {
            return jarFiles[0];
        }
        return null;
    }
}

