/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.utils;

import com.devonfw.cobigen.cli.CobiGenCLI;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginUpdateUtil {
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);

    public static String latestPluginVersion(String artificialDependency) {
        String mavenUrl = "https://repo.maven.apache.org/maven2/com/devonfw/cobigen/" + artificialDependency + "/maven-metadata.xml";
        HttpURLConnection conn = PluginUpdateUtil.initializeConnection(mavenUrl);
        Document document = null;
        DocumentBuilder builder = null;
        String latestVersionString = "";
        try (InputStream inputStream = conn.getInputStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            document = builder.parse(inputStream);
            NodeList nList = document.getElementsByTagName("metadata");
            for (int i = 0; i <= nList.getLength(); ++i) {
                Node mainNode = nList.item(i);
                if (mainNode == null || mainNode.getNodeType() != 1) continue;
                Element firstElement = (Element)mainNode;
                NodeList forumidNameList = firstElement.getElementsByTagName("versioning");
                for (int j = 0; j < forumidNameList.getLength(); ++j) {
                    Element value = (Element)forumidNameList.item(j);
                    NodeList conditionList = value.getElementsByTagName("latest");
                    for (int k = 0; k < conditionList.getLength(); ++k) {
                        Element condition = (Element)conditionList.item(k);
                        latestVersionString = condition.getFirstChild().getNodeValue();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error while creating an input stream to read Maven metadata file. Please try again.", (Throwable)e);
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error("Not able to parse the Maven metadata file in order to find the latest plug-in version. Please check your connection and try again", (Throwable)e);
        }
        return latestVersionString;
    }

    private static HttpURLConnection initializeConnection(String mavenUrl) {
        URL url = null;
        HttpURLConnection conn = null;
        try {
            url = new URL(mavenUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
        }
        catch (IOException e) {
            LOG.error("Not able to initialize connection to Maven Central. Please check your connection and try again.", (Throwable)e);
        }
        return conn;
    }
}

