/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeKey;
import ma.glasnost.orika.metadata.TypeUtil;

public abstract class TypeFactory {
    private static final ConcurrentHashMap<TypeKey, WeakReference<Type<?>>> typeCache = new ConcurrentHashMap();
    public static final Type<Object> TYPE_OF_OBJECT = TypeFactory.valueOf(Object.class);

    private TypeFactory() {
    }

    public static <E> Type<E> valueOf(Class<E> rawType) {
        if (rawType == null) {
            return null;
        }
        if (rawType.isAnonymousClass() && rawType.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuper = (ParameterizedType)rawType.getGenericSuperclass();
            return TypeFactory.valueOf(genericSuper);
        }
        return TypeFactory.intern(rawType, new java.lang.reflect.Type[0], new HashSet<java.lang.reflect.Type>());
    }

    public static Type<?> valueOf(String typeDescriptor) {
        try {
            return TypeUtil.parseTypeDescriptor(typeDescriptor);
        }
        catch (TypeUtil.InvalidTypeDescriptorException e) {
            throw new IllegalArgumentException(typeDescriptor + " is an invalid type descriptor");
        }
    }

    public static <E> Type<E> valueOf(Class<E> rawType, java.lang.reflect.Type ... actualTypeArguments) {
        if (rawType == null) {
            return null;
        }
        return TypeFactory.intern(rawType, actualTypeArguments, new HashSet<java.lang.reflect.Type>());
    }

    public static <T> Type<T> valueOf(Type<T> type) {
        return type;
    }

    public static <T> Type<T> valueOf(ParameterizedType type) {
        return TypeFactory.valueOf((Class)type.getRawType(), type.getActualTypeArguments());
    }

    public static <T> Type<T> valueOf(TypeVariable<?> var) {
        if (var.getBounds().length > 0) {
            HashSet bounds = new HashSet(var.getBounds().length);
            int len = var.getBounds().length;
            for (int i = 0; i < len; ++i) {
                java.lang.reflect.Type bound = var.getBounds()[i];
                if (TypeFactory.isBoundCycleGenerics(var, bound)) {
                    bounds.add(TYPE_OF_OBJECT);
                    continue;
                }
                bounds.add(TypeFactory.valueOf(bound));
            }
            return TypeFactory.refineBounds(bounds);
        }
        return TYPE_OF_OBJECT;
    }

    private static boolean isBoundCycleGenerics(TypeVariable<?> var, java.lang.reflect.Type bound) {
        if (bound instanceof ParameterizedType) {
            ParameterizedType parameterizedBound = (ParameterizedType)bound;
            if (var.getGenericDeclaration().equals(parameterizedBound.getRawType())) {
                return true;
            }
        }
        return false;
    }

    public static <T> Type<T> valueOf(WildcardType var) {
        int i;
        HashSet bounds = new HashSet(var.getUpperBounds().length + var.getLowerBounds().length);
        int len = var.getUpperBounds().length;
        for (i = 0; i < len; ++i) {
            bounds.add(TypeFactory.valueOf(var.getUpperBounds()[i]));
        }
        len = var.getLowerBounds().length;
        for (i = 0; i < len; ++i) {
            bounds.add(TypeFactory.valueOf(var.getLowerBounds()[i]));
        }
        return TypeFactory.refineBounds(bounds);
    }

    public static <T> Type<T> valueOf(java.lang.reflect.Type type) {
        if (type instanceof Type) {
            return (Type)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeFactory.valueOf((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return TypeFactory.valueOf((Class)type);
        }
        if (type instanceof TypeVariable) {
            return TypeFactory.valueOf((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return TypeFactory.valueOf((WildcardType)type);
        }
        throw new IllegalArgumentException(type + " is an unsupported type");
    }

    public static <T> Type<T> resolveValueOf(ParameterizedType type, Type<?> referenceType) {
        if (type == null) {
            return null;
        }
        java.lang.reflect.Type[] actualTypeArguments = TypeUtil.resolveActualTypeArguments(type, referenceType);
        return TypeFactory.intern((Class)type.getRawType(), actualTypeArguments, new HashSet<java.lang.reflect.Type>());
    }

    public static <T> Type<T> resolveValueOf(Class<T> type, Type<?> referenceType) {
        if (type == null) {
            return null;
        }
        if (type.getTypeParameters() != null && type.getTypeParameters().length > 0) {
            java.lang.reflect.Type[] actualTypeArguments = TypeUtil.resolveActualTypeArguments(type.getTypeParameters(), type.getTypeParameters(), referenceType);
            return TypeFactory.valueOf(type, actualTypeArguments);
        }
        return TypeFactory.valueOf(type);
    }

    public static String nameOf(java.lang.reflect.Type type, java.lang.reflect.Type associatedType) {
        String shortAscTypeName;
        String longAscTypeName;
        String[] parts;
        String shortTypeName;
        String longTypeName;
        if (type instanceof Type) {
            longTypeName = ((Type)type).toFullyQualifiedString();
            shortTypeName = type.toString();
        } else if (type instanceof Class) {
            longTypeName = ((Class)type).getCanonicalName();
            shortTypeName = ((Class)type).getSimpleName();
        } else {
            longTypeName = String.valueOf(type);
            parts = longTypeName.split("\\s+");
            longTypeName = parts[parts.length - 1];
            parts = longTypeName.split("[.]");
            shortTypeName = parts[parts.length - 1];
        }
        if (associatedType instanceof Type) {
            longAscTypeName = ((Type)associatedType).toFullyQualifiedString();
            shortAscTypeName = associatedType.toString();
        } else if (associatedType instanceof Class) {
            longAscTypeName = ((Class)associatedType).getCanonicalName();
            shortAscTypeName = ((Class)associatedType).getSimpleName();
        } else {
            longAscTypeName = String.valueOf(associatedType);
            parts = longAscTypeName.split("\\s+");
            longAscTypeName = parts[parts.length - 1];
            parts = longAscTypeName.split("[.]");
            shortAscTypeName = parts[parts.length - 1];
        }
        if (shortTypeName.equals(shortAscTypeName) && !longTypeName.equals(longAscTypeName)) {
            return longTypeName;
        }
        return shortTypeName;
    }

    static <T> Type<T> limitedValueOf(java.lang.reflect.Type type, Set<java.lang.reflect.Type> recursiveBounds) {
        if (type instanceof Type) {
            return (Type)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeFactory.limitedValueOf((ParameterizedType)type, recursiveBounds);
        }
        if (type instanceof Class) {
            return TypeFactory.limitedValueOf((Class)type, recursiveBounds, new java.lang.reflect.Type[0]);
        }
        if (type instanceof TypeVariable) {
            return TypeFactory.limitedValueOf((TypeVariable)type, recursiveBounds);
        }
        if (type instanceof WildcardType) {
            return TypeFactory.limitedValueOf((WildcardType)type, recursiveBounds);
        }
        throw new IllegalArgumentException(type + " is an unsupported type");
    }

    static <T> Type<T> limitedValueOf(TypeVariable<?> var, Set<java.lang.reflect.Type> recursiveBounds) {
        if (var.getBounds().length > 0) {
            HashSet bounds = new HashSet(var.getBounds().length);
            int len = var.getBounds().length;
            for (int i = 0; i < len; ++i) {
                bounds.add(TypeFactory.limitedValueOf(var.getBounds()[i], recursiveBounds));
            }
            return TypeFactory.refineBounds(bounds);
        }
        return TYPE_OF_OBJECT;
    }

    private static <T> Type<T> limitedValueOf(WildcardType var, Set<java.lang.reflect.Type> recursiveBounds) {
        int i;
        HashSet bounds = new HashSet(var.getUpperBounds().length + var.getLowerBounds().length);
        int len = var.getUpperBounds().length;
        for (i = 0; i < len; ++i) {
            bounds.add(TypeFactory.limitedValueOf(var.getUpperBounds()[i], recursiveBounds));
        }
        len = var.getLowerBounds().length;
        for (i = 0; i < len; ++i) {
            bounds.add(TypeFactory.limitedValueOf(var.getLowerBounds()[i], recursiveBounds));
        }
        return TypeFactory.refineBounds(bounds);
    }

    private static <T> Type<T> limitedValueOf(ParameterizedType type, Set<java.lang.reflect.Type> recursiveBounds) {
        return TypeFactory.limitedValueOf((Class)type.getRawType(), recursiveBounds, type.getActualTypeArguments());
    }

    private static <E> Type<E> limitedValueOf(Class<E> rawType, Set<java.lang.reflect.Type> recursiveBounds, java.lang.reflect.Type ... actualTypeArguments) {
        if (rawType == null) {
            return null;
        }
        if (rawType.isAnonymousClass() && rawType.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuper = (ParameterizedType)rawType.getGenericSuperclass();
            return TypeFactory.limitedValueOf(genericSuper, recursiveBounds);
        }
        return TypeFactory.intern(rawType, actualTypeArguments, recursiveBounds);
    }

    private static Type<?> refineBounds(Set<Type<?>> bounds) {
        Type<?> currentMostSpecific = null;
        for (Type<?> currentBound : bounds) {
            if (currentMostSpecific == null) {
                currentMostSpecific = currentBound;
                continue;
            }
            currentMostSpecific = TypeUtil.getMostSpecificType(currentMostSpecific, currentBound);
        }
        return currentMostSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Type<T> intern(Class<T> rawType, java.lang.reflect.Type[] typeArguments, Set<java.lang.reflect.Type> recursiveBounds) {
        java.lang.reflect.Type[] convertedArguments = TypeUtil.convertTypeArguments(rawType, typeArguments, recursiveBounds);
        TypeKey key = TypeKey.valueOf(rawType, convertedArguments);
        WeakReference<Type<Object>> mapped = typeCache.get(key);
        Type typeResult = null;
        if (mapped != null) {
            typeResult = (Type)mapped.get();
        }
        if (typeResult == null) {
            Class<T> clazz = rawType;
            synchronized (clazz) {
                WeakReference<Type<?>> existing;
                mapped = typeCache.get(key);
                if (mapped != null) {
                    typeResult = (Type)mapped.get();
                }
                if (typeResult == null && (existing = typeCache.putIfAbsent(key, mapped = new WeakReference<Type<T>>(typeResult = TypeFactory.createType(key, rawType, convertedArguments)))) != null) {
                    if (existing.get() == null) {
                        typeCache.put(key, mapped);
                    } else {
                        mapped = existing;
                        typeResult = (Type)mapped.get();
                    }
                }
            }
        }
        return typeResult;
    }

    private static <T> Type<T> createType(TypeKey key, Class<T> rawType, Type<?>[] typeArguments) {
        HashMap typesByVariable = null;
        if (typeArguments.length > 0) {
            typesByVariable = new HashMap(typeArguments.length);
            int len = typeArguments.length;
            for (int i = 0; i < len; ++i) {
                typesByVariable.put(rawType.getTypeParameters()[i].getName(), typeArguments[i]);
            }
        }
        return new Type(key, rawType, typesByVariable, typeArguments);
    }
}

