/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class StringToStringConvertible
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return String.class.equals((Object)fieldMap.getSource().getType().getRawType()) && (fieldMap.getDestination().getType().isPrimitive() || fieldMap.getDestination().getType().isPrimitiveWrapper());
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return "(" + source.notNull() + " && " + source + ".equals(\"\" + " + destination + "))";
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "converting from String to " + destination.type());
        }
        String value = source.toString();
        if (String.class.equals(source.rawType()) && (Character.class.equals(destination.rawType()) || Character.TYPE.equals(destination.rawType()))) {
            value = value + ".charAt(0)";
        }
        if (destination.isPrimitive()) {
            return SourceCodeContext.statement(destination.assign("%s.valueOf(%s)", destination.wrapperTypeName(), value), new Object[0]);
        }
        String mapNull = StringToStringConvertible.shouldMapNulls(fieldMap, code) ? String.format(" else { %s; }", destination.assignIfPossible("null", new Object[0])) : "";
        return SourceCodeContext.statement(String.format("%s {\n %s; } %s", source.ifNotNull(), destination.assign("%s.valueOf(%s)", destination.typeName(), value), mapNull), new Object[0]);
    }
}

