/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.Converter;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.Type;

public class ConvertArrayOrCollectionToCollection
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        if (fieldMap.getConverterId() != null) {
            Converter<Object, Object> converter = this.mapperFactory.getConverterFactory().getConverter(fieldMap.getConverterId());
            if (fieldMap.getDestination().isCollection() && (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection())) {
                Type<Object> sourceElementType = fieldMap.getSource().isArray() ? fieldMap.getAType().getComponentType() : fieldMap.getAType().getNestedType(0);
                Type destElementType = fieldMap.getBType().getNestedType(0);
                if (converter.getAType().isAssignableFrom(sourceElementType) && converter.getBType().isAssignableFrom(destElementType) && (!converter.getAType().isAssignableFrom(fieldMap.getAType()) || !converter.getBType().isAssignableFrom(fieldMap.getBType()))) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "converting to Collection using " + source.getConverter());
        }
        StringBuilder convertCollection = new StringBuilder();
        MultiOccurrenceVariableRef moSource = MultiOccurrenceVariableRef.from(source);
        MultiOccurrenceVariableRef moDest = MultiOccurrenceVariableRef.from(destination);
        String assureInstanceExists = String.format("if((%s)) { \n %s; \n}", destination.isNull(), destination.assign(code.newObject(source, destination.type()), new Object[0]));
        SourceCodeContext.append(convertCollection, moSource.declareIterator(), "while(" + moSource.iteratorHasNext() + ") {", String.format("%s.add(%s.convert((%s)%s, %s, mappingContext))", moDest, code.usedConverter(source.getConverter()), moSource.elementTypeName(), moSource.nextElement(), code.usedType(destination)), "}");
        String mapNull = ConvertArrayOrCollectionToCollection.shouldMapNulls(fieldMap, code) ? String.format(" else { %s; }", destination.assignIfPossible("null", new Object[0])) : "";
        return String.format(" %s { %s; %s; } %s", source.ifNotNull(), assureInstanceExists, convertCollection, mapNull);
    }
}

