/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.converter.builtin.CopyByReferenceConverter;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class Convert
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getConverterId() != null || this.mapperFactory.getConverterFactory().canConvert(fieldMap.getAType(), fieldMap.getBType());
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (source.getConverter() instanceof CopyByReferenceConverter) {
            if (destination.type().isPrimitive() && source.type().isPrimitive()) {
                return String.format("(%s == %s)", destination, source);
            }
            if (destination.type().isPrimitive()) {
                return String.format("(%s != null && %s == %s.%sValue())", source, destination, source, source.type().getName());
            }
            if (source.type().isPrimitive()) {
                return String.format("(%s != null && %s.%sValue() == %s)", destination, destination, destination.type().getPrimitiveType().getName(), source);
            }
            return String.format("(%s != null && %s.equals(%s))", source, source, destination);
        }
        if (destination.type().isPrimitive()) {
            String wrapper = source.asWrapper();
            String wrapperType = destination.type().getWrapperType().getSimpleName();
            String primitive = destination.type().getName();
            return String.format("(%s == ((%s)%s.convert(%s, %s, mappingContext)).%sValue())", destination, wrapperType, code.usedConverter(source.getConverter()), wrapper, code.usedType(destination), primitive);
        }
        if (source.type().isPrimitive()) {
            return String.format("(%s == %s.convert(%s, %s, mappingContext))", destination.asWrapper(), code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
        }
        return String.format("(%s != null && %s.equals(%s.convert(%s, %s, mappingContext)))", destination, destination, code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        boolean canHandleNulls;
        String statement;
        if (source.getConverter() instanceof CopyByReferenceConverter) {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "copying " + source.type() + " by reference");
            }
            statement = destination.assignIfPossible(source);
            canHandleNulls = true;
        } else {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "converting using " + source.getConverter());
            }
            statement = destination.assignIfPossible("%s.convert(%s, %s, mappingContext)", code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
            canHandleNulls = false;
        }
        boolean shouldSetNull = Convert.shouldMapNulls(fieldMap, code) && !destination.isPrimitive();
        String destinationNotNull = destination.ifPathNotNull();
        if (!source.isNullPossible() || canHandleNulls && shouldSetNull && "".equals(destinationNotNull)) {
            return SourceCodeContext.statement(statement, new Object[0]);
        }
        String elseSetNull = shouldSetNull ? " else " + destinationNotNull + "{ \n" + destination.assignIfPossible("null", new Object[0]) + ";\n }" : "";
        return SourceCodeContext.statement(source.ifNotNull() + "{ \n" + statement, new Object[0]) + "\n}" + elseSetNull;
    }
}

