/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.metadata.Type;

public class NonCyclicMappingContext
extends MappingContext {
    protected NonCyclicMappingContext(Map<Object, Object> globalProperties) {
        super(globalProperties);
    }

    @Override
    public <S, D> void cacheMappedObject(S source, Type<Object> destinationType, D destination) {
    }

    @Override
    public <D> D getMappedObject(Object source, Type<?> destinationType) {
        return null;
    }

    public static class Factory
    implements MappingContextFactory {
        final LinkedBlockingQueue<MappingContext> contextQueue = new LinkedBlockingQueue();
        final Map<Object, Object> globalProperties;

        public Factory(Map<Object, Object> globalProperties) {
            this.globalProperties = globalProperties;
        }

        @Override
        public MappingContext getContext() {
            MappingContext context = this.contextQueue.poll();
            if (context == null) {
                context = new NonCyclicMappingContext(this.globalProperties);
            }
            context.containsCycle(false);
            return context;
        }

        @Override
        public void release(MappingContext context) {
            context.reset();
            this.contextQueue.offer(context);
        }

        @Override
        public Map<Object, Object> getGlobalProperties() {
            return this.globalProperties;
        }
    }
}

