/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.Arrays;
import java.util.List;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.StateReporter;
import ma.glasnost.orika.impl.DefaultMapperFactory;

public class ExceptionUtility {
    public static List<String> corePackages = Arrays.asList("java.", "javax.", "sun.", "sunw.", "com.sun.", "com.ibm.", "javassist.", "com.thoughtworks.paranamer.");
    private DefaultMapperFactory mapperFactory;
    private boolean reportStateOnException;

    public ExceptionUtility(DefaultMapperFactory mapperFactory, boolean reportStateOnException) {
        this.mapperFactory = mapperFactory;
        this.reportStateOnException = reportStateOnException;
    }

    public MappingException newMappingException(String message, Throwable cause) {
        return this.decorate(new MappingException(message, cause));
    }

    public MappingException newMappingException(String message) {
        return this.newMappingException(message, null);
    }

    public MappingException newMappingException(Throwable cause) {
        return this.decorate(new MappingException(cause));
    }

    public MappingException decorate(MappingException me) {
        if (this.reportStateOnException && !me.containsStateReport()) {
            StringBuilder report = new StringBuilder();
            StateReporter.reportCurrentState(report, this.mapperFactory);
            report.replace(0, "\n-------------------------------------------------------------".length(), "\n-----begin dump of current state-----------------------------");
            report.append("\n-----end dump of current state-------------------------------");
            me.setStateReport(report.toString());
        }
        return me;
    }

    public static boolean originatedByOrika(Throwable t) {
        for (StackTraceElement ste : t.getStackTrace()) {
            if (ExceptionUtility.isJreClass(ste.getClassName())) continue;
            return ExceptionUtility.isOrikaClass(ste.getClassName());
        }
        return false;
    }

    private static boolean isOrikaClass(String className) {
        return className.startsWith("ma.glasnost.orika.") && !className.startsWith("ma.glasnost.orika.test.");
    }

    private static boolean isJreClass(String className) {
        for (String pkg : corePackages) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

