/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl;

import java.util.Iterator;
import net.sf.mmm.util.collection.base.AbstractIterator;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.resource.impl.ClasspathFile;

class ClassIterator
extends AbstractIterator<Class<?>> {
    private final Iterator<ClasspathFile> classpathFiles;
    private final Filter<String> classnameFilter;
    private final Filter<Class<?>> classFilter;

    public ClassIterator(Iterator<ClasspathFile> classpathFiles, Filter<String> classnameFilter, Filter<Class<?>> classFilter) {
        this.classpathFiles = classpathFiles;
        this.classnameFilter = classnameFilter;
        this.classFilter = classFilter;
        this.findFirst();
    }

    @Override
    protected Class<?> findNext() {
        ClasspathFile classpathFile = null;
        while (this.classpathFiles.hasNext()) {
            Class<?> javaClass;
            classpathFile = this.classpathFiles.next();
            String qualifiedName = classpathFile.getQualifiedName();
            if (qualifiedName == null || !this.classnameFilter.accept(qualifiedName) || !this.classFilter.accept(javaClass = classpathFile.getJavaClass())) continue;
            return javaClass;
        }
        return null;
    }
}

