/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl;

import java.util.Date;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourcePath;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.base.AbstractBrowsableResource;
import net.sf.mmm.util.resource.impl.ClasspathFolder;

abstract class AbstractBrowsableClasspathResource
extends AbstractBrowsableResource
implements ResourcePath {
    private static final String EXTENSION_CLASS = ".class";
    private final ClasspathFolder parent;
    final String name;
    private final String qualifiedName;

    AbstractBrowsableClasspathResource(ClasspathFolder parent, String name) {
        this.parent = parent;
        this.name = name;
        this.qualifiedName = this.isData() ? (name.endsWith(EXTENSION_CLASS) ? parent.getQualifiedName() + "." + name.substring(0, name.length() - EXTENSION_CLASS.length()) : null) : (parent == null ? "" : (parent.parent == null ? name : parent.getQualifiedName() + "." + name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public ClasspathFolder getParent() {
        return this.parent;
    }

    @Override
    public DataResource navigate(String resourcePath) throws ResourceUriUndefinedException {
        return this.parent.navigate(resourcePath);
    }

    @Override
    public Date getLastModificationDate() {
        return null;
    }

    @Override
    public String getSchemePrefix() {
        return "classpath:";
    }

    @Override
    public String getUri() {
        return this.getSchemePrefix() + this.getPath();
    }

    @Override
    public ClasspathFolder getRoot() {
        if (this.parent == null) {
            return (ClasspathFolder)this;
        }
        return this.parent.getRoot();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public String getPath() {
        StringBuilder buffer = new StringBuilder();
        this.getPath(buffer);
        return buffer.toString();
    }

    protected void getPath(StringBuilder buffer) {
        if (this.parent != null && !this.parent.isRoot()) {
            this.parent.getPath(buffer);
            buffer.append('/');
        }
        buffer.append(this.name);
    }

    public abstract Iterable<? extends AbstractBrowsableClasspathResource> getChildResources();

    protected void init() {
        for (AbstractBrowsableClasspathResource abstractBrowsableClasspathResource : this.getChildResources()) {
            abstractBrowsableClasspathResource.init();
        }
    }
}

