/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TransferQueue;
import javassist.Modifier;
import javax.inject.Inject;
import net.sf.mmm.util.collection.api.CollectionFactory;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.impl.CollectionFactoryManagerImpl;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.lang.api.GenericBean;
import net.sf.mmm.util.reflect.api.AccessFailedException;
import net.sf.mmm.util.reflect.api.CollectionReflectionUtil;
import net.sf.mmm.util.reflect.api.InstantiationFailedException;
import net.sf.mmm.util.reflect.base.ContainerGrowthException;
import net.sf.mmm.util.reflect.base.UnknownCollectionInterfaceException;

public class CollectionReflectionUtilImpl
extends AbstractLoggableComponent
implements CollectionReflectionUtil {
    public static final int DEFAULT_MAXIMUM_LIST_GROWTH = 128;
    private static final Class<?>[] CAPACITY_CONSTRUCTOR_ARGS = new Class[]{Integer.TYPE};
    private static CollectionReflectionUtilImpl instance;
    private CollectionFactoryManager collectionFactoryManager;
    private int maximumListGrowth = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionReflectionUtilImpl getInstance() {
        if (instance != null) return instance;
        Class<CollectionReflectionUtilImpl> clazz = CollectionReflectionUtilImpl.class;
        synchronized (CollectionReflectionUtilImpl.class) {
            if (instance != null) return instance;
            CollectionReflectionUtilImpl util = new CollectionReflectionUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.collectionFactoryManager == null) {
            this.collectionFactoryManager = CollectionFactoryManagerImpl.getInstance();
        }
    }

    @Override
    public CollectionFactoryManager getCollectionFactoryManager() {
        return this.collectionFactoryManager;
    }

    @Inject
    public void setCollectionFactoryManager(CollectionFactoryManager collectionFactoryManager) {
        this.getInitializationState().requireNotInitilized();
        this.collectionFactoryManager = collectionFactoryManager;
    }

    public int getMaximumListGrowth() {
        return this.maximumListGrowth;
    }

    public void setMaximumListGrowth(int maximumListGrowth) {
        this.getInitializationState().requireNotInitilized();
        this.maximumListGrowth = maximumListGrowth;
    }

    @Override
    public <C extends Collection> C create(Class<C> type) {
        return this.create(type, null);
    }

    @Override
    public <C extends Collection> C create(Class<C> type, int capacity) {
        return this.create(type, (Integer)capacity);
    }

    protected <C extends Collection<?>> C create(Class<C> type, Integer capacity) {
        Class<? extends Collection> collectionInterface;
        if (type.isInterface()) {
            CollectionFactory<C> factory = this.getCollectionFactoryManager().getCollectionFactory(type);
            if (factory == null) {
                throw new UnknownCollectionInterfaceException(type);
            }
            if (capacity == null) {
                return factory.createGeneric();
            }
            return factory.createGeneric(capacity);
        }
        if (Modifier.isAbstract((int)type.getModifiers()) && (collectionInterface = this.findCollectionInterface(type)) != Collection.class) {
            return (C)this.create((Class<C>)collectionInterface, capacity);
        }
        try {
            if (capacity != null) {
                try {
                    Constructor<C> constructor = type.getConstructor(CAPACITY_CONSTRUCTOR_ARGS);
                    return (C)((Collection)constructor.newInstance(capacity));
                }
                catch (Exception e) {
                    this.getLogger().debug("Failed to create collection via capacitory constructor.", (Throwable)e);
                }
            }
            return (C)((Collection)type.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new AccessFailedException((Throwable)e, type);
        }
        catch (Exception e) {
            throw new InstantiationFailedException((Throwable)e, type);
        }
    }

    protected Class<? extends Collection> findCollectionInterface(Class<? extends Collection> type) {
        if (type.isInterface()) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return List.class;
        }
        if (Queue.class.isAssignableFrom(type)) {
            if (BlockingDeque.class.isAssignableFrom(type)) {
                return BlockingDeque.class;
            }
            if (Deque.class.isAssignableFrom(type)) {
                return Deque.class;
            }
            if (BlockingQueue.class.isAssignableFrom(type)) {
                return BlockingQueue.class;
            }
            if (TransferQueue.class.isAssignableFrom(type)) {
                return TransferQueue.class;
            }
            return Queue.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            if (NavigableSet.class.isAssignableFrom(type)) {
                return NavigableSet.class;
            }
            if (SortedSet.class.isAssignableFrom(type)) {
                return SortedSet.class;
            }
            return Set.class;
        }
        return Collection.class;
    }

    @Override
    public <C extends Map> C createMap(Class<C> type) {
        return this.createMap(type, null);
    }

    @Override
    public <C extends Map> C createMap(Class<C> type, int capacity) {
        return this.createMap(type, (Integer)capacity);
    }

    protected <C extends Map<?, ?>> C createMap(Class<C> type, Integer capacity) {
        if (type.isInterface()) {
            MapFactory factory = this.getCollectionFactoryManager().getMapFactory(type);
            if (factory == null) {
                throw new UnknownCollectionInterfaceException(type);
            }
            if (capacity == null) {
                return (C)factory.createGeneric();
            }
            return (C)factory.createGeneric(capacity);
        }
        if (Modifier.isAbstract((int)type.getModifiers())) {
            Class<? extends Map> collectionInterface = this.findMapInterface(type);
            return (C)this.createMap((Class<C>)collectionInterface, capacity);
        }
        try {
            if (capacity != null) {
                try {
                    Constructor<C> constructor = type.getConstructor(CAPACITY_CONSTRUCTOR_ARGS);
                    return (C)((Map)constructor.newInstance(capacity));
                }
                catch (Exception e) {
                    this.getLogger().debug("Failed to create map via capacitory constructor.", (Throwable)e);
                }
            }
            return (C)((Map)type.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new AccessFailedException((Throwable)e, type);
        }
        catch (Exception e) {
            throw new InstantiationFailedException((Throwable)e, type);
        }
    }

    protected Class<? extends Map> findMapInterface(Class<? extends Map> type) {
        if (type.isInterface()) {
            return type;
        }
        if (ConcurrentNavigableMap.class.isAssignableFrom(type)) {
            return ConcurrentNavigableMap.class;
        }
        if (NavigableMap.class.isAssignableFrom(type)) {
            return NavigableMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentMap.class;
        }
        return Map.class;
    }

    @Override
    public boolean isArrayOrList(Object object) {
        if (object == null) {
            throw new NlsIllegalArgumentException((Object)null);
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(type);
    }

    @Override
    public int getSize(Object arrayMapOrCollection) throws NlsIllegalArgumentException {
        if (arrayMapOrCollection == null) {
            throw new NlsIllegalArgumentException((Object)null);
        }
        Class<?> type = arrayMapOrCollection.getClass();
        if (type.isArray()) {
            return Array.getLength(arrayMapOrCollection);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ((Collection)arrayMapOrCollection).size();
        }
        if (Map.class.isAssignableFrom(type)) {
            return ((Map)arrayMapOrCollection).size();
        }
        throw new NlsIllegalArgumentException(arrayMapOrCollection);
    }

    @Override
    public Object get(Object arrayOrList, int index) throws NlsIllegalArgumentException {
        return this.get(arrayOrList, index, true);
    }

    @Override
    public Object get(Object arrayOrList, int index, boolean ignoreIndexOverflow) throws NlsIllegalArgumentException {
        if (arrayOrList == null) {
            throw new NlsNullPointerException("arrayOrList");
        }
        Class<?> type = arrayOrList.getClass();
        if (type.isArray()) {
            int length;
            if (ignoreIndexOverflow && index >= (length = Array.getLength(arrayOrList))) {
                return null;
            }
            return Array.get(arrayOrList, index);
        }
        if (List.class.isAssignableFrom(type)) {
            List list = (List)arrayOrList;
            if (ignoreIndexOverflow && index >= list.size()) {
                return null;
            }
            return list.get(index);
        }
        throw new NlsIllegalArgumentException(arrayOrList);
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item) throws NlsIllegalArgumentException {
        return this.set(arrayOrList, index, item, null, this.maximumListGrowth);
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item, GenericBean<Object> arrayReceiver) throws NlsIllegalArgumentException {
        return this.set(arrayOrList, index, item, arrayReceiver, this.maximumListGrowth);
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item, GenericBean<Object> arrayReceiver, int maximumGrowth) throws NlsIllegalArgumentException {
        int growth;
        int size;
        if (arrayOrList == null) {
            throw new NlsNullPointerException("arrayOrList");
        }
        int maxGrowth = maximumGrowth;
        Class<?> type = arrayOrList.getClass();
        List list = null;
        if (type.isArray()) {
            size = Array.getLength(arrayOrList);
            if (arrayReceiver == null) {
                maxGrowth = 0;
            }
        } else if (List.class.isAssignableFrom(type)) {
            list = (List)arrayOrList;
            size = list.size();
        } else {
            throw new NlsIllegalArgumentException(arrayOrList);
        }
        if ((growth = index - size + 1) > maxGrowth) {
            throw new ContainerGrowthException(growth, maxGrowth);
        }
        if (type.isArray()) {
            if (growth > 0) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Increasing array size by " + growth);
                }
                Object newArray = Array.newInstance(type.getComponentType(), index + 1);
                System.arraycopy(arrayOrList, 0, newArray, 0, size);
                Array.set(newArray, index, item);
                arrayReceiver.setValue(newArray);
                return null;
            }
            Object old = Array.get(arrayOrList, index);
            Array.set(arrayOrList, index, item);
            return old;
        }
        if (growth > 0) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Increasing list size by " + growth);
            }
            --growth;
            while (growth > 0) {
                list.add(null);
                --growth;
            }
            list.add(item);
            return null;
        }
        return list.set(index, item);
    }

    @Override
    public Object add(Object arrayOrCollection, Object item) {
        if (arrayOrCollection == null) {
            throw new NlsIllegalArgumentException((Object)null);
        }
        Class<?> type = arrayOrCollection.getClass();
        if (type.isArray()) {
            int size = Array.getLength(arrayOrCollection);
            Object newArray = Array.newInstance(type.getComponentType(), size + 1);
            System.arraycopy(arrayOrCollection, 0, newArray, 0, size);
            Array.set(newArray, size, item);
            return newArray;
        }
        if (!Collection.class.isAssignableFrom(type)) {
            throw new NlsIllegalArgumentException(arrayOrCollection);
        }
        Collection collection = (Collection)arrayOrCollection;
        collection.add(item);
        return arrayOrCollection;
    }

    @Override
    public Object remove(Object arrayOrCollection, Object item) {
        if (arrayOrCollection == null) {
            throw new NlsIllegalArgumentException((Object)null);
        }
        Class<?> type = arrayOrCollection.getClass();
        if (type.isArray()) {
            int size = Array.getLength(arrayOrCollection);
            for (int index = 0; index < size; ++index) {
                Object currentItem = Array.get(arrayOrCollection, index);
                if (item != currentItem && (item == null || !item.equals(currentItem))) continue;
                Object newArray = Array.newInstance(type.getComponentType(), size - 1);
                System.arraycopy(arrayOrCollection, 0, newArray, 0, index);
                System.arraycopy(arrayOrCollection, index + 1, newArray, index, size - index - 1);
                return newArray;
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)arrayOrCollection;
            boolean removed = collection.remove(item);
            if (removed) {
                return arrayOrCollection;
            }
            return null;
        }
        throw new NlsIllegalArgumentException(arrayOrCollection);
    }

    @Override
    public Object toArray(Collection<?> collection, Class<?> componentType) throws ClassCastException {
        if (componentType == null) {
            throw new NlsNullPointerException("componentType");
        }
        if (collection == null) {
            return null;
        }
        int length = collection.size();
        Object array = Array.newInstance(componentType, length);
        Iterator<?> iterator = collection.iterator();
        int i = 0;
        if (componentType.isPrimitive()) {
            while (iterator.hasNext()) {
                Array.set(array, i++, iterator.next());
            }
        } else {
            Object[] objectArray = (Object[])array;
            while (iterator.hasNext()) {
                objectArray[i++] = iterator.next();
            }
        }
        return array;
    }

    @Override
    public <T> T[] toArrayTyped(Collection<T> collection, Class<T> componentType) {
        return (Object[])this.toArray(collection, componentType);
    }
}

