/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.api;

import java.lang.reflect.Method;
import net.sf.mmm.util.reflect.api.ReflectionUtilLimited;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;

public class Signature {
    public static final Signature VOID = new Signature(ReflectionUtilLimited.NO_PARAMETERS);
    private final Class<?>[] signature;
    private final int hash;

    public Signature(Class<?> ... theSignature) {
        this(0, theSignature);
    }

    protected Signature(int hash, Class<?> ... theSignature) {
        this.signature = theSignature;
        int hashcode = hash;
        for (int i = 0; i < this.signature.length; ++i) {
            if (this.signature[i] == null) continue;
            hashcode = 31 * hashcode + this.signature[i].hashCode();
        }
        hashcode <<= 2;
        this.hash = hashcode |= this.signature.length;
    }

    public Signature(Method method) {
        this(method.getParameterTypes());
    }

    public Signature(Object ... arguments) {
        this(ReflectionUtilImpl.getInstance().getClasses(arguments));
    }

    public boolean isApplicable(Signature s) {
        if (this.signature.length == s.signature.length) {
            for (int i = 0; i < this.signature.length; ++i) {
                Class<?> type = s.signature[i];
                if (type == null || this.signature[i].isAssignableFrom(type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getTypeCount() {
        return this.signature.length;
    }

    public Class<?> getType(int position) {
        return this.signature[position];
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            Signature s = (Signature)other;
            if (this.signature.length == s.signature.length) {
                for (int i = 0; i < this.signature.length; ++i) {
                    if (this.signature[i] == s.signature[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append('(');
        if (this.signature.length > 0) {
            buffer.append(this.signature[0]);
        }
        for (int i = 1; i < this.signature.length; ++i) {
            buffer.append(", ");
            buffer.append(this.signature[i]);
        }
        buffer.append(')');
    }
}

