/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import javax.inject.Inject;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeDetector;
import net.sf.mmm.util.lang.base.datatype.adapter.jackson.DatatypeJsonSerializer;

public class DatatypeJsonSerializers
extends SimpleSerializers {
    private static final long serialVersionUID = 1L;
    private DatatypeDescriptorManager datatypeDescriptorManager;
    private DatatypeDetector datatypeDetector;
    private DatatypeJsonSerializer<?> datatypeJsonSerializer;

    @Inject
    public void setDatatypeDescriptorManager(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
        this.datatypeJsonSerializer = new DatatypeJsonSerializer(this.datatypeDescriptorManager);
    }

    @Inject
    public void setDatatypeDetector(DatatypeDetector datatypeDetector) {
        this.datatypeDetector = datatypeDetector;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class datatype;
        DatatypeJsonSerializer<?> serializer = super.findSerializer(config, type, beanDesc);
        if (serializer == null && this.datatypeDetector.isDatatype(datatype = type.getRawClass()) && !this.datatypeDetector.isJavaStandardDatatype(datatype)) {
            serializer = this.datatypeJsonSerializer;
        }
        return serializer;
    }
}

