/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import net.sf.mmm.util.lang.api.DatatypeDescriptor;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeSegmentDescriptor;

public class DatatypeJsonSerializer<T>
extends JsonSerializer<T> {
    private DatatypeDescriptorManager datatypeDescriptorManager;

    public DatatypeJsonSerializer() {
    }

    public DatatypeJsonSerializer(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    @Inject
    public void setDatatypeDescriptorManager(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    public <V> void serializeGeneric(V value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        DatatypeDescriptor<?> descriptor = this.datatypeDescriptorManager.getDatatypeDescriptor(type);
        List<DatatypeSegmentDescriptor<?, ?>> segmentList = descriptor.getSegmentDescriptors();
        int segmentCount = segmentList.size();
        if (segmentCount == 0) {
            jgen.writeObject(value);
        } else if (segmentCount == 1) {
            Object segment = descriptor.getSegment(value, 0);
            this.serializeGeneric(segment, jgen, provider);
        } else {
            jgen.writeStartObject();
            for (DatatypeSegmentDescriptor<?, ?> segment : segmentList) {
                Object segmentValue = segment.getSegment(value);
                if (segmentValue == null) {
                    assert (segment.isOptional());
                    continue;
                }
                jgen.writeFieldName(segment.getName());
                this.serializeGeneric(segmentValue, jgen, provider);
            }
            jgen.writeEndObject();
        }
    }

    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        this.serializeGeneric(value, jgen, provider);
    }
}

