/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.sf.mmm.util.lang.api.SystemInformation;

public class SystemInformationImpl
implements SystemInformation {
    private static final Set<String> X86_ARCHITECTURES = new HashSet<String>(Arrays.asList("x86", "x64", "i286", "i386", "i486", "i568", "i686", "amd64", "pentium", "ia-16", "ia-32", "ia-64", "ia16", "ia32", "ia64"));
    private final String systemName;
    private final String systemVersion;
    private final String systemArchitecture;
    private final String systemType;
    private final boolean limitedDevice;

    public SystemInformationImpl() {
        this.systemName = System.getProperty("os.name");
        this.systemVersion = System.getProperty("os.version");
        this.systemArchitecture = System.getProperty("os.arch");
        this.systemType = SystemInformationImpl.detectSystemType(null, this.systemName, true);
        this.limitedDevice = SystemInformationImpl.detectLimitedDevice(this.systemName, this.systemArchitecture, true);
    }

    public SystemInformationImpl(String systemName, String systemVersion, String systemArchitecture) {
        this(systemName, systemVersion, systemArchitecture, null, null);
    }

    public SystemInformationImpl(String systemName, String systemVersion, String systemArchitecture, String systemType) {
        this(systemName, systemVersion, systemArchitecture, systemType, null);
    }

    public SystemInformationImpl(String systemName, String systemVersion, String systemArchitecture, String systemType, boolean limitedDevice) {
        this(systemName, systemVersion, systemArchitecture, systemType, (Boolean)limitedDevice);
    }

    private SystemInformationImpl(String systemName, String systemVersion, String systemArchitecture, String systemType, Boolean limitedDevice) {
        this.systemName = SystemInformationImpl.getNotEmpty(systemName);
        this.systemVersion = SystemInformationImpl.getNotEmpty(systemVersion);
        this.systemType = SystemInformationImpl.detectSystemType(systemType, this.systemName, false);
        this.systemArchitecture = SystemInformationImpl.detectArchitecture(systemArchitecture, this.systemName, this.systemVersion, this.systemType);
        this.limitedDevice = limitedDevice == null ? SystemInformationImpl.detectLimitedDevice(this.systemName, this.systemArchitecture, false) : limitedDevice;
    }

    private static String getNotEmpty(String string) {
        if (SystemInformationImpl.isEmpty(string)) {
            return "unknown";
        }
        return string;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.equals("unknown");
    }

    private static String detectArchitecture(String systemArchitecture, String systemName, String systemVersion, String systemType) {
        if (!SystemInformationImpl.isEmpty(systemArchitecture)) {
            return systemArchitecture;
        }
        if (systemType.equals("iOS")) {
            return "arm";
        }
        return "unknown";
    }

    private static String detectSystemType(String systemType, String osName, boolean currentSystem) {
        if (!SystemInformationImpl.isEmpty(systemType)) {
            return systemType;
        }
        if (SystemInformationImpl.isEmpty(osName)) {
            return "unknown";
        }
        String os = osName.toLowerCase(Locale.US).trim();
        if (os.startsWith("windows")) {
            return "Windows";
        }
        if (os.startsWith("mac")) {
            return "Mac OS";
        }
        if (os.startsWith("ios")) {
            return "iOS";
        }
        if (os.contains("linux")) {
            return "Linux";
        }
        if (os.contains("bsd")) {
            return "BSD";
        }
        if (os.contains("solaris") || os.contains("hp-ux") || os.contains("nix") || os.contains("aix") || os.contains("nextstep") || os.contains("sorix") || os.contains("irix")) {
            return "UNIX";
        }
        if (os.startsWith("z/") || os.startsWith("os/360") || os.startsWith("os/390") || os.startsWith("os/400") || os.startsWith("bs2000") || os.startsWith("mvs") || os.startsWith("aix") || os.startsWith("tpf") || os.equals("cms")) {
            return "Mainfraime";
        }
        return "unknown";
    }

    private static boolean detectLimitedDevice(String osName, String osArchitecture, boolean currentSystem) {
        String vmName;
        String os = osName.toLowerCase(Locale.US).trim();
        if (os.contains("windows ce")) {
            return true;
        }
        if (os.contains("darvin")) {
            return true;
        }
        if (os.contains("android")) {
            return true;
        }
        if (os.contains("phone")) {
            return true;
        }
        if (os.contains("firefox os")) {
            return true;
        }
        if (os.contains("bada")) {
            return true;
        }
        if (os.contains("sailfish")) {
            return true;
        }
        if (os.contains("tvos")) {
            return true;
        }
        if (os.startsWith("ios")) {
            return true;
        }
        if (os.contains("iphone")) {
            return true;
        }
        if (os.contains("nintendo")) {
            return true;
        }
        if (os.contains("wii")) {
            return true;
        }
        if (os.contains("xbox")) {
            return true;
        }
        if (os.contains("playstation")) {
            return true;
        }
        if (os.startsWith("rim ")) {
            return true;
        }
        String arch = osArchitecture.toLowerCase(Locale.US).trim();
        if (arch.equals("arm")) {
            return true;
        }
        return currentSystem && (vmName = System.getProperty("java.vm.name").toLowerCase(Locale.US)).contains("dalvik");
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public String getSystemArchitecture() {
        return this.systemArchitecture;
    }

    @Override
    public String getSystemVersion() {
        return this.systemVersion;
    }

    @Override
    public String getSystemType() {
        return this.systemType;
    }

    @Override
    public boolean isLimitedDevice() {
        return this.limitedDevice;
    }

    @Override
    public boolean isX86() {
        if (X86_ARCHITECTURES.contains(this.systemArchitecture)) {
            return true;
        }
        for (String indicator : X86_ARCHITECTURES) {
            if (!this.systemArchitecture.contains(indicator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is64Bit() {
        return this.systemArchitecture.endsWith("64");
    }
}

