/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.lang.api.Datatype;
import net.sf.mmm.util.lang.api.DatatypeDetector;

public abstract class AbstractDatatypeDetector
extends AbstractLoggableComponent
implements DatatypeDetector {
    private final Set<String> customDatatypeSet = new HashSet<String>();
    private final Set<String> standardDatatypeSet = new HashSet<String>();

    protected void registerCustomDatatype(Class<?> datatype) {
        this.customDatatypeSet.add(datatype.getName());
    }

    protected void registerCustomDatatype(String fullQualifiedDatatypeName) {
        this.customDatatypeSet.add(fullQualifiedDatatypeName);
    }

    protected void registerStandardDatatype(Class<?> datatype) {
        this.standardDatatypeSet.add(datatype.getName());
    }

    protected void registerStandardDatatype(String fullQualifiedDatatypeName) {
        this.standardDatatypeSet.add(fullQualifiedDatatypeName);
    }

    protected void registerDefaultDatatypes() {
        this.registerStandardDatatype(String.class);
        this.registerStandardDatatype(Boolean.class);
        this.registerStandardDatatype(Character.class);
        this.registerStandardDatatype(Currency.class);
        this.registerCustomDatatype(Datatype.class);
        this.registerNumberDatatypes();
        this.registerJavaTimeDatatypes();
        this.registerJavaUtilDateCalendarDatatypes();
    }

    protected void registerNumberDatatypes() {
        this.registerStandardDatatype(Integer.class);
        this.registerStandardDatatype(Long.class);
        this.registerStandardDatatype(Double.class);
        this.registerStandardDatatype(Float.class);
        this.registerStandardDatatype(Byte.class);
        this.registerStandardDatatype(Short.class);
        this.registerStandardDatatype(BigInteger.class);
        this.registerStandardDatatype(BigDecimal.class);
        this.registerStandardDatatype(Number.class);
    }

    protected void registerJavaUtilDateCalendarDatatypes() {
        this.registerStandardDatatype(Date.class);
        this.registerStandardDatatype("java.util.Calendar");
    }

    protected void registerJavaTimeDatatypes() {
        this.registerStandardDatatype("java.time.LocalTime");
        this.registerStandardDatatype("java.time.LocalDate");
        this.registerStandardDatatype("java.time.LocalDateTime");
        this.registerStandardDatatype("java.time.MonthDay");
        this.registerStandardDatatype("java.time.Year");
        this.registerStandardDatatype("java.time.YearMonth");
        this.registerStandardDatatype("java.time.Instant");
        this.registerStandardDatatype("java.time.Duration");
        this.registerStandardDatatype("java.time.Period");
        this.registerStandardDatatype("java.time.OffsetTime");
        this.registerStandardDatatype("java.time.OffsetDate");
        this.registerStandardDatatype("java.time.OffsetDateTime");
        this.registerStandardDatatype("java.time.ZoneId");
        this.registerStandardDatatype("java.time.ZonedDateTime");
        this.registerStandardDatatype("java.time.ZoneOffset");
        this.registerStandardDatatype("java.time.ZoneRegion");
    }

    @Override
    public boolean isDatatype(Class<?> type) {
        if (type.isEnum()) {
            return true;
        }
        if (this.isJavaStandardDatatype(type)) {
            return true;
        }
        return this.customDatatypeSet.contains(type.getName());
    }

    @Override
    public boolean isJavaStandardDatatype(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return this.standardDatatypeSet.contains(type.getName());
    }

    public void setExtraDatatypes(List<String> datatypeList) {
        this.getInitializationState().requireNotInitilized();
        for (String fqn : datatypeList) {
            this.registerCustomDatatype(fqn);
        }
    }
}

