/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.filter.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.sf.mmm.util.filter.api.FilterRule;
import net.sf.mmm.util.filter.base.FilterRuleChain;
import net.sf.mmm.util.filter.base.PatternFilterRule;

public class FilterRuleChainPlainParser {
    private char acceptChar = (char)43;
    private char denyChar = (char)45;
    private char commentChar = (char)35;

    public char getAcceptChar() {
        return this.acceptChar;
    }

    public void setAcceptChar(char acceptChar) {
        this.acceptChar = acceptChar;
    }

    public char getDenyChar() {
        return this.denyChar;
    }

    public void setDenyChar(char denyChar) {
        this.denyChar = denyChar;
    }

    public char getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar;
    }

    public FilterRuleChain<String> parse(Reader reader, boolean defaultResult) throws IOException {
        return this.parse(new BufferedReader(reader), defaultResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRuleChain<String> parse(BufferedReader reader, boolean defaultResult) throws IOException {
        try {
            int lineCount = 0;
            ArrayList<PatternFilterRule> rules = new ArrayList<PatternFilterRule>();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    ++lineCount;
                    char first = line.charAt(0);
                    if (first == this.acceptChar || first == this.denyChar) {
                        String regex = line.substring(1);
                        boolean accept = first == this.acceptChar;
                        PatternFilterRule rule = new PatternFilterRule(regex, accept);
                        rules.add(rule);
                    } else if (first != this.commentChar) {
                        throw new IllegalArgumentException("Illegal start character '" + first + "' in line " + lineCount + "!");
                    }
                }
                line = reader.readLine();
            }
            FilterRule[] ruleArray = rules.toArray(new FilterRule[rules.size()]);
            FilterRuleChain<String> filterRuleChain = new FilterRuleChain<String>(defaultResult, ruleArray);
            return filterRuleChain;
        }
        finally {
            reader.close();
        }
    }
}

