/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.api;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.UUID;
import net.sf.mmm.util.exception.api.ExceptionTruncation;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.exception.api.ThrowableHelper;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.uuid.api.UuidAccess;

public abstract class NlsRuntimeException
extends RuntimeException
implements NlsThrowable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private NlsMessage nlsMessage;
    private UUID uuid;

    protected NlsRuntimeException() {
    }

    public NlsRuntimeException(NlsMessage message) {
        this.nlsMessage = message;
        this.uuid = this.createUuid();
    }

    public NlsRuntimeException(String internationalizedMessage) {
        this(null, internationalizedMessage);
    }

    public NlsRuntimeException(Throwable cause, String internationalizedMessage) {
        this(cause, NlsAccess.getFactory().create(internationalizedMessage));
    }

    public NlsRuntimeException(Throwable cause, NlsMessage message) {
        super(cause);
        this.nlsMessage = message;
        this.uuid = cause != null && cause instanceof NlsThrowable ? ((NlsThrowable)((Object)cause)).getUuid() : this.createUuid();
    }

    protected NlsRuntimeException(NlsRuntimeException copySource, ExceptionTruncation truncation) {
        super(null, truncation.isRemoveCause() ? null : copySource.getCause());
        this.nlsMessage = copySource.nlsMessage;
        this.uuid = copySource.uuid;
        if (!truncation.isRemoveStacktrace()) {
            this.setStackTrace(copySource.getStackTrace());
        }
        if (!truncation.isRemoveSuppressed()) {
            for (Throwable suppressed : copySource.getSuppressed()) {
                this.addSuppressed(suppressed);
            }
        }
    }

    protected UUID createUuid() {
        return UuidAccess.getFactory().createUuid();
    }

    @Override
    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public final NlsMessage getNlsMessage() {
        return this.nlsMessage;
    }

    @Override
    public void printStackTrace(Locale locale, Appendable buffer) {
        NlsRuntimeException.printStackTrace(this, locale, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printStackTrace(NlsThrowable throwable, Locale locale, Appendable buffer) {
        try {
            Appendable appendable = buffer;
            synchronized (appendable) {
                buffer.append(throwable.getClass().getName());
                buffer.append(": ");
                throwable.getLocalizedMessage(locale, buffer);
                buffer.append(StringUtil.LINE_SEPARATOR);
                UUID uuid = throwable.getUuid();
                if (uuid != null) {
                    buffer.append(uuid.toString());
                    buffer.append(StringUtil.LINE_SEPARATOR);
                }
                StackTraceElement[] trace = throwable.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    buffer.append("\tat ");
                    buffer.append(trace[i].toString());
                    buffer.append(StringUtil.LINE_SEPARATOR);
                }
                for (Throwable suppressed : ((Throwable)((Object)throwable)).getSuppressed()) {
                    buffer.append("Suppressed: ");
                    buffer.append(StringUtil.LINE_SEPARATOR);
                    NlsRuntimeException.printStackTraceCause(suppressed, locale, buffer);
                }
                Throwable cause = throwable.getCause();
                if (cause != null) {
                    buffer.append("Caused by: ");
                    buffer.append(StringUtil.LINE_SEPARATOR);
                    NlsRuntimeException.printStackTraceCause(cause, locale, buffer);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void printStackTraceCause(Throwable cause, Locale locale, Appendable buffer) throws IOException {
        if (cause instanceof NlsThrowable) {
            ((NlsThrowable)((Object)cause)).printStackTrace(locale, buffer);
        } else if (buffer instanceof PrintStream) {
            cause.printStackTrace((PrintStream)buffer);
        } else if (buffer instanceof PrintWriter) {
            cause.printStackTrace((PrintWriter)buffer);
        } else {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            cause.printStackTrace(printWriter);
            printWriter.flush();
            buffer.append(writer.toString());
        }
    }

    @Override
    public String getMessage() {
        StringBuilder buffer = new StringBuilder(this.getNlsMessage().getMessage());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.uuid);
        String code = this.getCode();
        if (!this.getClass().getSimpleName().equals(code)) {
            buffer.append(":");
            buffer.append(code);
        }
        return buffer.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getNlsMessage().getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getNlsMessage().getLocalizedMessage(locale);
    }

    @Override
    public void getLocalizedMessage(Locale locale, Appendable appendable) {
        this.getNlsMessage().getLocalizedMessage(locale, appendable);
    }

    @Override
    public NlsMessage toNlsMessage() {
        return this.getNlsMessage();
    }

    protected static <BUNDLE extends NlsBundle> BUNDLE createBundle(Class<BUNDLE> bundleInterface) {
        return NlsAccess.getBundleFactory().createBundle(bundleInterface);
    }

    @Override
    public boolean isTechnical() {
        return true;
    }

    @Override
    public boolean isForUser() {
        return !this.isTechnical();
    }

    @Override
    public String getCode() {
        return this.getClass().getSimpleName();
    }

    protected NlsRuntimeException createCopyViaClone(ExceptionTruncation truncation) {
        try {
            NlsRuntimeException copy = (NlsRuntimeException)this.clone();
            ThrowableHelper.removeDetails(copy, truncation);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NlsRuntimeException createCopy(ExceptionTruncation truncation) {
        return this.createCopyViaClone(truncation);
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault(), null).toString();
    }

    @Override
    public String toString(Locale locale) {
        return this.toString(locale, null).toString();
    }

    @Override
    public Appendable toString(Locale locale, Appendable appendable) {
        Appendable buffer = appendable;
        if (buffer == null) {
            buffer = new StringBuilder(32);
        }
        try {
            Class<?> myClass = this.getClass();
            buffer.append(myClass.getName());
            buffer.append(": ");
            String code = this.getCode();
            if (!myClass.getSimpleName().equals(code)) {
                buffer.append(code);
                buffer.append(": ");
            }
            buffer.append(this.getLocalizedMessage(locale));
            if (this.uuid != null) {
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(this.uuid.toString());
            }
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }
}

