/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.fallback.video;

import android.net.Uri;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import com.devbrackets.android.exomedia.fallback.FallbackMediaPlayer;
import com.devbrackets.android.exomedia.fallback.FallbackMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001qB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u000fH\u0016J\b\u0010G\u001a\u00020EH\u0016J\b\u0010H\u001a\u00020EH\u0016J\u0010\u0010I\u001a\u00020E2\u0006\u0010J\u001a\u00020\u001aH\u0016J\u0010\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020\u0013H\u0016J\u0010\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020\u0013H\u0016J\b\u0010O\u001a\u00020EH\u0016J\u0012\u0010P\u001a\u00020E2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\u0010\u0010O\u001a\u00020E2\u0006\u0010S\u001a\u00020#H\u0016J\b\u0010T\u001a\u00020EH\u0016J\b\u0010U\u001a\u00020EH\u0016J\b\u0010V\u001a\u00020#H\u0016J\b\u0010W\u001a\u00020#H\u0016J\u0010\u0010X\u001a\u00020E2\u0006\u0010Y\u001a\u00020ZH\u0016J \u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u0002042\u0006\u0010]\u001a\u00020&2\u0006\u0010^\u001a\u00020&H\u0016J\u0018\u0010_\u001a\u00020&2\u0006\u0010\\\u001a\u0002042\u0006\u0010]\u001a\u00020&H\u0016J\u0010\u0010`\u001a\u00020E2\u0006\u0010\\\u001a\u000204H\u0016J\u0018\u0010a\u001a\u00020E2\u0006\u0010\\\u001a\u0002042\u0006\u0010b\u001a\u00020#H\u0016J\u0010\u0010c\u001a\u00020#2\u0006\u0010\\\u001a\u000204H\u0016J\u0010\u0010d\u001a\u00020E2\u0006\u0010e\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020E2\u0006\u0010h\u001a\u00020&H\u0016J\u0010\u0010i\u001a\u00020E2\u0006\u0010j\u001a\u00020&H\u0016J\u0012\u0010k\u001a\u00020E2\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\u0018\u0010n\u001a\u00020f2\u0006\u0010o\u001a\u00020&2\u0006\u0010p\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R(\u0010+\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010(R\"\u00102\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0016\u00108\u001a\u0004\u0018\u0001098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0016R\u0014\u0010B\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0016\u00a8\u0006r"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "surface", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "<init>", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;)V", "mediaPlayer", "Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer;", "getMediaPlayer", "()Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer;", "mediaPlayer$delegate", "Lkotlin/Lazy;", "_listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "surfaceCallback", "Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$SurfaceCallback;", "value", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "duration", "", "getDuration", "()J", "currentPosition", "getCurrentPosition", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "isPlaying", "", "()Z", "bufferedPercent", "", "getBufferedPercent", "()I", "_", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "audioSessionId", "getAudioSessionId", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "playbackSpeed", "getPlaybackSpeed", "playbackPitch", "getPlaybackPitch", "setListenerMux", "", "listenerMux", "start", "pause", "seekTo", "milliseconds", "setPlaybackSpeed", "speed", "setPlaybackPitch", "pitch", "stop", "setCaptionListener", "listener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "clearSurface", "release", "reset", "restart", "trackSelectionAvailable", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setSelectedTrack", "type", "groupIndex", "trackIndex", "getSelectedTrackIndex", "clearSelectedTracks", "setRendererEnabled", "enabled", "isRendererEnabled", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setWakeLevel", "levelAndFlags", "setRepeatMode", "repeatMode", "setMedia", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "getAudioAttributes", "usage", "contentType", "SurfaceCallback", "library_release"})
public final class NativeVideoPlayer
implements VideoPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final SurfaceEnvelope surface;
    @NotNull
    private final Lazy mediaPlayer$delegate;
    @Nullable
    private ListenerMux _listenerMux;
    @NotNull
    private SurfaceCallback surfaceCallback;

    public NativeVideoPlayer(@NotNull PlayerConfig config, @NotNull SurfaceEnvelope surface) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.config = config;
        this.surface = surface;
        this.mediaPlayer$delegate = LazyKt.lazy(() -> NativeVideoPlayer.mediaPlayer_delegate$lambda$1(this));
        this.surfaceCallback = new SurfaceCallback();
        this.surface.addCallback(this.surfaceCallback);
    }

    private final FallbackMediaPlayer getMediaPlayer() {
        Lazy lazy = this.mediaPlayer$delegate;
        return (FallbackMediaPlayer)lazy.getValue();
    }

    @Override
    public float getVolume() {
        return this.getMediaPlayer().getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.getMediaPlayer().setVolume(value);
    }

    @Override
    public long getDuration() {
        return this.getMediaPlayer().getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.getMediaPlayer().getCurrentPosition();
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.getMediaPlayer().getPlaying();
    }

    @Override
    public int getBufferedPercent() {
        return this.getMediaPlayer().getBufferedPercent();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return null;
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
    }

    @Override
    public int getAudioSessionId() {
        return this.getMediaPlayer().getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return null;
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return null;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.getMediaPlayer().getTimeline();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.getMediaPlayer().getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.getMediaPlayer().getPlaybackPitch();
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux) {
        Intrinsics.checkNotNullParameter((Object)listenerMux, (String)"listenerMux");
        this._listenerMux = listenerMux;
        this.getMediaPlayer().setListener(listenerMux);
    }

    @Override
    public void start() {
        block0: {
            this.getMediaPlayer().start();
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux == null) break block0;
            listenerMux.setNotifiedCompleted(false);
        }
    }

    @Override
    public void pause() {
        this.getMediaPlayer().pause();
    }

    @Override
    public void seekTo(long milliseconds) {
        this.getMediaPlayer().seekTo(milliseconds);
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.getMediaPlayer().setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.getMediaPlayer().setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener2) {
    }

    @Override
    public void stop(boolean clearSurface) {
        block1: {
            this.getMediaPlayer().stop();
            if (!clearSurface) break block1;
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux != null) {
                listenerMux.clearSurfaceWhenReady(this.surface);
            }
        }
    }

    @Override
    public void release() {
        this.getMediaPlayer().release();
        this.surface.removeCallback(this.surfaceCallback);
    }

    @Override
    public void reset() {
        this.getMediaPlayer().reset();
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.getMediaPlayer().restart()) {
                return false;
            }
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux != null) {
                listenerMux.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 == null) break block2;
            listenerMux2.setNotifiedCompleted(false);
        }
        return true;
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return -1;
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return false;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.getMediaPlayer().setAudioAttributes(attributes);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getMediaPlayer().setWakeLevel(levelAndFlags);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        block0: {
            MediaItem mediaItem2 = mediaItem;
            this.getMediaPlayer().setMedia((Uri)(mediaItem2 != null ? mediaItem2.getUri() : null));
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux == null) break block0;
            listenerMux.setNotifiedPrepared(false);
        }
    }

    private final AudioAttributes getAudioAttributes(int usage, int contentType) {
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioAttributes, (String)"build(...)");
        return audioAttributes;
    }

    private static final FallbackMediaPlayerImpl mediaPlayer_delegate$lambda$1(NativeVideoPlayer this$0) {
        FallbackMediaPlayerImpl fallbackMediaPlayerImpl;
        FallbackMediaPlayerImpl $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240 = fallbackMediaPlayerImpl = new FallbackMediaPlayerImpl(this$0.config.getContext());
        boolean bl = false;
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setAudioAttributes(this$0.getAudioAttributes(1, 3));
        return fallbackMediaPlayerImpl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$SurfaceCallback;", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope$Callback;", "<init>", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;)V", "onSurfaceAvailable", "", "envelope", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "onSurfaceDestroyed", "onSurfaceSizeChanged", "width", "", "height", "library_release"})
    private final class SurfaceCallback
    implements SurfaceEnvelope.Callback {
        @Override
        public void onSurfaceAvailable(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            NativeVideoPlayer.this.getMediaPlayer().setSurface(envelope.getSurface());
            if (NativeVideoPlayer.this.getMediaPlayer().getPlayWhenReady()) {
                NativeVideoPlayer.this.getMediaPlayer().start();
            }
        }

        @Override
        public void onSurfaceDestroyed(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            envelope.release();
            NativeVideoPlayer.this.release();
        }

        @Override
        public void onSurfaceSizeChanged(@NotNull SurfaceEnvelope envelope, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            if (width > 0 && height > 0) {
                NativeVideoPlayer.this.start();
            }
        }
    }
}

