/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.core.state.PlaybackStateListener;
import com.devbrackets.android.exomedia.core.video.ExoVideoPlayer;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.layout.AspectRatioLayout;
import com.devbrackets.android.exomedia.core.video.scale.MatrixManager;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceViewSurfaceEnvelope;
import com.devbrackets.android.exomedia.core.video.surface.TextureViewSurfaceEnvelope;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.listener.OnTimelineChangedListener;
import com.devbrackets.android.exomedia.listener.OnVideoSizeChangedListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributeParser;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributes;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControls;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControlsProvider;
import com.devbrackets.android.exomedia.util.StopWatch;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u00f6\u0001\u00f7\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020\"J\u0011\u0010\u009d\u0001\u001a\u00020\u007f2\u0006\u0010y\u001a\u00020zH\u0004J\b\u0010\u009e\u0001\u001a\u00030\u008e\u0001J\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001J\u0019\u0010\u00a1\u0001\u001a\u00020\n2\u0007\u0010\u009c\u0001\u001a\u00020\"2\u0007\u0010\u00a2\u0001\u001a\u00020\nJ\u001c\u0010\u00a3\u0001\u001a\u00030\u009b\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001H\u0004J\u0010\u0010\u00a6\u0001\u001a\u0002042\u0007\u0010\u009c\u0001\u001a\u00020\"J\n\u0010\u00a7\u0001\u001a\u00030\u009b\u0001H\u0014J\n\u0010\u00a8\u0001\u001a\u00030\u009b\u0001H\u0004J\u0014\u0010\u00a9\u0001\u001a\u00030\u009b\u00012\b\u0010\u00aa\u0001\u001a\u00030\u00a0\u0001H\u0016J\u0010\u0010\u00ab\u0001\u001a\u00030\u009b\u00012\u0006\u00101\u001a\u00020.J\u0010\u0010Z\u001a\u00030\u009b\u00012\u0007\u0010\u00ac\u0001\u001a\u000204J\u0015\u0010\u00ad\u0001\u001a\u00030\u009b\u00012\t\b\u0002\u0010\u00ae\u0001\u001a\u000204H\u0007J\u0014\u0010\u00af\u0001\u001a\u00030\u009b\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001H\u0004J\b\u0010\u00b0\u0001\u001a\u00030\u009b\u0001J\b\u0010\u00b1\u0001\u001a\u00030\u009b\u0001J\u0007\u0010\u00b2\u0001\u001a\u000204J\b\u0010\u00b3\u0001\u001a\u00030\u009b\u0001J\u0011\u0010\u00b4\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00b5\u0001\u001a\u00020.J\u0014\u0010\u00b6\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u0001J\u0014\u0010\u00b9\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00ba\u0001J\u0014\u0010\u00bb\u0001\u001a\u00030\u009b\u00012\n\u0010\u00bc\u0001\u001a\u0005\u0018\u00010\u00bd\u0001J\u0014\u0010\u00be\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00bf\u0001J\u0011\u0010\u00c0\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00c1\u0001\u001a\u000204J\u0014\u0010\u00c2\u0001\u001a\u00030\u009b\u00012\n\u0010\u00c3\u0001\u001a\u0005\u0018\u00010\u00c4\u0001J\u0014\u0010\u00c2\u0001\u001a\u00030\u009b\u00012\n\u0010\u00c5\u0001\u001a\u0005\u0018\u00010\u00c6\u0001J\u0014\u0010\u00c7\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00c8\u0001J\u0014\u0010\u00c9\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00ca\u0001J\u0014\u0010\u00cb\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00cc\u0001J\u0014\u0010\u00cd\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00ce\u0001J\u0014\u0010\u00cf\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00d0\u0001J\u0014\u0010\u00d1\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00d2\u0001J\u0014\u0010\u00d3\u0001\u001a\u00030\u009b\u00012\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00d4\u0001J\u0011\u0010\u00d5\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00d6\u0001\u001a\u000204J\u0010\u0010\u00d7\u0001\u001a\u0002042\u0007\u0010\u00d8\u0001\u001a\u00020cJ\u0010\u0010\u00d9\u0001\u001a\u0002042\u0007\u0010\u00da\u0001\u001a\u00020cJ\u0013\u0010\u00db\u0001\u001a\u00030\u009b\u00012\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010\u0002J\u0012\u0010\u00dc\u0001\u001a\u00030\u009b\u00012\b\u0010&\u001a\u0004\u0018\u00010'J\u0014\u0010\u00dc\u0001\u001a\u00030\u009b\u00012\n\u0010\u00dd\u0001\u001a\u0005\u0018\u00010\u00de\u0001J\u0014\u0010\u00dc\u0001\u001a\u00030\u009b\u00012\n\u0010\u00c3\u0001\u001a\u0005\u0018\u00010\u00c4\u0001J\u0013\u0010\u00dc\u0001\u001a\u00030\u009b\u00012\t\b\u0001\u0010\u00df\u0001\u001a\u00020\nJ\u001a\u0010\u00e0\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020\"2\u0007\u0010\u00c1\u0001\u001a\u000204J\u0011\u0010\u00e1\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00e2\u0001\u001a\u00020\nJ\u0012\u0010\u00e3\u0001\u001a\u00030\u009b\u00012\b\u0010\u00e4\u0001\u001a\u00030\u00e5\u0001J#\u0010\u00e6\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00e7\u0001\u001a\u00020\"2\u0007\u0010\u00a2\u0001\u001a\u00020\n2\u0007\u0010\u00e8\u0001\u001a\u00020\nJ\u0012\u0010\u00e9\u0001\u001a\u00030\u009b\u00012\b\u0010\u00ea\u0001\u001a\u00030\u00eb\u0001J\u0013\u0010\u00ec\u0001\u001a\u00030\u009b\u00012\t\b\u0001\u0010\u00ed\u0001\u001a\u00020\nJ\u001c\u0010\u00ee\u0001\u001a\u00030\u009b\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0004J\b\u0010\u00ef\u0001\u001a\u00030\u009b\u0001J\b\u0010\u00f0\u0001\u001a\u00030\u009b\u0001J\u0013\u0010\u00f1\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u00f2\u0001\u001a\u000204H\u0004J\b\u0010\u00f3\u0001\u001a\u00030\u009b\u0001J\u0007\u0010\u00f4\u0001\u001a\u000204J\u0014\u0010\u00f5\u0001\u001a\u00030\u009b\u00012\b\u0010\u00aa\u0001\u001a\u00030\u00a0\u0001H\u0004R\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001f\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b2\u00100R$\u00105\u001a\u0002042\u0006\u00103\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0011\u0010:\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b:\u00107R\u001b\u0010;\u001a\u00020<8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u0013\u001a\u0004\b=\u0010>R\u001a\u0010@\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00107\"\u0004\bB\u00109R(\u0010E\u001a\u0004\u0018\u00010D2\b\u0010C\u001a\u0004\u0018\u00010D@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001e\u0010J\u001a\u00060KR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001a\u0010P\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u00100\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020UX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u00107\"\u0004\b\\\u00109R\u001c\u0010]\u001a\u0004\u0018\u00010\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u0011\u0010b\u001a\u00020c8F\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u0011\u0010f\u001a\u00020c8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010eR\u001a\u0010h\u001a\u00020iX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u001a\u0010n\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u00100\"\u0004\bp\u0010SR\u001d\u0010q\u001a\u0004\u0018\u00010r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bu\u0010\u0013\u001a\u0004\bs\u0010tR\u001a\u0010v\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u00107\"\u0004\bx\u00109R\u001b\u0010y\u001a\u00020z8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b}\u0010\u0013\u001a\u0004\b{\u0010|R\u001e\u0010~\u001a\u00020\u007f8DX\u0084\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0082\u0001\u0010\u0013\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0015\u0010\u0083\u0001\u001a\u00030\u0084\u00018F\u00a2\u0006\b\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R/\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0087\u00012\t\u00103\u001a\u0005\u0018\u00010\u0087\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R \u0010\u008d\u0001\u001a\u00030\u008e\u00018FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0091\u0001\u0010\u0013\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R(\u0010\u0092\u0001\u001a\u00020c2\u0006\u00103\u001a\u00020c8F@FX\u0086\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0093\u0001\u0010e\"\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0017\u0010\u0096\u0001\u001a\u0005\u0018\u00010\u0097\u00018F\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001\u00a8\u0006\u00f8\u0001"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "Landroid/widget/RelativeLayout;", "Lcom/devbrackets/android/exomedia/core/state/PlaybackStateListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "aspectRatioLayout", "Lcom/devbrackets/android/exomedia/core/video/layout/AspectRatioLayout;", "getAspectRatioLayout", "()Lcom/devbrackets/android/exomedia/core/video/layout/AspectRatioLayout;", "aspectRatioLayout$delegate", "Lkotlin/Lazy;", "audioFocusHelper", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "getAudioFocusHelper", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "setAudioFocusHelper", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;)V", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "setAudioManager", "(Landroid/media/AudioManager;)V", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bitmap", "Landroid/graphics/Bitmap;", "getBitmap", "()Landroid/graphics/Bitmap;", "bufferPercentage", "getBufferPercentage", "()I", "currentPosition", "", "getCurrentPosition", "()J", "duration", "getDuration", "value", "", "handleAudioFocus", "getHandleAudioFocus", "()Z", "setHandleAudioFocus", "(Z)V", "isPlaying", "listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getListenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "listenerMux$delegate", "matchOverridePositionSpeed", "getMatchOverridePositionSpeed", "setMatchOverridePositionSpeed", "<set-?>", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "mediaItem", "getMediaItem", "()Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "setMediaItem", "(Lcom/devbrackets/android/exomedia/core/audio/MediaItem;)V", "muxNotifier", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "getMuxNotifier", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "setMuxNotifier", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;)V", "overriddenDuration", "getOverriddenDuration", "setOverriddenDuration", "(J)V", "overriddenPositionStopWatch", "Lcom/devbrackets/android/exomedia/util/StopWatch;", "getOverriddenPositionStopWatch", "()Lcom/devbrackets/android/exomedia/util/StopWatch;", "setOverriddenPositionStopWatch", "(Lcom/devbrackets/android/exomedia/util/StopWatch;)V", "overridePosition", "getOverridePosition", "setOverridePosition", "playbackListener", "getPlaybackListener", "()Lcom/devbrackets/android/exomedia/core/state/PlaybackStateListener;", "setPlaybackListener", "(Lcom/devbrackets/android/exomedia/core/state/PlaybackStateListener;)V", "playbackPitch", "", "getPlaybackPitch", "()F", "playbackSpeed", "getPlaybackSpeed", "playerConfig", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "setPlayerConfig", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "positionOffset", "getPositionOffset", "setPositionOffset", "previewImageView", "Landroid/widget/ImageView;", "getPreviewImageView", "()Landroid/widget/ImageView;", "previewImageView$delegate", "releaseOnDetachFromWindow", "getReleaseOnDetachFromWindow", "setReleaseOnDetachFromWindow", "surface", "Landroid/view/View;", "getSurface", "()Landroid/view/View;", "surface$delegate", "surfaceEnvelope", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "getSurfaceEnvelope", "()Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "surfaceEnvelope$delegate", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "videoControls", "getVideoControls", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "setVideoControls", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;)V", "videoPlayer", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "getVideoPlayer", "()Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "videoPlayer$delegate", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "constructEnvelope", "getApiImplementation", "getPlaybackState", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "getSelectedTrackIndex", "groupIndex", "initView", "attributes", "Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributes;", "isRendererEnabled", "onDetachedFromWindow", "onPlaybackEnded", "onPlaybackStateChange", "state", "overrideDuration", "override", "pause", "transientFocusLoss", "postInit", "release", "reset", "restart", "restartOverridePosition", "seekTo", "milliSeconds", "setAnalyticsListener", "listener", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "setCaptionListener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setDrmSessionManagerProvider", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setId3MetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setMeasureBasedOnAspectRatioEnabled", "enabled", "setMedia", "uri", "Landroid/net/Uri;", "mediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "setOnBufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "setOnCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnCompletionListener;", "setOnErrorListener", "Lcom/devbrackets/android/exomedia/listener/OnErrorListener;", "setOnPreparedListener", "Lcom/devbrackets/android/exomedia/listener/OnPreparedListener;", "setOnSeekCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnSeekCompletionListener;", "setOnTimelineChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnTimelineChangedListener;", "setOnVideoSizedChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "setOverridePositionMatchesPlaybackSpeed", "match", "setPlaybackPitch", "pitch", "setPlaybackSpeed", "speed", "setPlaybackStateListener", "setPreviewImage", "drawable", "Landroid/graphics/drawable/Drawable;", "resourceId", "setRendererEnabled", "setRepeatMode", "repeatMode", "setScaleType", "scaleType", "Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "setTrack", "trackType", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setVideoRotation", "rotation", "setup", "start", "stop", "stopPlayback", "clearSurface", "suspend", "trackSelectionAvailable", "updatePreviewVisibility", "AudioFocusHelper", "MuxNotifier", "library_release"})
public class VideoView
extends RelativeLayout
implements PlaybackStateListener {
    @NotNull
    private final Lazy previewImageView$delegate;
    @NotNull
    private final Lazy aspectRatioLayout$delegate;
    @NotNull
    private final Lazy surface$delegate;
    @NotNull
    private final Lazy surfaceEnvelope$delegate;
    @NotNull
    private final Lazy videoPlayer$delegate;
    @Nullable
    private MediaItem mediaItem;
    @Nullable
    private AudioManager audioManager;
    @NotNull
    private AudioFocusHelper audioFocusHelper;
    private long positionOffset;
    private long overriddenDuration;
    private boolean overridePosition;
    private boolean matchOverridePositionSpeed;
    @NotNull
    private StopWatch overriddenPositionStopWatch;
    @NotNull
    private MuxNotifier muxNotifier;
    @NotNull
    private final Lazy listenerMux$delegate;
    protected PlayerConfig playerConfig;
    @Nullable
    private PlaybackStateListener playbackListener;
    private boolean releaseOnDetachFromWindow;
    private boolean handleAudioFocus;
    @Nullable
    private VideoControls videoControls;

    @Nullable
    public final ImageView getPreviewImageView() {
        Lazy lazy = this.previewImageView$delegate;
        return (ImageView)lazy.getValue();
    }

    @NotNull
    protected final AspectRatioLayout getAspectRatioLayout() {
        Lazy lazy = this.aspectRatioLayout$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AspectRatioLayout)((Object)object);
    }

    @NotNull
    protected final View getSurface() {
        Lazy lazy = this.surface$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (View)object;
    }

    @NotNull
    protected final SurfaceEnvelope getSurfaceEnvelope() {
        Lazy lazy = this.surfaceEnvelope$delegate;
        return (SurfaceEnvelope)lazy.getValue();
    }

    @NotNull
    public final VideoPlayerApi getVideoPlayer() {
        Lazy lazy = this.videoPlayer$delegate;
        return (VideoPlayerApi)lazy.getValue();
    }

    @Nullable
    public final MediaItem getMediaItem() {
        return this.mediaItem;
    }

    protected final void setMediaItem(@Nullable MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    @Nullable
    protected final AudioManager getAudioManager() {
        return this.audioManager;
    }

    protected final void setAudioManager(@Nullable AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    @NotNull
    protected final AudioFocusHelper getAudioFocusHelper() {
        return this.audioFocusHelper;
    }

    protected final void setAudioFocusHelper(@NotNull AudioFocusHelper audioFocusHelper) {
        Intrinsics.checkNotNullParameter((Object)audioFocusHelper, (String)"<set-?>");
        this.audioFocusHelper = audioFocusHelper;
    }

    public final long getPositionOffset() {
        return this.positionOffset;
    }

    public final void setPositionOffset(long l) {
        this.positionOffset = l;
    }

    protected final long getOverriddenDuration() {
        return this.overriddenDuration;
    }

    protected final void setOverriddenDuration(long l) {
        this.overriddenDuration = l;
    }

    protected final boolean getOverridePosition() {
        return this.overridePosition;
    }

    protected final void setOverridePosition(boolean bl) {
        this.overridePosition = bl;
    }

    protected final boolean getMatchOverridePositionSpeed() {
        return this.matchOverridePositionSpeed;
    }

    protected final void setMatchOverridePositionSpeed(boolean bl) {
        this.matchOverridePositionSpeed = bl;
    }

    @NotNull
    protected final StopWatch getOverriddenPositionStopWatch() {
        return this.overriddenPositionStopWatch;
    }

    protected final void setOverriddenPositionStopWatch(@NotNull StopWatch stopWatch) {
        Intrinsics.checkNotNullParameter((Object)stopWatch, (String)"<set-?>");
        this.overriddenPositionStopWatch = stopWatch;
    }

    @NotNull
    protected final MuxNotifier getMuxNotifier() {
        return this.muxNotifier;
    }

    protected final void setMuxNotifier(@NotNull MuxNotifier muxNotifier) {
        Intrinsics.checkNotNullParameter((Object)muxNotifier, (String)"<set-?>");
        this.muxNotifier = muxNotifier;
    }

    @NotNull
    protected final ListenerMux getListenerMux() {
        Lazy lazy = this.listenerMux$delegate;
        return (ListenerMux)lazy.getValue();
    }

    @NotNull
    protected final PlayerConfig getPlayerConfig() {
        PlayerConfig playerConfig = this.playerConfig;
        if (playerConfig != null) {
            return playerConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playerConfig");
        return null;
    }

    protected final void setPlayerConfig(@NotNull PlayerConfig playerConfig) {
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"<set-?>");
        this.playerConfig = playerConfig;
    }

    @Nullable
    protected final PlaybackStateListener getPlaybackListener() {
        return this.playbackListener;
    }

    protected final void setPlaybackListener(@Nullable PlaybackStateListener playbackStateListener) {
        this.playbackListener = playbackStateListener;
    }

    public final boolean getReleaseOnDetachFromWindow() {
        return this.releaseOnDetachFromWindow;
    }

    public final void setReleaseOnDetachFromWindow(boolean bl) {
        this.releaseOnDetachFromWindow = bl;
    }

    public final boolean getHandleAudioFocus() {
        return this.handleAudioFocus;
    }

    public final void setHandleAudioFocus(boolean value) {
        this.audioFocusHelper.abandonFocus();
        this.handleAudioFocus = value;
    }

    @Nullable
    public final VideoControls getVideoControls() {
        return this.videoControls;
    }

    public final void setVideoControls(@Nullable VideoControls value) {
        block2: {
            if (!Intrinsics.areEqual((Object)this.videoControls, (Object)value)) {
                VideoControls videoControls = this.videoControls;
                if (videoControls != null) {
                    videoControls.onDetachedFromView(this);
                }
            }
            VideoControls videoControls = this.videoControls = value;
            if (videoControls == null) break block2;
            videoControls.onAttachedToView(this);
        }
    }

    public final float getVolume() {
        return this.getVideoPlayer().getVolume();
    }

    public final void setVolume(float value) {
        this.getVideoPlayer().setVolume(value);
    }

    public final boolean isPlaying() {
        return this.getVideoPlayer().isPlaying();
    }

    public final long getDuration() {
        return this.overriddenDuration >= 0L ? this.overriddenDuration : this.getVideoPlayer().getDuration();
    }

    public final long getCurrentPosition() {
        return this.overridePosition ? this.positionOffset + this.overriddenPositionStopWatch.getTime() : this.positionOffset + this.getVideoPlayer().getCurrentPosition();
    }

    public final int getBufferPercentage() {
        return this.getVideoPlayer().getBufferedPercent();
    }

    @Nullable
    public final WindowInfo getWindowInfo() {
        return this.getVideoPlayer().getWindowInfo();
    }

    @NotNull
    public final Timeline getTimeline() {
        return this.getVideoPlayer().getTimeline();
    }

    public final float getPlaybackSpeed() {
        return this.getVideoPlayer().getPlaybackSpeed();
    }

    public final float getPlaybackPitch() {
        return this.getVideoPlayer().getPlaybackPitch();
    }

    @Nullable
    public final Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.getVideoPlayer().getAvailableTracks();
    }

    @Nullable
    public final Bitmap getBitmap() {
        VideoPlayerApi videoPlayerApi = this.getVideoPlayer();
        TextureView textureView = videoPlayerApi instanceof TextureView ? (TextureView)videoPlayerApi : null;
        return textureView != null ? textureView.getBitmap() : null;
    }

    public VideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageView>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ImageView invoke() {
                return (ImageView)this.this$0.findViewById(R.id.exomedia_video_preview_image);
            }
        }));
        this.aspectRatioLayout$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AspectRatioLayout>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AspectRatioLayout invoke() {
                return (AspectRatioLayout)this.this$0.findViewById(R.id.exomedia_video_ratio_layout);
            }
        }));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final View invoke() {
                return this.this$0.findViewById(R.id.exomedia_surface_view);
            }
        }));
        this.surfaceEnvelope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SurfaceEnvelope>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SurfaceEnvelope invoke() {
                return this.this$0.constructEnvelope(this.this$0.getSurface());
            }
        }));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoPlayerApi>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VideoPlayerApi invoke() {
                return this.this$0.getApiImplementation();
            }
        }));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ListenerMux>(this){
            final /* synthetic */ VideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ListenerMux invoke() {
                ListenerMux listenerMux2 = new ListenerMux(this.this$0.getMuxNotifier(), null, 2, null);
                VideoView videoView = this.this$0;
                ListenerMux $this$invoke_u24lambda_u240 = listenerMux2;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setPlaybackStateListener(videoView);
                return listenerMux2;
            }
        }));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, null);
    }

    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.aspectRatioLayout$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surfaceEnvelope$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.aspectRatioLayout$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surfaceEnvelope$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.aspectRatioLayout$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surfaceEnvelope$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode() && this.releaseOnDetachFromWindow) {
            this.release();
        }
    }

    @Override
    public void onPlaybackStateChange(@NotNull PlaybackState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        VideoControls videoControls = this.videoControls;
        if (videoControls != null) {
            videoControls.onPlaybackStateChange(state);
        }
        PlaybackStateListener playbackStateListener = this.playbackListener;
        if (playbackStateListener != null) {
            playbackStateListener.onPlaybackStateChange(state);
        }
        this.updatePreviewVisibility(state);
    }

    protected final void updatePreviewVisibility(@NotNull PlaybackState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        ImageView view = this.getPreviewImageView();
        if (view == null) {
            return;
        }
        if (state == PlaybackState.IDLE || state == PlaybackState.PREPARING) {
            view.setVisibility(0);
            return;
        }
        if (view.getVisibility() == 0 && state == PlaybackState.PLAYING) {
            view.setVisibility(8);
        }
    }

    public final void setPreviewImage(@Nullable Drawable drawable) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageDrawable(drawable);
        }
    }

    public final void setPreviewImage(@DrawableRes int resourceId) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageResource(resourceId);
        }
    }

    public final void setPreviewImage(@Nullable Bitmap bitmap) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageBitmap(bitmap);
        }
    }

    public final void setPreviewImage(@Nullable Uri uri) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageURI(uri);
        }
    }

    public final void setMedia(@Nullable Uri uri) {
        MediaItem mediaItem;
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri it = uri2;
            boolean bl = false;
            mediaItem = new MediaItem(it, null);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.getVideoPlayer().setMedia(mediaItem2);
        this.mediaItem = mediaItem2;
    }

    public final void setMedia(@Nullable MediaSource mediaSource) {
        MediaItem mediaItem;
        MediaSource mediaSource2 = mediaSource;
        if (mediaSource2 != null) {
            MediaSource it = mediaSource2;
            boolean bl = false;
            mediaItem = new MediaItem(null, it);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.getVideoPlayer().setMedia(mediaItem2);
        this.mediaItem = mediaItem2;
    }

    public final void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.getVideoPlayer().setDrmSessionManagerProvider(drmSessionManagerProvider);
    }

    public final void seekTo(long milliSeconds) {
        this.getVideoPlayer().seekTo(milliSeconds);
    }

    public final void start() {
        if (!this.audioFocusHelper.requestFocus()) {
            return;
        }
        this.getVideoPlayer().start();
        this.setKeepScreenOn(true);
    }

    @JvmOverloads
    public final void pause(boolean transientFocusLoss) {
        if (!transientFocusLoss) {
            this.audioFocusHelper.abandonFocus();
        }
        this.getVideoPlayer().pause();
        this.setKeepScreenOn(false);
    }

    public static /* synthetic */ void pause$default(VideoView videoView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        videoView.pause(bl);
    }

    public final boolean restart() {
        if (this.mediaItem == null) {
            return false;
        }
        return this.getVideoPlayer().restart();
    }

    public final void stop() {
        this.stopPlayback(true);
    }

    public final void reset() {
        this.stop();
        this.setMedia((Uri)null);
    }

    public final void release() {
        this.setVideoControls(null);
        this.stop();
        this.overriddenPositionStopWatch.stop();
        this.getVideoPlayer().release();
    }

    public final void suspend() {
        this.audioFocusHelper.abandonFocus();
        this.getVideoPlayer().release();
        this.setKeepScreenOn(false);
    }

    public final void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public final void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public final void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public final void setOverridePositionMatchesPlaybackSpeed(boolean match) {
        if (match == this.matchOverridePositionSpeed) {
            return;
        }
        this.matchOverridePositionSpeed = match;
        if (match) {
            this.overriddenPositionStopWatch.setSpeedMultiplier(this.getPlaybackSpeed());
        } else {
            this.overriddenPositionStopWatch.setSpeedMultiplier(1.0f);
        }
    }

    public final void setRepeatMode(int repeatMode) {
        this.getVideoPlayer().setRepeatMode(repeatMode);
    }

    public final boolean setPlaybackSpeed(float speed) {
        boolean wasSet = this.getVideoPlayer().setPlaybackSpeed(speed);
        if (wasSet && this.matchOverridePositionSpeed) {
            this.overriddenPositionStopWatch.setSpeedMultiplier(speed);
        }
        return wasSet;
    }

    public final boolean setPlaybackPitch(float pitch) {
        return this.getVideoPlayer().setPlaybackPitch(pitch);
    }

    public final void setCaptionListener(@Nullable CaptionListener listener2) {
        this.getVideoPlayer().setCaptionListener(listener2);
    }

    public final boolean trackSelectionAvailable() {
        return this.getVideoPlayer().trackSelectionAvailable();
    }

    public final void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.getVideoPlayer().setTrackSelectionParameters(parameters);
    }

    public final void setTrack(@NotNull RendererType trackType, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackType), (String)"trackType");
        this.getVideoPlayer().setSelectedTrack(trackType, groupIndex, trackIndex);
    }

    public final int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getVideoPlayer().getSelectedTrackIndex(type, groupIndex);
    }

    public final void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getVideoPlayer().clearSelectedTracks(type);
    }

    public final void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getVideoPlayer().setRendererEnabled(type, enabled);
    }

    public final boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getVideoPlayer().isRendererEnabled(type);
    }

    public final void setScaleType(@NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        this.getSurfaceEnvelope().setScaleType(scaleType);
    }

    public final void setMeasureBasedOnAspectRatioEnabled(boolean enabled) {
        this.getAspectRatioLayout().setHonorAspectRatio(enabled);
    }

    public final void setVideoRotation(@IntRange(from=0L, to=359L) int rotation) {
        this.getSurfaceEnvelope().setVideoRotation(rotation, true);
    }

    public final void setOnPreparedListener(@Nullable OnPreparedListener listener2) {
        this.getListenerMux().setOnPreparedListener(listener2);
    }

    public final void setOnCompletionListener(@Nullable OnCompletionListener listener2) {
        this.getListenerMux().setOnCompletionListener(listener2);
    }

    public final void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener2) {
        this.getListenerMux().setOnBufferUpdateListener(listener2);
    }

    public final void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener2) {
        this.getListenerMux().setOnSeekCompletionListener(listener2);
    }

    public final void setOnTimelineChangedListener(@Nullable OnTimelineChangedListener listener2) {
        this.getListenerMux().setOnTimelineChangedListener(listener2);
    }

    public final void setOnErrorListener(@Nullable OnErrorListener listener2) {
        this.getListenerMux().setOnErrorListener(listener2);
    }

    public final void setId3MetadataListener(@Nullable MetadataListener listener2) {
        this.getListenerMux().setMetadataListener(listener2);
    }

    public final void setAnalyticsListener(@Nullable AnalyticsListener listener2) {
        this.getListenerMux().setAnalyticsListener(listener2);
    }

    public final void setOnVideoSizedChangedListener(@Nullable OnVideoSizeChangedListener listener2) {
        this.muxNotifier.setVideoSizeChangedListener(listener2);
    }

    public final void setPlaybackStateListener(@Nullable PlaybackStateListener listener2) {
        this.playbackListener = listener2;
    }

    @NotNull
    public final PlaybackState getPlaybackState() {
        return this.getListenerMux().getPlaybackState();
    }

    @NotNull
    protected final SurfaceEnvelope constructEnvelope(@NotNull View surface2) {
        SurfaceEnvelope surfaceEnvelope2;
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        View view = surface2;
        if (view instanceof SurfaceView) {
            surfaceEnvelope2 = new SurfaceViewSurfaceEnvelope((SurfaceView)surface2, new MatrixManager());
        } else if (view instanceof TextureView) {
            surfaceEnvelope2 = new TextureViewSurfaceEnvelope((TextureView)surface2, new MatrixManager());
        } else {
            throw new IllegalArgumentException("Provided surface must be either a SurfaceView or TextureView");
        }
        return surfaceEnvelope2;
    }

    protected final void setup(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isInEditMode()) {
            return;
        }
        VideoViewAttributes attributes = new VideoViewAttributeParser().parse(context, attrs);
        Object object = context.getApplicationContext().getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object;
        this.setPlayerConfig(attributes.getPlayerConfigProvider().getConfig(context));
        this.initView(context, attributes);
        this.postInit(attributes);
    }

    protected final void initView(@NotNull Context context, @NotNull VideoViewAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        View.inflate((Context)context, (int)R.layout.exomedia_video_view_layout, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.video_view_surface_stub);
        ViewStub $this$initView_u24lambda_u242 = (ViewStub)view;
        boolean bl = false;
        $this$initView_u24lambda_u242.setLayoutResource(attributes.getUseTextureViewBacking() ? R.layout.exomedia_texture_view : R.layout.exomedia_surface_view);
        $this$initView_u24lambda_u242.inflate();
        this.getVideoPlayer().setListenerMux(this.getListenerMux());
    }

    protected final void postInit(@NotNull VideoViewAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        ScaleType scaleType = attributes.getScaleType();
        if (scaleType != null) {
            ScaleType it = scaleType;
            boolean bl = false;
            this.setScaleType(it);
        }
        VideoControlsProvider videoControlsProvider = attributes.getVideoControlsProvider();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setVideoControls(videoControlsProvider.getControls(context));
        this.setMeasureBasedOnAspectRatioEnabled(attributes.getMeasureBasedOnAspectRatio());
    }

    @NotNull
    public final VideoPlayerApi getApiImplementation() {
        if (this.getPlayerConfig().getFallbackManager().useFallback()) {
            return this.getPlayerConfig().getFallbackManager().getFallbackVideoPlayer(this.getPlayerConfig(), this.getSurfaceEnvelope());
        }
        return new ExoVideoPlayer(this.getPlayerConfig(), this.getSurfaceEnvelope());
    }

    protected final void onPlaybackEnded() {
        this.stopPlayback(false);
    }

    protected final void stopPlayback(boolean clearSurface) {
        this.audioFocusHelper.abandonFocus();
        this.getVideoPlayer().stop(clearSurface);
        this.setKeepScreenOn(false);
    }

    @JvmOverloads
    public final void pause() {
        VideoView.pause$default(this, false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "currentFocus", "", "lastFocusRequest", "Landroid/media/AudioFocusRequest;", "pausedForLoss", "", "startRequested", "abandonFocus", "onAudioFocusChange", "", "focusChange", "requestFocus", "library_release"})
    protected final class AudioFocusHelper
    implements AudioManager.OnAudioFocusChangeListener {
        private boolean startRequested;
        private boolean pausedForLoss;
        private int currentFocus;
        @TargetApi(value=26)
        @Nullable
        private AudioFocusRequest lastFocusRequest;

        public void onAudioFocusChange(int focusChange) {
            if (!VideoView.this.getHandleAudioFocus() || this.currentFocus == focusChange) {
                return;
            }
            this.currentFocus = focusChange;
            switch (focusChange) {
                case 1: 
                case 2: {
                    if (!this.startRequested && !this.pausedForLoss) break;
                    VideoView.this.start();
                    this.startRequested = false;
                    this.pausedForLoss = false;
                    break;
                }
                case -1: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.pause$default(VideoView.this, false, 1, null);
                    break;
                }
                case -3: 
                case -2: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.this.pause(true);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean requestFocus() {
            if (!VideoView.this.getHandleAudioFocus() || this.currentFocus == 1) {
                return true;
            }
            if (VideoView.this.getAudioManager() == null) {
                return false;
            }
            int status = 0;
            if (Build.VERSION.SDK_INT >= 26) {
                void it;
                AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).build();
                AudioFocusRequest audioFocusRequest = new AudioFocusRequest.Builder(1).setAudioAttributes(attributes).build();
                VideoView videoView = VideoView.this;
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                AudioFocusHelper audioFocusHelper = this;
                boolean bl = false;
                AudioManager audioManager = videoView.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.requestAudioFocus((AudioFocusRequest)it);
                audioFocusHelper.lastFocusRequest = audioFocusRequest;
            } else {
                AudioManager audioManager = VideoView.this.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
            }
            if (1 == status) {
                this.currentFocus = 1;
                return true;
            }
            this.startRequested = true;
            return false;
        }

        public final boolean abandonFocus() {
            if (!VideoView.this.getHandleAudioFocus()) {
                return true;
            }
            if (VideoView.this.getAudioManager() == null) {
                return false;
            }
            this.startRequested = false;
            int status = 0;
            if (Build.VERSION.SDK_INT >= 26) {
                int n;
                AudioFocusRequest audioFocusRequest = this.lastFocusRequest;
                if (audioFocusRequest != null) {
                    int n2;
                    AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                    VideoView videoView = VideoView.this;
                    AudioFocusRequest request = audioFocusRequest2;
                    boolean bl = false;
                    AudioManager audioManager = videoView.getAudioManager();
                    Intrinsics.checkNotNull((Object)audioManager);
                    int it = n2 = audioManager.abandonAudioFocusRequest(request);
                    boolean bl2 = false;
                    if (1 == it) {
                        this.lastFocusRequest = null;
                    }
                    n = n2;
                } else {
                    n = 1;
                }
                status = n;
            } else {
                AudioManager audioManager = VideoView.this.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            }
            return 1 == status;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "Lcom/devbrackets/android/exomedia/core/ListenerMux$Notifier;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "videoSizeChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "getVideoSizeChangedListener", "()Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "setVideoSizeChangedListener", "(Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;)V", "onExoPlayerError", "", "exoMediaPlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMediaPlaybackEnded", "onVideoSizeChanged", "width", "", "height", "unAppliedRotationDegrees", "pixelWidthHeightRatio", "", "library_release"})
    protected final class MuxNotifier
    extends ListenerMux.Notifier {
        @Nullable
        private OnVideoSizeChangedListener videoSizeChangedListener;

        @Nullable
        public final OnVideoSizeChangedListener getVideoSizeChangedListener() {
            return this.videoSizeChangedListener;
        }

        public final void setVideoSizeChangedListener(@Nullable OnVideoSizeChangedListener onVideoSizeChangedListener) {
            this.videoSizeChangedListener = onVideoSizeChangedListener;
        }

        @Override
        public void onExoPlayerError(@NotNull ExoMediaPlayer exoMediaPlayer, @Nullable Exception e) {
            Intrinsics.checkNotNullParameter((Object)exoMediaPlayer, (String)"exoMediaPlayer");
            VideoView.this.stop();
            exoMediaPlayer.forcePrepare();
        }

        @Override
        public void onMediaPlaybackEnded() {
            VideoView.this.setKeepScreenOn(false);
            VideoView.this.onPlaybackEnded();
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
            block0: {
                VideoView.this.getSurfaceEnvelope().setVideoRotation(unAppliedRotationDegrees, false);
                VideoView.this.getSurfaceEnvelope().setVideoSize(width, height, pixelWidthHeightRatio);
                VideoView.this.getAspectRatioLayout().setAspectRatio(width, height, pixelWidthHeightRatio);
                OnVideoSizeChangedListener onVideoSizeChangedListener = this.videoSizeChangedListener;
                if (onVideoSizeChangedListener == null) break block0;
                onVideoSizeChangedListener.onVideoSizeChanged(width, height, pixelWidthHeightRatio);
            }
        }
    }
}

