/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp.config;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.OptIn;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.DefaultLoadControl;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.analytics.DefaultAnalyticsCollector;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import com.devbrackets.android.exomedia.core.renderer.PlayerRendererFactory;
import com.devbrackets.android.exomedia.core.source.MediaSourceProvider;
import com.devbrackets.android.exomedia.core.source.data.DataSourceFactoryProvider;
import com.devbrackets.android.exomedia.core.source.data.DefaultDataSourceFactoryProvider;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.UserAgentProvider;
import com.devbrackets.android.exomedia.nmp.manager.WakeManager;
import com.devbrackets.android.exomedia.nmp.manager.track.TrackManager;
import com.devbrackets.android.exomedia.util.FallbackManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0012J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0016J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfigBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "analyticsCollector", "Landroidx/media3/exoplayer/analytics/AnalyticsCollector;", "bandwidthMeter", "Landroidx/media3/exoplayer/upstream/BandwidthMeter;", "dataSourceFactoryProvider", "Lcom/devbrackets/android/exomedia/core/source/data/DataSourceFactoryProvider;", "fallbackManager", "Lcom/devbrackets/android/exomedia/util/FallbackManager;", "handler", "Landroid/os/Handler;", "loadControl", "Landroidx/media3/exoplayer/LoadControl;", "mediaSourceFactory", "Landroidx/media3/exoplayer/source/MediaSource$Factory;", "mediaSourceProvider", "Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider;", "rendererFactory", "Landroidx/media3/exoplayer/RenderersFactory;", "trackManager", "Lcom/devbrackets/android/exomedia/nmp/manager/track/TrackManager;", "userAgentProvider", "Lcom/devbrackets/android/exomedia/nmp/manager/UserAgentProvider;", "wakeManager", "Lcom/devbrackets/android/exomedia/nmp/manager/WakeManager;", "build", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "setAnalyticsCollector", "setBandwidthMeter", "setDataSourceFactoryProvider", "provider", "setFallbackManager", "manager", "setHandler", "setLoadControl", "setMediaSourceFactory", "factory", "setMediaSourceProvider", "setRendererFactory", "setTrackManager", "setUserAgentProvider", "setWakeManager", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public final class PlayerConfigBuilder {
    @NotNull
    private final Context context;
    @Nullable
    private AnalyticsCollector analyticsCollector;
    @Nullable
    private BandwidthMeter bandwidthMeter;
    @Nullable
    private Handler handler;
    @Nullable
    private RenderersFactory rendererFactory;
    @Nullable
    private TrackManager trackManager;
    @Nullable
    private WakeManager wakeManager;
    @Nullable
    private LoadControl loadControl;
    @Nullable
    private UserAgentProvider userAgentProvider;
    @Nullable
    private MediaSourceProvider mediaSourceProvider;
    @Nullable
    private MediaSource.Factory mediaSourceFactory;
    @Nullable
    private DataSourceFactoryProvider dataSourceFactoryProvider;
    @Nullable
    private FallbackManager fallbackManager;

    public PlayerConfigBuilder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final PlayerConfigBuilder setAnalyticsCollector(@NotNull AnalyticsCollector analyticsCollector) {
        Intrinsics.checkNotNullParameter((Object)analyticsCollector, (String)"analyticsCollector");
        this.analyticsCollector = analyticsCollector;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setBandwidthMeter(@NotNull BandwidthMeter bandwidthMeter) {
        Intrinsics.checkNotNullParameter((Object)bandwidthMeter, (String)"bandwidthMeter");
        this.bandwidthMeter = bandwidthMeter;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setRendererFactory(@NotNull RenderersFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.rendererFactory = factory;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setTrackManager(@NotNull TrackManager trackManager) {
        Intrinsics.checkNotNullParameter((Object)trackManager, (String)"trackManager");
        this.trackManager = trackManager;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setWakeManager(@NotNull WakeManager wakeManager) {
        Intrinsics.checkNotNullParameter((Object)wakeManager, (String)"wakeManager");
        this.wakeManager = wakeManager;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setLoadControl(@NotNull LoadControl loadControl) {
        Intrinsics.checkNotNullParameter((Object)loadControl, (String)"loadControl");
        this.loadControl = loadControl;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setUserAgentProvider(@NotNull UserAgentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.userAgentProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setMediaSourceProvider(@NotNull MediaSourceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.mediaSourceProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setMediaSourceFactory(@NotNull MediaSource.Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.mediaSourceFactory = factory;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setDataSourceFactoryProvider(@NotNull DataSourceFactoryProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.dataSourceFactoryProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setFallbackManager(@NotNull FallbackManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.fallbackManager = manager;
        return this;
    }

    @NotNull
    public final PlayerConfig build() {
        DataSourceFactoryProvider dataSourceFactoryProvider;
        MediaSource.Factory factory;
        MediaSourceProvider mediaSourceProvider;
        UserAgentProvider userAgentProvider;
        LoadControl loadControl;
        WakeManager wakeManager;
        TrackManager trackManager;
        BandwidthMeter bandwidthMeter;
        FallbackManager fallbackManager;
        RenderersFactory rendererFactory;
        RenderersFactory renderersFactory;
        AnalyticsCollector actualAnalyticsCollector;
        AnalyticsCollector analyticsCollector;
        Handler actualHandler;
        Handler handler = this.handler;
        if (handler == null) {
            handler = actualHandler = new Handler(Looper.getMainLooper());
        }
        if ((analyticsCollector = this.analyticsCollector) == null) {
            analyticsCollector = actualAnalyticsCollector = (AnalyticsCollector)new DefaultAnalyticsCollector(Clock.DEFAULT);
        }
        if ((renderersFactory = this.rendererFactory) == null) {
            renderersFactory = rendererFactory = (RenderersFactory)new PlayerRendererFactory(this.context);
        }
        if ((fallbackManager = this.fallbackManager) == null) {
            fallbackManager = new FallbackManager();
        }
        if ((bandwidthMeter = this.bandwidthMeter) == null) {
            DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(this.context).build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultBandwidthMeter, (String)"build(...)");
            bandwidthMeter = (BandwidthMeter)defaultBandwidthMeter;
        }
        if ((trackManager = this.trackManager) == null) {
            trackManager = new TrackManager(this.context);
        }
        if ((wakeManager = this.wakeManager) == null) {
            wakeManager = new WakeManager(this.context);
        }
        if ((loadControl = this.loadControl) == null) {
            loadControl = (LoadControl)new DefaultLoadControl();
        }
        if ((userAgentProvider = this.userAgentProvider) == null) {
            userAgentProvider = new UserAgentProvider();
        }
        if ((mediaSourceProvider = this.mediaSourceProvider) == null) {
            mediaSourceProvider = new MediaSourceProvider();
        }
        if ((factory = this.mediaSourceFactory) == null) {
            factory = (MediaSource.Factory)new DefaultMediaSourceFactory(this.context);
        }
        if ((dataSourceFactoryProvider = this.dataSourceFactoryProvider) == null) {
            dataSourceFactoryProvider = new DefaultDataSourceFactoryProvider();
        }
        return new PlayerConfig(this.context, fallbackManager, actualAnalyticsCollector, bandwidthMeter, actualHandler, rendererFactory, trackManager, wakeManager, loadControl, userAgentProvider, mediaSourceProvider, factory, dataSourceFactoryProvider);
    }
}

