/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.listener.VideoSizeListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.source.builder.MediaSourceBuilder;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.DelegatedRenderListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.StateStore;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.devbrackets.android.exomedia.util.Repeater;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u009d\u00012\u00020\u00012\u00020\u0002:\u0002\u009d\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020^2\u0006\u0010_\u001a\u00020*H\u0016J\u0010\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020\fH\u0016J\b\u0010d\u001a\u00020^H\u0016J\b\u0010e\u001a\u00020>H\u0002J\u0018\u0010f\u001a\u00020>2\u0006\u0010g\u001a\u00020\u00072\u0006\u0010h\u001a\u00020.H\u0002J\b\u0010i\u001a\u00020^H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020.H\u0016J\u0018\u0010k\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\f2\u0006\u0010l\u001a\u00020\u0007H\u0016J\u0010\u0010m\u001a\u00020.2\u0006\u0010c\u001a\u00020\fH\u0016J\u0018\u0010n\u001a\u00020^2\u0006\u0010-\u001a\u00020.2\u0006\u0010o\u001a\u00020\u0007H\u0016J\u0010\u0010p\u001a\u00020^2\u0006\u0010?\u001a\u00020\u0007H\u0016J\u0010\u0010q\u001a\u00020^2\u0006\u0010r\u001a\u00020sH\u0016J\u0018\u0010t\u001a\u00020^2\u0006\u0010R\u001a\u00020S2\u0006\u0010o\u001a\u00020\u0007H\u0016J\b\u0010u\u001a\u00020^H\u0016J\b\u0010v\u001a\u00020^H\u0016J\b\u0010w\u001a\u00020^H\u0016J\u0010\u0010x\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010y\u001a\u00020^2\u0006\u0010_\u001a\u00020*H\u0016J\b\u0010z\u001a\u00020^H\u0002J\u0010\u0010{\u001a\u00020^2\u0006\u0010g\u001a\u00020>H\u0002J\b\u0010|\u001a\u00020.H\u0016J\u0010\u0010}\u001a\u00020^2\u0006\u0010~\u001a\u00020\u001bH\u0016J\u0018\u0010}\u001a\u00020^2\u0006\u0010~\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020.H\u0016J\u0012\u0010\u007f\u001a\u00020^2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\u0012\u0010\u0082\u0001\u001a\u00020^2\u0007\u0010\u0083\u0001\u001a\u00020\u0007H\u0017J\u0013\u0010\u0084\u0001\u001a\u00020^2\b\u0010_\u001a\u0004\u0018\u00010\u0017H\u0016J\u0014\u0010\u0085\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u0086\u0001H\u0016J\u0014\u0010\u0087\u0001\u001a\u00020^2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010,H\u0016J\u0015\u0010\u0089\u0001\u001a\u00020^2\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016J\u0014\u0010\u008c\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u008d\u0001H\u0016J\u001a\u0010\u008e\u0001\u001a\u00020^2\u0006\u0010c\u001a\u00020\f2\u0007\u0010\u008f\u0001\u001a\u00020.H\u0016J\u0012\u0010\u0090\u0001\u001a\u00020^2\u0007\u0010\u0091\u0001\u001a\u00020\u0007H\u0016J\"\u0010\u0092\u0001\u001a\u00020^2\u0006\u0010c\u001a\u00020\f2\u0006\u0010l\u001a\u00020\u00072\u0007\u0010\u0093\u0001\u001a\u00020\u0007H\u0016J\u0013\u0010\u0094\u0001\u001a\u00020^2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J\u0014\u0010\u0097\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u0098\u0001H\u0016J\u0012\u0010\u0099\u0001\u001a\u00020^2\u0007\u0010\u009a\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u009b\u0001\u001a\u00020^H\u0016J\t\u0010\u009c\u0001\u001a\u00020^H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020.2\u0006\u0010-\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00105\u001a\u0002042\u0006\u00103\u001a\u0002048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u0002042\u0006\u00103\u001a\u0002048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u00107\"\u0004\b<\u00109R\u001e\u0010?\u001a\u00020>2\u0006\u0010=\u001a\u00020>@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u00100R\u000e\u0010D\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010G\u001a\u0002048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010M\u001a\u0004\u0018\u00010L2\b\u00103\u001a\u0004\u0018\u00010L@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u0014\u0010R\u001a\u00020S8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR$\u0010V\u001a\u0002042\u0006\u0010V\u001a\u0002048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bW\u00107\"\u0004\bX\u00109R\u0016\u0010Y\u001a\u0004\u0018\u00010Z8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\\u00a8\u0006\u009e\u0001"}, d2={"Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "Landroidx/media3/common/Player$Listener;", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferRepeater", "Lcom/devbrackets/android/exomedia/util/Repeater;", "getBufferRepeater", "()Lcom/devbrackets/android/exomedia/util/Repeater;", "bufferRepeater$delegate", "Lkotlin/Lazy;", "bufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "bufferedPercent", "getBufferedPercent", "currentPosition", "", "getCurrentPosition", "()J", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/devbrackets/android/exomedia/core/listener/ExoPlayerListener;", "mediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "playWhenReady", "", "getPlayWhenReady", "()Z", "setPlayWhenReady", "(Z)V", "value", "", "playbackPitch", "getPlaybackPitch", "()F", "setPlaybackPitch", "(F)V", "playbackSpeed", "getPlaybackSpeed", "setPlaybackSpeed", "<set-?>", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "playbackState", "getPlaybackState", "()Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "playing", "getPlaying", "prepared", "rendererListener", "Lcom/devbrackets/android/exomedia/nmp/DelegatedRenderListener;", "requestedVolume", "stateStore", "Lcom/devbrackets/android/exomedia/nmp/manager/StateStore;", "stopped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Landroid/view/Surface;", "surface", "getSurface", "()Landroid/view/Surface;", "setSurface", "(Landroid/view/Surface;)V", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "volume", "getVolume", "setVolume", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "addAnalyticsListener", "", "listener", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "addListener", "clearSelectedTracks", "type", "clearSurface", "determineEndedState", "determinePlaybackState", "state", "seekCompleted", "forcePrepare", "limitToCurrentWindow", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onPlayWhenReadyChanged", "reason", "onPlaybackStateChanged", "onPlayerError", "error", "Landroidx/media3/common/PlaybackException;", "onTimelineChanged", "pause", "prepare", "release", "removeAnalyticsListener", "removeListener", "reportExoPlayerState", "reportState", "restart", "seekTo", "positionMs", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setAudioStreamType", "streamType", "setBufferUpdateListener", "setCaptionListener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setMediaSource", "source", "setMediaUri", "uri", "Landroid/net/Uri;", "setMetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setVideoSizeListener", "Lcom/devbrackets/android/exomedia/core/listener/VideoSizeListener;", "setWakeLevel", "levelAndFlags", "start", "stop", "Companion", "library_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nExoMediaPlayerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExoMediaPlayerImpl.kt\ncom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,513:1\n1855#2,2:514\n1855#2,2:516\n1855#2,2:518\n1855#2,2:520\n*S KotlinDebug\n*F\n+ 1 ExoMediaPlayerImpl.kt\ncom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl\n*L\n171#1:514,2\n177#1:516,2\n442#1:518,2\n451#1:520,2\n*E\n"})
public final class ExoMediaPlayerImpl
implements Player.Listener,
ExoMediaPlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners;
    @NotNull
    private final DelegatedRenderListener rendererListener;
    @NotNull
    private final ExoPlayer exoPlayer;
    @NotNull
    private final AtomicBoolean stopped;
    private boolean prepared;
    @NotNull
    private final StateStore stateStore;
    @NotNull
    private final Lazy bufferRepeater$delegate;
    @Nullable
    private Surface surface;
    @Nullable
    private MediaSource mediaSource;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @FloatRange(from=0.0, to=1.0)
    private float requestedVolume;
    @NotNull
    private PlaybackState playbackState;
    @Nullable
    private DrmSessionManagerProvider drmSessionManagerProvider;
    @NotNull
    private static final String TAG = "ExoMediaPlayer";
    private static final long BUFFER_REPEAT_DELAY = 1000L;
    private static final long COMPLETED_DURATION_LEEWAY = 1000L;

    /*
     * WARNING - void declaration
     */
    public ExoMediaPlayerImpl(@NotNull PlayerConfig config) {
        void it;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.listeners = new CopyOnWriteArrayList();
        this.rendererListener = new DelegatedRenderListener();
        ExoPlayer exoPlayer2 = new ExoPlayer.Builder(this.config.getContext(), this.config.getRendererFactory(), this.config.getMediaSourceFactory(), (TrackSelector)this.config.getTrackManager().getSelector(), this.config.getLoadControl(), this.config.getBandwidthMeter(), this.config.getAnalyticsCollector()).build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer2, (String)"build(...)");
        ExoPlayer exoPlayer3 = exoPlayer = exoPlayer2;
        ExoMediaPlayerImpl exoMediaPlayerImpl = this;
        boolean bl = false;
        it.addListener((Player.Listener)this);
        it.addListener((Player.Listener)this.rendererListener);
        it.addListener((Player.Listener)this.config.getAnalyticsCollector());
        exoMediaPlayerImpl.exoPlayer = exoPlayer;
        this.stopped = new AtomicBoolean();
        this.stateStore = new StateStore();
        this.bufferRepeater$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Repeater>(this){
            final /* synthetic */ ExoMediaPlayerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Repeater invoke() {
                Repeater repeater;
                Repeater $this$invoke_u24lambda_u240 = repeater = new Repeater(1000L, null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExoMediaPlayerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        block0: {
                            OnBufferUpdateListener onBufferUpdateListener = ExoMediaPlayerImpl.access$getBufferUpdateListener$p(this.this$0);
                            if (onBufferUpdateListener == null) break block0;
                            onBufferUpdateListener.onBufferingUpdate(this.this$0.getBufferedPercent());
                        }
                    }
                }, 2, null);
                boolean bl = false;
                $this$invoke_u24lambda_u240.start();
                return repeater;
            }
        }));
        this.requestedVolume = 1.0f;
        this.playbackState = PlaybackState.IDLE;
    }

    private final Repeater getBufferRepeater() {
        Lazy lazy = this.bufferRepeater$delegate;
        return (Repeater)lazy.getValue();
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    @Override
    public void setSurface(@Nullable Surface value) {
        this.surface = value;
        this.exoPlayer.setVideoSurface(value);
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.config.getTrackManager().getAvailableTracks();
    }

    @Override
    public float getVolume() {
        return this.requestedVolume;
    }

    @Override
    public void setVolume(float volume) {
        this.requestedVolume = RangesKt.coerceIn((float)volume, (float)0.0f, (float)1.0f);
        this.exoPlayer.setVolume(this.requestedVolume);
    }

    @Override
    @NotNull
    public PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    @Override
    public float getPlaybackSpeed() {
        return this.exoPlayer.getPlaybackParameters().speed;
    }

    @Override
    public void setPlaybackSpeed(float value) {
        this.exoPlayer.setPlaybackParameters(new PlaybackParameters(value, this.exoPlayer.getPlaybackParameters().pitch));
    }

    @Override
    public float getPlaybackPitch() {
        return this.exoPlayer.getPlaybackParameters().pitch;
    }

    @Override
    public void setPlaybackPitch(float value) {
        this.exoPlayer.setPlaybackParameters(new PlaybackParameters(this.exoPlayer.getPlaybackParameters().speed, value));
    }

    @Override
    public long getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    @Override
    public long getDuration() {
        return this.exoPlayer.getDuration();
    }

    @Override
    public int getBufferedPercent() {
        return this.exoPlayer.getBufferedPercentage();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.drmSessionManagerProvider;
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.drmSessionManagerProvider = drmSessionManagerProvider;
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        Timeline timeline = this.exoPlayer.getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"getCurrentTimeline(...)");
        Timeline timeline2 = timeline;
        if (timeline2.isEmpty()) {
            return null;
        }
        int currentWindowIndex = this.exoPlayer.getCurrentMediaItemIndex();
        Timeline.Window window2 = timeline2.getWindow(currentWindowIndex, new Timeline.Window());
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"getWindow(...)");
        Timeline.Window currentWindow = window2;
        return new WindowInfo(this.exoPlayer.getPreviousMediaItemIndex(), currentWindowIndex, this.exoPlayer.getNextMediaItemIndex(), currentWindow);
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.exoPlayer.getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"getCurrentTimeline(...)");
        return timeline;
    }

    @Override
    public int getAudioSessionId() {
        return this.exoPlayer.getAudioSessionId();
    }

    @Override
    public boolean getPlaying() {
        return this.exoPlayer.isPlaying();
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.exoPlayer.getPlayWhenReady();
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.exoPlayer.setPlayWhenReady(playWhenReady);
        this.config.getWakeManager().stayAwake(playWhenReady);
    }

    public void onPlaybackStateChanged(int playbackState) {
        this.reportExoPlayerState();
    }

    public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        this.reportExoPlayerState();
    }

    public void onPlayerError(@NotNull PlaybackException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.reportState(PlaybackState.ERROR);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExoPlayerListener it = (ExoPlayerListener)element$iv;
            boolean bl = false;
            it.onError(this, (Exception)error);
        }
    }

    public void onTimelineChanged(@NotNull Timeline timeline, int reason) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExoPlayerListener it = (ExoPlayerListener)element$iv;
            boolean bl = false;
            it.onTimelineChanged(timeline);
        }
    }

    @Override
    public void setMediaUri(@Nullable Uri uri) {
        MediaSource mediaSource;
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri it = uri2;
            boolean bl = false;
            Context context = this.config.getContext();
            Handler handler = this.config.getHandler();
            String string = this.config.getUserAgentProvider().getUserAgent();
            TransferListener transferListener = this.config.getBandwidthMeter().getTransferListener();
            DrmSessionManagerProvider drmSessionManagerProvider = this.getDrmSessionManagerProvider();
            if (drmSessionManagerProvider == null) {
                drmSessionManagerProvider = (DrmSessionManagerProvider)new DefaultDrmSessionManagerProvider();
            }
            MediaSourceBuilder.MediaSourceAttributes attributes = new MediaSourceBuilder.MediaSourceAttributes(context, it, handler, string, transferListener, drmSessionManagerProvider, this.config.getDataSourceFactoryProvider());
            mediaSource = this.config.getMediaSourceProvider().generate(attributes);
        } else {
            mediaSource = null;
        }
        MediaSource mediaSource2 = mediaSource;
        this.setMediaSource(mediaSource2);
    }

    @Override
    public void setMediaSource(@Nullable MediaSource source) {
        MediaSource mediaSource = this.mediaSource;
        if (mediaSource != null) {
            mediaSource.removeEventListener((MediaSourceEventListener)this.config.getAnalyticsCollector());
        }
        MediaSource mediaSource2 = source;
        if (mediaSource2 != null) {
            mediaSource2.addEventListener(this.config.getHandler(), (MediaSourceEventListener)this.config.getAnalyticsCollector());
        }
        this.mediaSource = source;
        this.prepared = false;
        this.prepare();
    }

    @Override
    public void addListener(@NotNull ExoPlayerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull ExoPlayerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void setBufferUpdateListener(@Nullable OnBufferUpdateListener listener2) {
        this.bufferUpdateListener = listener2;
    }

    @Override
    public void setMetadataListener(@Nullable MetadataListener listener2) {
        this.rendererListener.setMetadataListener(listener2);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener2) {
        this.rendererListener.setCaptionListener(listener2);
    }

    @Override
    public void setVideoSizeListener(@Nullable VideoSizeListener listener2) {
        this.rendererListener.setVideoSizeListener(listener2);
    }

    @Override
    public void addAnalyticsListener(@NotNull AnalyticsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.config.getAnalyticsCollector().addListener(listener2);
    }

    @Override
    public void removeAnalyticsListener(@NotNull AnalyticsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.config.getAnalyticsCollector().removeListener(listener2);
    }

    @Override
    public void clearSurface() {
        Surface surface2 = this.getSurface();
        if (surface2 != null) {
            surface2.release();
        }
        this.setSurface(null);
        this.exoPlayer.clearVideoSurface();
    }

    @Override
    @Deprecated(message="Use setAudioAttributes instead")
    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType((int)streamType);
        int contentType = Util.getAudioContentTypeForStreamType((int)streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioAttributes, (String)"build(...)");
        AudioAttributes audioAttributes2 = audioAttributes;
        this.setAudioAttributes(audioAttributes2);
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.exoPlayer.setAudioAttributes(attributes, false);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.config.getTrackManager().isRendererEnabled(type);
    }

    @Override
    public void forcePrepare() {
        this.prepared = false;
    }

    @Override
    public void prepare() {
        MediaSource source = this.mediaSource;
        if (this.prepared || source == null) {
            return;
        }
        this.reportState(PlaybackState.PREPARING);
        this.exoPlayer.stop();
        this.stateStore.reset();
        this.exoPlayer.setMediaSource(source);
        this.exoPlayer.prepare();
        this.prepared = true;
        this.stopped.set(false);
    }

    @Override
    public void start() {
        this.setPlayWhenReady(true);
    }

    @Override
    public void pause() {
        this.setPlayWhenReady(false);
    }

    @Override
    public boolean restart() {
        int playbackState = this.exoPlayer.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            return false;
        }
        this.seekTo(0L);
        this.setPlayWhenReady(true);
        this.forcePrepare();
        this.prepare();
        return true;
    }

    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.exoPlayer.setPlayWhenReady(false);
            this.exoPlayer.stop();
            this.reportState(PlaybackState.STOPPED);
        }
    }

    @Override
    public void release() {
        this.getBufferRepeater().stop();
        this.listeners.clear();
        MediaSource mediaSource = this.mediaSource;
        if (mediaSource != null) {
            mediaSource.removeEventListener((MediaSourceEventListener)this.config.getAnalyticsCollector());
        }
        this.setSurface(null);
        this.setPlayWhenReady(false);
        this.exoPlayer.release();
        this.config.getWakeManager().stayAwake(false);
        this.reportState(PlaybackState.RELEASED);
    }

    @Override
    public void seekTo(long positionMs) {
        this.seekTo(positionMs, false);
    }

    @Override
    public void seekTo(long positionMs, boolean limitToCurrentWindow) {
        this.config.getAnalyticsCollector().notifySeekStarted();
        this.reportState(PlaybackState.SEEKING);
        if (limitToCurrentWindow) {
            this.exoPlayer.seekTo(positionMs);
            this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
            return;
        }
        Timeline timeline = this.exoPlayer.getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"getCurrentTimeline(...)");
        Timeline timeline2 = timeline;
        int windowCount = timeline2.getWindowCount();
        long cumulativePositionMs = 0L;
        Timeline.Window window2 = new Timeline.Window();
        for (int index = 0; index < windowCount; ++index) {
            timeline2.getWindow(index, window2);
            long windowDurationMs = window2.getDurationMs();
            if (cumulativePositionMs < positionMs && positionMs <= cumulativePositionMs + windowDurationMs) {
                this.exoPlayer.seekTo(index, positionMs - cumulativePositionMs);
                this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
                return;
            }
            cumulativePositionMs += windowDurationMs;
        }
        Log.e((String)TAG, (String)"Unable to seek across windows, falling back to in-window seeking");
        this.exoPlayer.seekTo(positionMs);
        this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
    }

    @Override
    public long getCurrentPosition(boolean limitToCurrentWindow) {
        long positionInCurrentWindow = this.exoPlayer.getCurrentPosition();
        if (limitToCurrentWindow) {
            return positionInCurrentWindow;
        }
        Timeline timeline = this.exoPlayer.getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"getCurrentTimeline(...)");
        Timeline timeline2 = timeline;
        int maxWindowIndex = Math.min(timeline2.getWindowCount() - 1, this.exoPlayer.getCurrentMediaItemIndex());
        long cumulativePositionMs = 0L;
        Timeline.Window window2 = new Timeline.Window();
        for (int index = 0; index < maxWindowIndex; ++index) {
            timeline2.getWindow(index, window2);
            cumulativePositionMs += window2.getDurationMs();
        }
        return cumulativePositionMs + positionInCurrentWindow;
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.config.getWakeManager().setWakeLevel(levelAndFlags);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.exoPlayer.setRepeatMode(repeatMode);
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.config.getTrackManager().setTrackSelectionParameters(parameters);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.config.getTrackManager().getSelectedTrackIndex(type, groupIndex);
    }

    private final void reportExoPlayerState() {
        int playbackState;
        boolean playWhenReady = this.exoPlayer.getPlayWhenReady();
        int newState = this.stateStore.getState(playWhenReady, playbackState = this.exoPlayer.getPlaybackState());
        if (newState == this.stateStore.getMostRecentState()) {
            return;
        }
        this.stateStore.setMostRecentState(playWhenReady, playbackState);
        boolean informSeekCompletion = this.stateStore.seekCompleted();
        this.reportState(this.determinePlaybackState(playbackState, informSeekCompletion));
        if (informSeekCompletion) {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExoPlayerListener listener2 = (ExoPlayerListener)element$iv;
                boolean bl = false;
                listener2.onSeekComplete();
            }
        }
    }

    private final void reportState(PlaybackState state) {
        this.playbackState = state;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExoPlayerListener listener2 = (ExoPlayerListener)element$iv;
            boolean bl = false;
            listener2.onPlaybackStateChange(state);
        }
    }

    private final PlaybackState determinePlaybackState(int state, boolean seekCompleted) {
        PlaybackState playbackState;
        if (seekCompleted && state == 3) {
            PlaybackState playbackState2;
            boolean bl = this.getPlayWhenReady();
            if (bl) {
                playbackState2 = PlaybackState.PLAYING;
            } else if (!bl) {
                playbackState2 = PlaybackState.READY;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return playbackState2;
        }
        if (this.getPlayWhenReady() && state == 3) {
            return PlaybackState.PLAYING;
        }
        if (this.stateStore.paused()) {
            return PlaybackState.PAUSED;
        }
        if (state == 4) {
            return this.determineEndedState();
        }
        switch (state) {
            case 1: {
                playbackState = PlaybackState.IDLE;
                break;
            }
            case 2: {
                playbackState = PlaybackState.BUFFERING;
                break;
            }
            case 3: {
                playbackState = PlaybackState.READY;
                break;
            }
            default: {
                playbackState = PlaybackState.IDLE;
            }
        }
        return playbackState;
    }

    private final PlaybackState determineEndedState() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getPlaybackState().ordinal()]) {
            case 1: {
                return PlaybackState.COMPLETED;
            }
            case 2: {
                return PlaybackState.RELEASED;
            }
            case 3: {
                return PlaybackState.STOPPED;
            }
            case 4: {
                return PlaybackState.ERROR;
            }
        }
        boolean completed = this.getCurrentPosition() > 0L && this.getDuration() > 0L && this.getCurrentPosition() + 1000L >= this.getDuration();
        return completed ? PlaybackState.COMPLETED : PlaybackState.STOPPED;
    }

    public static final /* synthetic */ OnBufferUpdateListener access$getBufferUpdateListener$p(ExoMediaPlayerImpl $this) {
        return $this.bufferUpdateListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl$Companion;", "", "()V", "BUFFER_REPEAT_DELAY", "", "COMPLETED_DURATION_LEEWAY", "TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlaybackState.values().length];
            try {
                nArray[PlaybackState.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.RELEASED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

