/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.surface;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.devbrackets.android.exomedia.core.video.scale.MatrixManager;
import com.devbrackets.android.exomedia.core.video.surface.BaseSurfaceEnvelope;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/TextureViewSurfaceEnvelope;", "Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "surface", "matrixManager", "Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;", "(Landroid/view/TextureView;Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;)V", "backingSurface", "Landroid/view/Surface;", "getSurface", "onSurfaceTextureAvailable", "", "Landroid/graphics/SurfaceTexture;", "width", "", "height", "onSurfaceTextureDestroyed", "", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "release", "setVideoSize", "library_release"})
public final class TextureViewSurfaceEnvelope
extends BaseSurfaceEnvelope<TextureView>
implements TextureView.SurfaceTextureListener {
    @NotNull
    private final TextureView surface;
    @Nullable
    private Surface backingSurface;

    public TextureViewSurfaceEnvelope(@NotNull TextureView surface2, @NotNull MatrixManager matrixManager) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)matrixManager, (String)"matrixManager");
        super((View)surface2, matrixManager);
        this.surface = surface2;
        this.surface.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.backingSurface;
    }

    @Override
    public boolean setVideoSize(int width, int height) {
        Unit unit;
        if (!super.setVideoSize(width, height)) {
            return false;
        }
        SurfaceTexture surfaceTexture = this.surface.getSurfaceTexture();
        if (surfaceTexture != null) {
            surfaceTexture.setDefaultBufferSize(width, height);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    @Override
    public void release() {
        super.release();
        this.backingSurface = null;
        this.surface.setSurfaceTextureListener(null);
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface2, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.backingSurface = new Surface(surface2);
        this.getDelegatingCallback().onSurfaceAvailable(this);
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface2, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.getDelegatingCallback().onSurfaceSizeChanged(this, width, height);
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.getDelegatingCallback().onSurfaceDestroyed(this);
        return true;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
    }
}

