/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.net.Uri;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.VideoSize;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.listener.VideoSizeListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003\u007f\u0080\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\rH\u0016J\u0018\u0010U\u001a\u00020\b2\u0006\u0010T\u001a\u00020\r2\u0006\u0010V\u001a\u00020\bH\u0016J\u0010\u0010W\u001a\u00020-2\u0006\u0010T\u001a\u00020\rH\u0016J\u0006\u0010X\u001a\u00020SJ\u0010\u0010Y\u001a\u00020S2\b\u0010\u0004\u001a\u0004\u0018\u00010ZJ\b\u0010[\u001a\u00020SH\u0016J\b\u0010\\\u001a\u00020SH\u0016J\b\u0010]\u001a\u00020SH\u0016J\b\u0010^\u001a\u00020-H\u0016J\u0012\u0010_\u001a\u00020S2\b\b\u0001\u0010`\u001a\u00020\u001aH\u0016J\u0010\u0010a\u001a\u00020S2\u0006\u0010b\u001a\u00020cH\u0016J\u0012\u0010d\u001a\u00020S2\b\u0010e\u001a\u0004\u0018\u00010fH\u0016J\u0010\u0010g\u001a\u00020S2\u0006\u0010h\u001a\u000200H\u0016J\u0012\u0010i\u001a\u00020S2\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u0010\u0010l\u001a\u00020-2\u0006\u0010m\u001a\u00020:H\u0016J\u0010\u0010n\u001a\u00020-2\u0006\u0010o\u001a\u00020:H\u0016J\u0018\u0010p\u001a\u00020S2\u0006\u0010T\u001a\u00020\r2\u0006\u0010q\u001a\u00020-H\u0016J\u0010\u0010r\u001a\u00020S2\u0006\u0010s\u001a\u00020\bH\u0016J \u0010t\u001a\u00020S2\u0006\u0010T\u001a\u00020\r2\u0006\u0010V\u001a\u00020\b2\u0006\u0010u\u001a\u00020\bH\u0016J\u0010\u0010v\u001a\u00020S2\u0006\u0010w\u001a\u00020xH\u0016J\u0010\u0010y\u001a\u00020S2\u0006\u0010z\u001a\u00020\bH\u0016J\b\u0010{\u001a\u00020SH\u0016J\b\u0010|\u001a\u00020SH\u0016J\u0010\u0010|\u001a\u00020S2\u0006\u0010}\u001a\u00020-H\u0016J\b\u0010~\u001a\u00020-H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001cR\u001e\u0010&\u001a\u00060'R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010.\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010<R\u0014\u0010?\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010B\u001a\u00060CR\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020G8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR$\u0010J\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020:8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010<\"\u0004\bL\u0010MR\u0016\u0010N\u001a\u0004\u0018\u00010O8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006\u0081\u0001"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "surface", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;)V", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferedPercent", "getBufferedPercent", "corePlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "getCorePlayer", "()Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "corePlayer$delegate", "Lkotlin/Lazy;", "currentPosition", "", "getCurrentPosition", "()J", "value", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "internalListeners", "Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "getInternalListeners", "()Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "setInternalListeners", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;)V", "isPlaying", "", "()Z", "mux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "setMux", "(Lcom/devbrackets/android/exomedia/core/ListenerMux;)V", "playRequested", "getPlayRequested", "setPlayRequested", "(Z)V", "playbackPitch", "", "getPlaybackPitch", "()F", "playbackSpeed", "getPlaybackSpeed", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "surfaceCallback", "Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "getSurfaceCallback", "()Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onSurfaceDestroyed", "onSurfaceReady", "Landroid/view/Surface;", "pause", "release", "reset", "restart", "seekTo", "milliseconds", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setCaptionListener", "listener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setListenerMux", "listenerMux", "setMedia", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "setPlaybackPitch", "pitch", "setPlaybackSpeed", "speed", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setWakeLevel", "levelAndFlags", "start", "stop", "clearSurface", "trackSelectionAvailable", "InternalListeners", "SurfaceCallback", "library_release"})
public final class ExoVideoPlayer
implements VideoPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final SurfaceEnvelope surface;
    @NotNull
    private final Lazy corePlayer$delegate;
    @Nullable
    private ListenerMux mux;
    private boolean playRequested;
    @NotNull
    private InternalListeners internalListeners;
    @NotNull
    private final SurfaceCallback surfaceCallback;

    public ExoVideoPlayer(@NotNull PlayerConfig config, @NotNull SurfaceEnvelope surface2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.config = config;
        this.surface = surface2;
        this.corePlayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExoMediaPlayerImpl>(this){
            final /* synthetic */ ExoVideoPlayer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ExoMediaPlayerImpl invoke() {
                ExoMediaPlayerImpl exoMediaPlayerImpl = new ExoMediaPlayerImpl(ExoVideoPlayer.access$getConfig$p(this.this$0));
                ExoVideoPlayer exoVideoPlayer = this.this$0;
                ExoMediaPlayerImpl $this$invoke_u24lambda_u240 = exoMediaPlayerImpl;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setMetadataListener(exoVideoPlayer.getInternalListeners());
                $this$invoke_u24lambda_u240.setBufferUpdateListener(exoVideoPlayer.getInternalListeners());
                $this$invoke_u24lambda_u240.setVideoSizeListener(exoVideoPlayer.getInternalListeners());
                return exoMediaPlayerImpl;
            }
        }));
        this.internalListeners = new InternalListeners();
        this.surfaceCallback = new SurfaceCallback();
        this.surface.addCallback(this.surfaceCallback);
        this.surface.setVideoSize(0, 0);
    }

    @NotNull
    public final ExoMediaPlayerImpl getCorePlayer() {
        Lazy lazy = this.corePlayer$delegate;
        return (ExoMediaPlayerImpl)lazy.getValue();
    }

    @Nullable
    public final ListenerMux getMux() {
        return this.mux;
    }

    public final void setMux(@Nullable ListenerMux listenerMux2) {
        this.mux = listenerMux2;
    }

    protected final boolean getPlayRequested() {
        return this.playRequested;
    }

    protected final void setPlayRequested(boolean bl) {
        this.playRequested = bl;
    }

    @NotNull
    protected final InternalListeners getInternalListeners() {
        return this.internalListeners;
    }

    protected final void setInternalListeners(@NotNull InternalListeners internalListeners) {
        Intrinsics.checkNotNullParameter((Object)internalListeners, (String)"<set-?>");
        this.internalListeners = internalListeners;
    }

    @NotNull
    protected final SurfaceCallback getSurfaceCallback() {
        return this.surfaceCallback;
    }

    @Override
    public float getVolume() {
        return this.getCorePlayer().getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.getCorePlayer().setVolume(value);
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.getCorePlayer().getPlayWhenReady();
    }

    @Override
    public long getDuration() {
        ListenerMux listenerMux2 = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux2);
        return !listenerMux2.isPrepared() ? 0L : this.getCorePlayer().getDuration();
    }

    @Override
    public long getCurrentPosition() {
        ListenerMux listenerMux2 = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux2);
        return !listenerMux2.isPrepared() ? 0L : this.getCorePlayer().getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.getCorePlayer().getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.getCorePlayer().getWindowInfo();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.getCorePlayer().getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.getCorePlayer().getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.getCorePlayer().getAvailableTracks();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.getCorePlayer().getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.getCorePlayer().getPlaybackPitch();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.getCorePlayer().getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider value) {
        this.getCorePlayer().setDrmSessionManagerProvider(value);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            listenerMux2.setNotifiedPrepared(false);
        }
        this.getCorePlayer().seekTo(0L);
        MediaItem mediaItem2 = mediaItem;
        if (mediaItem2 != null && (mediaItem2 = mediaItem2.getMediaSource()) != null) {
            MediaItem it = mediaItem2;
            boolean bl = false;
            this.getCorePlayer().setMediaSource((MediaSource)it);
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 != null) {
                listenerMux3.setNotifiedCompleted(false);
            }
            this.getCorePlayer().prepare();
            return;
        }
        MediaItem mediaItem3 = mediaItem;
        if (mediaItem3 != null && (mediaItem3 = mediaItem3.getUri()) != null) {
            MediaItem it = mediaItem3;
            boolean bl = false;
            this.getCorePlayer().setMediaUri((Uri)it);
            ListenerMux listenerMux4 = this.mux;
            if (listenerMux4 != null) {
                listenerMux4.setNotifiedCompleted(false);
            }
            this.getCorePlayer().prepare();
            return;
        }
        this.getCorePlayer().setMediaSource(null);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.getCorePlayer().restart()) {
                return false;
            }
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 != null) {
                listenerMux2.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 == null) break block2;
            listenerMux3.setNotifiedCompleted(false);
        }
        return true;
    }

    @Override
    public void release() {
        this.getCorePlayer().release();
        this.playRequested = false;
        this.surface.removeCallback(this.surfaceCallback);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.getCorePlayer().seekTo(milliseconds);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getCorePlayer().setWakeLevel(levelAndFlags);
    }

    @Override
    public void start() {
        this.getCorePlayer().setPlayWhenReady(true);
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            listenerMux2.setNotifiedCompleted(false);
        }
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.getCorePlayer().setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean clearSurface) {
        block1: {
            this.getCorePlayer().stop();
            this.playRequested = false;
            if (!clearSurface) break block1;
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 != null) {
                listenerMux2.clearSurfaceWhenReady(this.surface);
            }
        }
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.getCorePlayer().setTrackSelectionParameters(parameters);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener2) {
        this.getCorePlayer().setCaptionListener(listener2);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getCorePlayer().getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getCorePlayer().isRendererEnabled(type);
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.getCorePlayer().setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.getCorePlayer().setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.getCorePlayer().setAudioAttributes(attributes);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.getCorePlayer().setRepeatMode(repeatMode);
    }

    public final void onSurfaceReady(@Nullable Surface surface2) {
        this.getCorePlayer().setSurface(surface2);
        if (this.playRequested && surface2 != null) {
            this.getCorePlayer().setPlayWhenReady(true);
        }
    }

    public final void onSurfaceDestroyed() {
        this.getCorePlayer().clearSurface();
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux2) {
        Intrinsics.checkNotNullParameter((Object)listenerMux2, (String)"listenerMux");
        ListenerMux listenerMux3 = this.mux;
        if (listenerMux3 != null) {
            ListenerMux oldListenerMux = listenerMux3;
            boolean bl = false;
            this.getCorePlayer().removeListener(oldListenerMux);
            this.getCorePlayer().removeAnalyticsListener(oldListenerMux);
        }
        this.mux = listenerMux2;
        this.getCorePlayer().addListener(listenerMux2);
        this.getCorePlayer().addAnalyticsListener(listenerMux2);
    }

    public static final /* synthetic */ PlayerConfig access$getConfig$p(ExoVideoPlayer $this) {
        return $this.config;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "Lcom/devbrackets/android/exomedia/core/listener/VideoSizeListener;", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;)V", "onBufferingUpdate", "", "percent", "", "onMetadata", "metadata", "Landroidx/media3/common/Metadata;", "onVideoSizeChanged", "videoSize", "Landroidx/media3/common/VideoSize;", "library_release"})
    protected final class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener,
    VideoSizeListener {
        @Override
        public void onMetadata(@NotNull androidx.media3.common.Metadata metadata) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                ListenerMux listenerMux2 = ExoVideoPlayer.this.getMux();
                if (listenerMux2 == null) break block0;
                listenerMux2.onMetadata(metadata);
            }
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            block0: {
                ListenerMux listenerMux2 = ExoVideoPlayer.this.getMux();
                if (listenerMux2 == null) break block0;
                listenerMux2.onBufferingUpdate(percent);
            }
        }

        @Override
        public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
                ListenerMux listenerMux2 = ExoVideoPlayer.this.getMux();
                if (listenerMux2 == null) break block0;
                listenerMux2.onVideoSizeChanged(videoSize.width, videoSize.height, videoSize.unappliedRotationDegrees, videoSize.pixelWidthHeightRatio);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope$Callback;", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;)V", "onSurfaceAvailable", "", "envelope", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "onSurfaceDestroyed", "onSurfaceSizeChanged", "width", "", "height", "library_release"})
    protected final class SurfaceCallback
    implements SurfaceEnvelope.Callback {
        @Override
        public void onSurfaceAvailable(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            ExoVideoPlayer.this.onSurfaceReady(envelope.getSurface());
        }

        @Override
        public void onSurfaceDestroyed(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            ExoVideoPlayer.this.onSurfaceDestroyed();
            envelope.release();
        }

        @Override
        public void onSurfaceSizeChanged(@NotNull SurfaceEnvelope envelope, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        }
    }
}

