/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.renderer.provider;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.audio.AudioCapabilities;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.audio.DecoderAudioRenderer;
import androidx.media3.exoplayer.audio.MediaCodecAudioRenderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.renderer.provider.AbstractRenderProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/devbrackets/android/exomedia/core/renderer/provider/AudioRenderProvider;", "Lcom/devbrackets/android/exomedia/core/renderer/provider/AbstractRenderProvider;", "()V", "buildRenderer", "Landroidx/media3/exoplayer/Renderer;", "className", "", "handler", "Landroid/os/Handler;", "listener", "Landroidx/media3/exoplayer/audio/AudioRendererEventListener;", "buildRenderers", "", "context", "Landroid/content/Context;", "rendererClasses", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public class AudioRenderProvider
extends AbstractRenderProvider {
    public AudioRenderProvider() {
        super(RendererType.AUDIO);
    }

    @Override
    @NotNull
    public List<String> rendererClasses() {
        Object[] objectArray = new String[]{"androidx.media3.decoder.ffmpeg.FfmpegAudioRenderer", "androidx.media3.decoder.flac.LibflacAudioRenderer", "androidx.media3.decoder.opus.LibopusAudioRenderer"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Renderer> buildRenderers(@NotNull Context context, @NotNull Handler handler, @NotNull AudioRendererEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        MediaCodecAudioRenderer initialRenderer = new MediaCodecAudioRenderer(context, MediaCodecSelector.DEFAULT, handler, listener2, AudioCapabilities.getCapabilities((Context)context), new AudioProcessor[0]);
        Renderer[] rendererArray = new Renderer[]{initialRenderer};
        return this.buildRenderers(rendererArray, (Function1<? super String, ? extends Renderer>)((Function1)new Function1<String, Renderer>(this, handler, listener2){
            final /* synthetic */ AudioRenderProvider this$0;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ AudioRendererEventListener $listener;
            {
                this.this$0 = $receiver;
                this.$handler = $handler;
                this.$listener = $listener;
                super(1);
            }

            @Nullable
            public final Renderer invoke(@NotNull String className) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                return AudioRenderProvider.access$buildRenderer(this.this$0, className, this.$handler, this.$listener);
            }
        }));
    }

    private final Renderer buildRenderer(String className, Handler handler, AudioRendererEventListener listener2) {
        Renderer renderer;
        Class<?> rendererClass = Class.forName(className);
        if (Intrinsics.areEqual(rendererClass, DecoderAudioRenderer.class)) {
            Intrinsics.checkNotNull(rendererClass);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Handler.class), (Object)handler), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(AudioRendererEventListener.class), (Object)listener2), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(new AudioProcessor[0].getClass()), (Object)new AudioProcessor[0])};
            renderer = (Renderer)this.newInstance(rendererClass, pairArray);
        } else {
            Log.w((String)"AudioRenderProvider", (String)("Unsupported audio Renderer class " + rendererClass));
            renderer = null;
        }
        return renderer;
    }

    public static final /* synthetic */ Renderer access$buildRenderer(AudioRenderProvider $this, String className, Handler handler, AudioRendererEventListener listener2) {
        return $this.buildRenderer(className, handler, listener2);
    }
}

