/*
 * Decompiled with CFR 0.152.
 */
package com.deque.axe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AXE {
    private static final String lineSeparator = System.getProperty("line.separator");

    private static String getContents(URL script) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            URLConnection connection = script.openConnection();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(lineSeparator);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return sb.toString();
    }

    public static void inject(WebDriver driver, URL scriptUrl) {
        String script = AXE.getContents(scriptUrl);
        ArrayList<WebElement> parents = new ArrayList<WebElement>();
        AXE.injectIntoFrames(driver, script, parents);
        JavascriptExecutor js = (JavascriptExecutor)driver;
        driver.switchTo().defaultContent();
        js.executeScript(script, new Object[0]);
    }

    private static void injectIntoFrames(WebDriver driver, String script, ArrayList<WebElement> parents) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        List frames = driver.findElements(By.tagName((String)"iframe"));
        for (WebElement frame : frames) {
            driver.switchTo().defaultContent();
            if (parents != null) {
                for (WebElement parent : parents) {
                    driver.switchTo().frame(parent);
                }
            }
            driver.switchTo().frame(frame);
            js.executeScript(script, new Object[0]);
            ArrayList localParents = (ArrayList)parents.clone();
            localParents.add(frame);
            AXE.injectIntoFrames(driver, script, localParents);
        }
    }

    public static String report(JSONArray violations) {
        StringBuilder sb = new StringBuilder();
        sb.append("Found ").append(violations.length()).append(" accessibility violations:");
        for (int i = 0; i < violations.length(); ++i) {
            JSONObject violation = violations.getJSONObject(i);
            sb.append(lineSeparator).append(i + 1).append(") ").append(violation.getString("help"));
            if (violation.has("helpUrl")) {
                String helpUrl = violation.getString("helpUrl");
                sb.append(": ").append(helpUrl);
            }
            JSONArray nodes = violation.getJSONArray("nodes");
            for (int j = 0; j < nodes.length(); ++j) {
                JSONObject node = nodes.getJSONObject(j);
                sb.append(lineSeparator).append("  ").append(AXE.getOrdinal(j + 1)).append(") ").append(node.getJSONArray("target")).append(lineSeparator);
                JSONArray all = node.getJSONArray("all");
                JSONArray none = node.getJSONArray("none");
                for (int k = 0; k < none.length(); ++k) {
                    all.put((Object)none.getJSONObject(k));
                }
                AXE.appendFixes(sb, all, "Fix all of the following:");
                AXE.appendFixes(sb, node.getJSONArray("any"), "Fix any of the following:");
            }
        }
        return sb.toString();
    }

    private static void appendFixes(StringBuilder sb, JSONArray arr, String heading) {
        if (arr != null && arr.length() > 0) {
            sb.append("    ").append(heading).append(lineSeparator);
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject fix = arr.getJSONObject(i);
                sb.append("      ").append(fix.get("message")).append(lineSeparator);
            }
            sb.append(lineSeparator);
        }
    }

    private static String getOrdinal(int number) {
        String ordinal = "";
        while (number > 0) {
            int mod = (number - 1) % 26;
            ordinal = (char)(mod + 97) + ordinal;
            number = (number - mod) / 26;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResults(String name, Object output) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name + ".json"), "utf-8"));
            writer.write(output.toString());
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ignored) {}
        }
    }

    public static class Builder {
        private final WebDriver driver;
        private final URL script;
        private final List<String> includes = new ArrayList<String>();
        private final List<String> excludes = new ArrayList<String>();
        private String options = "null";

        public Builder(WebDriver driver, URL script) {
            this.driver = driver;
            this.script = script;
            AXE.inject(this.driver, this.script);
        }

        public Builder options(String options) {
            this.options = options;
            return this;
        }

        public Builder include(String selector) {
            this.includes.add(selector);
            return this;
        }

        public Builder exclude(String selector) {
            this.excludes.add(selector);
            return this;
        }

        public JSONObject analyze() {
            String command = this.includes.size() > 1 || this.excludes.size() > 0 ? String.format("axe.a11yCheck({include: [%s], exclude: [%s]}, %s, arguments[arguments.length - 1]);", "['" + StringUtils.join(this.includes, (String)"'],['") + "']", this.excludes.size() == 0 ? "" : "['" + StringUtils.join(this.excludes, (String)"'],['") + "']", this.options) : (this.includes.size() == 1 ? String.format("axe.a11yCheck('%s', %s, arguments[arguments.length - 1]);", this.includes.get(0).replace("'", ""), this.options) : String.format("axe.a11yCheck(document, %s, arguments[arguments.length - 1]);", this.options));
            return this.execute(command, new Object[0]);
        }

        public JSONObject analyze(WebElement context) {
            String command = String.format("axe.a11yCheck(arguments[0], %s, arguments[arguments.length - 1]);", this.options);
            return this.execute(command, context);
        }

        private JSONObject execute(String command, Object ... args) {
            this.driver.manage().timeouts().setScriptTimeout(30L, TimeUnit.SECONDS);
            Object response = ((JavascriptExecutor)this.driver).executeAsyncScript(command, args);
            return new JSONObject((Map)response);
        }
    }
}

