/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Insert;
import org.jooq.Merge;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Routine;
import org.jooq.SQLDialect;
import org.jooq.Update;
import org.jooq.conf.Settings;
import org.jooq.impl.DataMap;
import org.jooq.impl.ProviderEnabledConnection;
import org.jooq.impl.SettingsEnabledConnection;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;

class DefaultExecuteContext
implements ExecuteContext {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultExecuteContext.class);
    private final Configuration configuration;
    private final Map<Object, Object> data;
    private final Query query;
    private final Routine<?> routine;
    private String sql;
    private final boolean batch;
    private final Query[] batchQueries;
    private final String[] batchSQL;
    private final int[] batchRows;
    private transient ConnectionProvider connectionProvider;
    private transient Connection connection;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private transient Record record;
    private transient Result<?> result;
    private transient int rows = -1;
    private transient RuntimeException exception;
    private transient SQLException sqlException;
    private transient SQLWarning sqlWarning;
    private static final ThreadLocal<List<Blob>> BLOBS = new ThreadLocal();
    private static final ThreadLocal<List<Clob>> CLOBS = new ThreadLocal();
    private static final ThreadLocal<List<SQLXML>> SQLXMLS = new ThreadLocal();
    private static final ThreadLocal<List<Array>> ARRAYS = new ThreadLocal();
    private static final ThreadLocal<Configuration> LOCAL_CONFIGURATION = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> LOCAL_DATA = new ThreadLocal();
    private static final ThreadLocal<Connection> LOCAL_CONNECTION = new ThreadLocal();
    private static int maxUnwrappedConnections = 256;

    static final void clean() {
        List<Blob> blobs = BLOBS.get();
        List<Clob> clobs = CLOBS.get();
        List<SQLXML> xmls = SQLXMLS.get();
        List<Array> arrays = ARRAYS.get();
        if (blobs != null) {
            for (Blob blob : blobs) {
                JDBCUtils.safeFree(blob);
            }
            BLOBS.remove();
        }
        if (clobs != null) {
            for (Clob clob : clobs) {
                JDBCUtils.safeFree(clob);
            }
            CLOBS.remove();
        }
        if (xmls != null) {
            for (SQLXML xml : xmls) {
                JDBCUtils.safeFree(xml);
            }
            SQLXMLS.remove();
        }
        if (arrays != null) {
            for (Array array : arrays) {
                JDBCUtils.safeFree(array);
            }
            ARRAYS.remove();
        }
        LOCAL_CONFIGURATION.remove();
        LOCAL_DATA.remove();
        LOCAL_CONNECTION.remove();
    }

    static final void register(Blob blob) {
        List<Blob> list = BLOBS.get();
        if (list == null) {
            list = new ArrayList<Blob>();
            BLOBS.set(list);
        }
        list.add(blob);
    }

    static final void register(Clob clob) {
        List<Clob> list = CLOBS.get();
        if (list == null) {
            list = new ArrayList<Clob>();
            CLOBS.set(list);
        }
        list.add(clob);
    }

    static final void register(SQLXML xml) {
        List<SQLXML> list = SQLXMLS.get();
        if (list == null) {
            list = new ArrayList<SQLXML>();
            SQLXMLS.set(list);
        }
        list.add(xml);
    }

    static final void register(Array array) {
        List<Array> list = ARRAYS.get();
        if (list == null) {
            list = new ArrayList<Array>();
            ARRAYS.set(list);
        }
        list.add(array);
    }

    static final Configuration localConfiguration() {
        return LOCAL_CONFIGURATION.get();
    }

    static final Map<Object, Object> localData() {
        return LOCAL_DATA.get();
    }

    static final Connection localConnection() {
        return LOCAL_CONNECTION.get();
    }

    static final Connection localTargetConnection() {
        Connection result = DefaultExecuteContext.localConnection();
        for (int i = 0; i < maxUnwrappedConnections; ++i) {
            Connection r2;
            try {
                r2 = (Connection)Reflect.on(result).call("getTargetConnection").get();
                if (result != r2 && r2 != null) {
                    result = r2;
                    continue;
                }
            }
            catch (ReflectException r2) {
                // empty catch block
            }
            try {
                r2 = (Connection)Reflect.on(result).call("getDelegate").get();
                if (result == r2 || r2 == null) break;
                result = r2;
                continue;
            }
            catch (ReflectException reflectException) {
                break;
            }
        }
        return result;
    }

    DefaultExecuteContext(Configuration configuration) {
        this(configuration, null, null, null);
    }

    DefaultExecuteContext(Configuration configuration, Query[] batchQueries) {
        this(configuration, null, batchQueries, null);
    }

    DefaultExecuteContext(Configuration configuration, Query query) {
        this(configuration, query, null, null);
    }

    DefaultExecuteContext(Configuration configuration, Routine<?> routine) {
        this(configuration, null, null, routine);
    }

    private DefaultExecuteContext(Configuration configuration, Query query, Query[] batchQueries, Routine<?> routine) {
        this.configuration = configuration;
        this.data = new DataMap();
        this.query = query;
        this.routine = routine;
        if (routine != null) {
            this.batch = false;
            this.batchQueries = new Query[0];
            this.batchRows = new int[]{-1};
            this.batchSQL = new String[1];
        } else if (batchQueries != null) {
            this.batch = true;
            this.batchQueries = batchQueries;
            this.batchRows = new int[batchQueries.length];
            this.batchSQL = new String[batchQueries.length];
            Arrays.fill(this.batchRows, -1);
        } else if (query == null) {
            this.batch = false;
            this.batchQueries = new Query[0];
            this.batchRows = new int[0];
            this.batchSQL = new String[0];
        } else {
            this.batch = false;
            this.batchQueries = new Query[]{query};
            this.batchRows = new int[]{-1};
            this.batchSQL = new String[1];
        }
        DefaultExecuteContext.clean();
        LOCAL_CONFIGURATION.set(configuration);
        LOCAL_DATA.set(this.data);
    }

    @Override
    public final Map<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public final ExecuteType type() {
        if (this.routine != null) {
            return ExecuteType.ROUTINE;
        }
        if (this.batch) {
            return ExecuteType.BATCH;
        }
        if (this.query != null) {
            if (this.query instanceof ResultQuery) {
                return ExecuteType.READ;
            }
            if (this.query instanceof Insert || this.query instanceof Update || this.query instanceof Delete || this.query instanceof Merge) {
                return ExecuteType.WRITE;
            }
            if (this.query instanceof DDLQuery) {
                return ExecuteType.DDL;
            }
            String s2 = this.query.getSQL().toLowerCase();
            if (s2.matches("^(with\\b.*?\\bselect|select|explain)\\b.*?")) {
                return ExecuteType.READ;
            }
            if (s2.matches("^(insert|update|delete|merge|replace|upsert|lock)\\b.*?")) {
                return ExecuteType.WRITE;
            }
            if (s2.matches("^(create|alter|drop|truncate|grant|revoke|analyze|comment|flashback|enable|disable)\\b.*?")) {
                return ExecuteType.DDL;
            }
            if (s2.matches("^\\s*\\{\\s*(\\?\\s*=\\s*)call.*?")) {
                return ExecuteType.ROUTINE;
            }
            if (s2.matches("^(call|begin|declare)\\b.*?")) {
                return ExecuteType.ROUTINE;
            }
        } else if (this.resultSet != null) {
            return ExecuteType.READ;
        }
        return ExecuteType.OTHER;
    }

    @Override
    public final Query query() {
        return this.query;
    }

    @Override
    public final Query[] batchQueries() {
        return this.batchQueries;
    }

    @Override
    public final Routine<?> routine() {
        return this.routine;
    }

    @Override
    public final void sql(String s2) {
        this.sql = s2;
        if (this.batchSQL.length == 1) {
            this.batchSQL[0] = s2;
        }
    }

    @Override
    public final String sql() {
        return this.sql;
    }

    @Override
    public final String[] batchSQL() {
        return this.batchSQL;
    }

    @Override
    public final void statement(PreparedStatement s2) {
        this.statement = s2;
    }

    @Override
    public final PreparedStatement statement() {
        return this.statement;
    }

    @Override
    public final void resultSet(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public final ResultSet resultSet() {
        return this.resultSet;
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final DSLContext dsl() {
        return this.configuration.dsl();
    }

    @Override
    public final Settings settings() {
        return Tools.settings(this.configuration());
    }

    @Override
    public final SQLDialect dialect() {
        return Tools.configuration(this.configuration()).dialect();
    }

    @Override
    public final SQLDialect family() {
        return this.dialect().family();
    }

    @Override
    public final void connectionProvider(ConnectionProvider provider) {
        this.connectionProvider = provider;
    }

    @Override
    public final Connection connection() {
        ConnectionProvider provider;
        ConnectionProvider connectionProvider = provider = this.connectionProvider != null ? this.connectionProvider : this.configuration.connectionProvider();
        if (this.connection == null && provider != null) {
            this.connection(provider, provider.acquire());
        }
        return this.connection;
    }

    final void connection(ConnectionProvider provider, Connection c) {
        if (c != null) {
            LOCAL_CONNECTION.set(c);
            this.connection = new SettingsEnabledConnection(new ProviderEnabledConnection(provider, c), this.configuration.settings());
        }
    }

    @Override
    public final void record(Record r) {
        this.record = r;
    }

    @Override
    public final Record record() {
        return this.record;
    }

    @Override
    public final int rows() {
        return this.rows;
    }

    @Override
    public final void rows(int r) {
        this.rows = r;
        if (this.batchRows.length == 1) {
            this.batchRows[0] = r;
        }
    }

    @Override
    public final int[] batchRows() {
        return this.batchRows;
    }

    @Override
    public final void result(Result<?> r) {
        this.result = r;
    }

    @Override
    public final Result<?> result() {
        return this.result;
    }

    @Override
    public final RuntimeException exception() {
        return this.exception;
    }

    @Override
    public final void exception(RuntimeException e) {
        StackTraceElement[] oldStack;
        this.exception = e;
        if (Boolean.TRUE.equals(this.settings().isDebugInfoOnStackTrace()) && (oldStack = e.getStackTrace()) != null) {
            StackTraceElement[] newStack = new StackTraceElement[oldStack.length + 1];
            System.arraycopy(oldStack, 0, newStack, 1, oldStack.length);
            newStack[0] = new StackTraceElement("org.jooq_3.10.6." + (Object)((Object)this.dialect()), "debug", null, -1);
            e.setStackTrace(newStack);
        }
    }

    @Override
    public final SQLException sqlException() {
        return this.sqlException;
    }

    @Override
    public final void sqlException(SQLException e) {
        this.sqlException = e;
        this.exception(Tools.translate(this.sql(), e));
    }

    @Override
    public final SQLWarning sqlWarning() {
        return this.sqlWarning;
    }

    @Override
    public final void sqlWarning(SQLWarning e) {
        this.sqlWarning = e;
    }
}

