/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Attachable;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Scope;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.MappingException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindingSQLContext;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.Keywords;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.jdbc.MockArray;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UNumber;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.util.postgres.PostgresUtils;

public class DefaultBinding<T, U>
implements Binding<T, U> {
    static final JooqLogger log = JooqLogger.getLogger(DefaultBinding.class);
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final long serialVersionUID = -198499389344950496L;
    final Class<T> type;
    final Converter<T, U> converter;
    @Deprecated
    final boolean isLob;
    private static final Pattern LENIENT_OFFSET_PATTERN = Pattern.compile("(?:(\\d{4}-\\d{2}-\\d{2})[T ])?(\\d{2}:\\d{2}(:\\d{2})?(?:\\.\\d+)?)(?: +)?(([+-])(\\d)?(\\d)(:\\d{2})?)?");

    public DefaultBinding(Converter<T, U> converter) {
        this(converter, false);
    }

    DefaultBinding(Converter<T, U> converter, boolean isLob) {
        this.type = converter.fromType();
        this.converter = converter;
        this.isLob = isLob;
    }

    static final <T, X, U> Binding<T, U> newBinding(final Converter<X, U> converter, DataType<T> type, final Binding<T, X> binding) {
        Binding<Object, Object> theBinding = converter == null && binding == null ? type.getBinding() : (converter == null ? binding : (binding == null ? new DefaultBinding<X, U>(converter, type.isLob()) : new Binding<T, U>(){
            private static final long serialVersionUID = 8912340791845209886L;
            final Converter<T, U> theConverter;
            {
                this.theConverter = Converters.of(binding.converter(), converter);
            }

            @Override
            public Converter<T, U> converter() {
                return this.theConverter;
            }

            @Override
            public void sql(BindingSQLContext<U> ctx) throws SQLException {
                binding.sql(ctx.convert(converter));
            }

            @Override
            public void register(BindingRegisterContext<U> ctx) throws SQLException {
                binding.register(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetStatementContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetStatementContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }
        }));
        return theBinding;
    }

    @Override
    public Converter<T, U> converter() {
        return this.converter;
    }

    @Override
    public void sql(BindingSQLContext<U> ctx) {
        T converted = this.converter.to(ctx.value());
        switch (ctx.render().castMode()) {
            case NEVER: {
                this.toSQL(ctx, converted);
                return;
            }
            case ALWAYS: {
                this.toSQLCast(ctx, converted);
                return;
            }
        }
        if (this.shouldCast(ctx, converted)) {
            this.toSQLCast(ctx, converted);
        } else {
            this.toSQL(ctx, converted);
        }
    }

    private final boolean shouldCast(BindingSQLContext<U> ctx, T converted) {
        if (ctx.render().paramType() != ParamType.INLINED && !(converted instanceof EnumType)) {
            switch (ctx.family()) {
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case CUBRID: 
                case POSTGRES: {
                    return true;
                }
            }
        }
        if (Interval.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    return true;
                }
            }
        }
        return false;
    }

    private final void toSQLCast(BindingSQLContext<U> ctx, T converted) {
        DataType<T> dataType = DefaultDataType.getDataType(ctx.dialect(), this.type);
        DataType<T> sqlDataType = dataType.getSQLDataType();
        SQLDialect family = ctx.family();
        if (converted != null && this.type == BigDecimal.class && Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB).contains((Object)family)) {
            int precision;
            int scale = ((BigDecimal)converted).scale();
            if (scale >= (precision = ((BigDecimal)converted).precision())) {
                precision = scale + 1;
            }
            this.toSQLCast(ctx, converted, dataType, 0, precision, scale);
        } else if (SQLDataType.OTHER == sqlDataType) {
            if (converted != null) {
                this.toSQLCast(ctx, converted, DefaultDataType.getDataType(family, converted.getClass()), 0, 0, 0);
            } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                ctx.render().sql(ctx.variable());
            } else {
                this.toSQLCast(ctx, converted, DefaultDataType.getDataType(family, String.class), 0, 0, 0);
            }
        } else if (Arrays.asList(SQLDialect.POSTGRES).contains((Object)family) && (sqlDataType == null || !sqlDataType.isTemporal())) {
            this.toSQL(ctx, converted);
        } else if ((sqlDataType == SQLDataType.VARCHAR || sqlDataType == SQLDataType.CHAR) && Arrays.asList(SQLDialect.FIREBIRD).contains((Object)family)) {
            this.toSQLCast(ctx, converted, dataType, DefaultBinding.getValueLength((String)converted), 0, 0);
        } else {
            this.toSQLCast(ctx, converted, dataType, dataType.length(), dataType.precision(), dataType.scale());
        }
    }

    private static final int getValueLength(String string) {
        if (string == null) {
            return 1;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return Math.min(32672, 4 * length);
        }
        return Math.min(32672, length);
    }

    private final void toSQLCast(BindingSQLContext<U> ctx, T converted, DataType<?> dataType, int length, int precision, int scale) {
        ((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(');
        this.toSQL(ctx, converted);
        ((RenderContext)ctx.render().sql(' ').visit(Keywords.K_AS)).sql(' ').sql(dataType.length(length).precision(precision, scale).getCastTypeName(ctx.configuration())).sql(')');
    }

    private final void toSQL(BindingSQLContext<U> ctx, Object val) {
        SQLDialect family = ctx.family();
        RenderContext render = ctx.render();
        if (render.paramType() == ParamType.INLINED) {
            if (val == null) {
                render.visit(Keywords.K_NULL);
            } else if (this.type == Boolean.class) {
                if (Arrays.asList(SQLDialect.FIREBIRD, SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql((Boolean)val != false ? "1" : "0");
                } else {
                    render.visit((Boolean)val != false ? Keywords.K_TRUE : Keywords.K_FALSE);
                }
            } else if (this.type == byte[].class) {
                byte[] binary = (byte[])val;
                if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    render.sql("0x").sql(DefaultBinding.convertBytesToHex(binary));
                } else if (Arrays.asList(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql("X'").sql(DefaultBinding.convertBytesToHex(binary)).sql('\'');
                } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    render.sql("hextoraw('").sql(DefaultBinding.convertBytesToHex(binary)).sql("')");
                } else if (family == SQLDialect.POSTGRES) {
                    render.sql("E'").sql(PostgresUtils.toPGString(binary)).sql("'::bytea");
                } else {
                    render.sql("X'").sql(DefaultBinding.convertBytesToHex(binary)).sql('\'');
                }
            } else if (Interval.class.isAssignableFrom(this.type)) {
                render.sql('\'').sql(DefaultBinding.escape(val, render)).sql('\'');
            } else if (Double.class.isAssignableFrom(this.type) && ((Double)val).isNaN()) {
                if (SQLDialect.POSTGRES == family) {
                    ((RenderContext)render.visit(DSL.inline("NaN"))).sql("::float8");
                } else {
                    render.sql(((Number)val).toString());
                }
            } else if (Float.class.isAssignableFrom(this.type) && ((Float)val).isNaN()) {
                if (SQLDialect.POSTGRES == family) {
                    ((RenderContext)render.visit(DSL.inline("NaN"))).sql("::float4");
                } else {
                    render.sql(((Number)val).toString());
                }
            } else if (Number.class.isAssignableFrom(this.type)) {
                render.sql(((Number)val).toString());
            } else if (Tools.isDate(this.type)) {
                java.sql.Date date = DefaultBinding.getDate(this.type, val);
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(DefaultBinding.escape(date, render)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    ((RenderContext)render.visit(Keywords.K_DATE)).sql("('").sql(DefaultBinding.escape(date, render)).sql("')");
                } else if (family == SQLDialect.MYSQL) {
                    render.sql("{d '").sql(DefaultBinding.escape(date, render)).sql("'}");
                } else {
                    ((RenderContext)render.visit(Keywords.K_DATE)).sql(" '").sql(DefaultBinding.escape(date, render)).sql('\'');
                }
            } else if (Tools.isTimestamp(this.type)) {
                Timestamp ts = DefaultBinding.getTimestamp(this.type, val);
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(DefaultBinding.escape(ts, render)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    ((RenderContext)render.visit(Keywords.K_TIMESTAMP)).sql("('").sql(DefaultBinding.escape(ts, render)).sql("')");
                } else if (family == SQLDialect.CUBRID) {
                    ((RenderContext)render.visit(Keywords.K_DATETIME)).sql(" '").sql(DefaultBinding.escape(ts, render)).sql('\'');
                } else if (family == SQLDialect.MYSQL) {
                    render.sql("{ts '").sql(DefaultBinding.escape(ts, render)).sql("'}");
                } else {
                    ((RenderContext)render.visit(Keywords.K_TIMESTAMP)).sql(" '").sql(DefaultBinding.escape(ts, render)).sql('\'');
                }
            } else if (Tools.isTime(this.type)) {
                Time time = DefaultBinding.getTime(this.type, val);
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(new SimpleDateFormat("HH:mm:ss").format(time)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    ((RenderContext)render.visit(Keywords.K_TIME)).sql("('").sql(DefaultBinding.escape(time, render)).sql("')");
                } else if (family == SQLDialect.MYSQL) {
                    render.sql("{t '").sql(DefaultBinding.escape(time, render)).sql("'}");
                } else {
                    ((RenderContext)render.visit(Keywords.K_TIME)).sql(" '").sql(DefaultBinding.escape(time, render)).sql('\'');
                }
            } else if (this.type == OffsetDateTime.class) {
                if (family == SQLDialect.H2) {
                    ((RenderContext)((RenderContext)((RenderContext)render.visit(Keywords.K_CAST)).sql("('").sql(DefaultBinding.escape(DefaultBinding.format((OffsetDateTime)val), render)).sql("' ").visit(Keywords.K_AS)).sql(' ').visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(')');
                } else {
                    ((RenderContext)render.visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(" '").sql(DefaultBinding.escape(DefaultBinding.format((OffsetDateTime)val), render)).sql('\'');
                }
            } else if (this.type == OffsetTime.class) {
                String string = DefaultBinding.format((OffsetTime)val);
                ((RenderContext)render.visit(Keywords.K_TIME_WITH_TIME_ZONE)).sql(" '").sql(DefaultBinding.escape(string, render)).sql('\'');
            } else if (this.type.isArray()) {
                String separator = "";
                if (family == SQLDialect.H2) {
                    render.sql('(');
                    for (Object o : (Object[])val) {
                        render.sql(separator);
                        new DefaultBinding(Converters.identity(this.type.getComponentType()), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                        separator = ", ";
                    }
                    render.sql(')');
                } else if (family == SQLDialect.POSTGRES) {
                    render.visit(DSL.cast(DSL.inline(PostgresUtils.toPGArrayString((Object[])val)), this.type));
                } else {
                    render.visit(Keywords.K_ARRAY);
                    render.sql('[');
                    for (Object o : (Object[])val) {
                        render.sql(separator);
                        new DefaultBinding(Converters.identity(this.type.getComponentType()), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                        separator = ", ";
                    }
                    render.sql(']');
                    if (family == SQLDialect.POSTGRES && EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                        DefaultBinding.pgRenderEnumCast(render, this.type);
                    }
                }
            } else if (EnumType.class.isAssignableFrom(this.type)) {
                String literal = ((EnumType)val).getLiteral();
                if (literal == null) {
                    new DefaultBinding<String, String>(Converters.identity(String.class), this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
                } else {
                    new DefaultBinding<String, String>(Converters.identity(String.class), this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
                }
            } else if (UDTRecord.class.isAssignableFrom(this.type)) {
                render.sql("[UDT]");
            } else {
                render.sql('\'').sql(DefaultBinding.escape(val, render), true).sql('\'');
            }
        } else if (family == SQLDialect.POSTGRES) {
            if (EnumType.class.isAssignableFrom(this.type) || this.type.isArray() && EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                render.sql(ctx.variable());
                DefaultBinding.pgRenderEnumCast(render, this.type);
            } else if (this.type.isArray() && byte[].class != this.type) {
                render.sql(ctx.variable());
                render.sql("::");
                render.sql(DefaultDataType.getDataType(family, this.type).getCastTypeName(render.configuration()));
            } else {
                render.sql(ctx.variable());
            }
        } else {
            render.sql(ctx.variable());
        }
    }

    private static final Time getTime(Class<?> t, Object val) {
        return t == Time.class ? (Time)val : Time.valueOf((LocalTime)val);
    }

    private static final Timestamp getTimestamp(Class<?> t, Object val) {
        return t == Timestamp.class ? (Timestamp)val : Timestamp.valueOf((LocalDateTime)val);
    }

    private static final java.sql.Date getDate(Class<?> t, Object val) {
        return t == java.sql.Date.class ? (java.sql.Date)val : java.sql.Date.valueOf((LocalDate)val);
    }

    private static final String escape(Object val, Context<?> context) {
        String result = val.toString();
        if (Tools.needsBackslashEscaping(context.configuration())) {
            result = StringUtils.replace(result, "\\", "\\\\");
        }
        return StringUtils.replace(result, "'", "''");
    }

    private static final String convertBytesToHex(byte[] value) {
        return DefaultBinding.convertBytesToHex(value, value.length);
    }

    private static final String convertBytesToHex(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        Configuration configuration = ctx.configuration();
        int sqlType = DefaultDataType.getDataType(ctx.dialect(), this.type).getSQLType(ctx.configuration());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registering variable " + ctx.index()), "" + this.type);
        }
        switch (configuration.family()) {
            default: 
        }
        ctx.statement().registerOutParameter(ctx.index(), sqlType);
    }

    @Override
    public void set(BindingSetStatementContext<U> ctx) throws SQLException {
        block36: {
            Class<Object> actualType;
            T value;
            block62: {
                SQLDialect dialect;
                block61: {
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block52: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    block48: {
                                                                        block47: {
                                                                            block46: {
                                                                                block45: {
                                                                                    block44: {
                                                                                        block43: {
                                                                                            block42: {
                                                                                                block41: {
                                                                                                    block40: {
                                                                                                        block39: {
                                                                                                            block38: {
                                                                                                                block37: {
                                                                                                                    block35: {
                                                                                                                        Configuration configuration = ctx.configuration();
                                                                                                                        dialect = ctx.dialect();
                                                                                                                        value = this.converter.to(ctx.value());
                                                                                                                        if (log.isTraceEnabled()) {
                                                                                                                            if (value != null && value.getClass().isArray() && value.getClass() != byte[].class) {
                                                                                                                                log.trace((Object)("Binding variable " + ctx.index()), Arrays.asList((Object[])value) + " (" + this.type + ")");
                                                                                                                            } else {
                                                                                                                                log.trace((Object)("Binding variable " + ctx.index()), value + " (" + this.type + ")");
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (value != null) break block35;
                                                                                                                        int sqlType = DefaultDataType.getDataType(dialect, this.type).getSQLType(configuration);
                                                                                                                        if (UDTRecord.class.isAssignableFrom(this.type)) {
                                                                                                                            ctx.statement().setNull(ctx.index(), sqlType, Tools.getMappedUDTName(configuration, this.type));
                                                                                                                        } else if (Arrays.asList(SQLDialect.POSTGRES).contains((Object)configuration.family()) && sqlType == 2004) {
                                                                                                                            ctx.statement().setNull(ctx.index(), -2);
                                                                                                                        } else if (sqlType != 1111) {
                                                                                                                            ctx.statement().setNull(ctx.index(), sqlType);
                                                                                                                        } else {
                                                                                                                            ctx.statement().setObject(ctx.index(), null);
                                                                                                                        }
                                                                                                                        break block36;
                                                                                                                    }
                                                                                                                    actualType = this.type;
                                                                                                                    if (actualType == Object.class) {
                                                                                                                        actualType = value.getClass();
                                                                                                                    }
                                                                                                                    if (actualType != Blob.class) break block37;
                                                                                                                    ctx.statement().setBlob(ctx.index(), (Blob)value);
                                                                                                                    break block36;
                                                                                                                }
                                                                                                                if (actualType != Boolean.class) break block38;
                                                                                                                ctx.statement().setBoolean(ctx.index(), (Boolean)value);
                                                                                                                break block36;
                                                                                                            }
                                                                                                            if (actualType != BigDecimal.class) break block39;
                                                                                                            if (Arrays.asList(SQLDialect.SQLITE).contains((Object)dialect.family())) {
                                                                                                                ctx.statement().setString(ctx.index(), value.toString());
                                                                                                            } else {
                                                                                                                ctx.statement().setBigDecimal(ctx.index(), (BigDecimal)value);
                                                                                                            }
                                                                                                            break block36;
                                                                                                        }
                                                                                                        if (actualType != BigInteger.class) break block40;
                                                                                                        if (Arrays.asList(SQLDialect.SQLITE).contains((Object)dialect.family())) {
                                                                                                            ctx.statement().setString(ctx.index(), value.toString());
                                                                                                        } else {
                                                                                                            ctx.statement().setBigDecimal(ctx.index(), new BigDecimal((BigInteger)value));
                                                                                                        }
                                                                                                        break block36;
                                                                                                    }
                                                                                                    if (actualType != Byte.class) break block41;
                                                                                                    ctx.statement().setByte(ctx.index(), (Byte)value);
                                                                                                    break block36;
                                                                                                }
                                                                                                if (actualType != byte[].class) break block42;
                                                                                                ctx.statement().setBytes(ctx.index(), (byte[])value);
                                                                                                break block36;
                                                                                            }
                                                                                            if (actualType != Clob.class) break block43;
                                                                                            ctx.statement().setClob(ctx.index(), (Clob)value);
                                                                                            break block36;
                                                                                        }
                                                                                        if (actualType != Double.class) break block44;
                                                                                        ctx.statement().setDouble(ctx.index(), (Double)value);
                                                                                        break block36;
                                                                                    }
                                                                                    if (actualType != Float.class) break block45;
                                                                                    ctx.statement().setFloat(ctx.index(), ((Float)value).floatValue());
                                                                                    break block36;
                                                                                }
                                                                                if (actualType != Integer.class) break block46;
                                                                                ctx.statement().setInt(ctx.index(), (Integer)value);
                                                                                break block36;
                                                                            }
                                                                            if (actualType != Long.class) break block47;
                                                                            ctx.statement().setLong(ctx.index(), (Long)value);
                                                                            break block36;
                                                                        }
                                                                        if (actualType != Short.class) break block48;
                                                                        ctx.statement().setShort(ctx.index(), (Short)value);
                                                                        break block36;
                                                                    }
                                                                    if (actualType != String.class) break block49;
                                                                    ctx.statement().setString(ctx.index(), (String)value);
                                                                    break block36;
                                                                }
                                                                if (!Tools.isDate(actualType)) break block50;
                                                                java.sql.Date date = DefaultBinding.getDate(actualType, value);
                                                                if (dialect == SQLDialect.SQLITE) {
                                                                    ctx.statement().setString(ctx.index(), date.toString());
                                                                } else {
                                                                    ctx.statement().setDate(ctx.index(), date);
                                                                }
                                                                break block36;
                                                            }
                                                            if (!Tools.isTime(actualType)) break block51;
                                                            Time time = DefaultBinding.getTime(actualType, value);
                                                            if (dialect == SQLDialect.SQLITE) {
                                                                ctx.statement().setString(ctx.index(), time.toString());
                                                            } else {
                                                                ctx.statement().setTime(ctx.index(), time);
                                                            }
                                                            break block36;
                                                        }
                                                        if (!Tools.isTimestamp(actualType)) break block52;
                                                        Timestamp timestamp = DefaultBinding.getTimestamp(actualType, value);
                                                        if (dialect == SQLDialect.SQLITE) {
                                                            ctx.statement().setString(ctx.index(), timestamp.toString());
                                                        } else {
                                                            ctx.statement().setTimestamp(ctx.index(), timestamp);
                                                        }
                                                        break block36;
                                                    }
                                                    if (actualType != OffsetTime.class) break block53;
                                                    String string = DefaultBinding.format((OffsetTime)value);
                                                    ctx.statement().setString(ctx.index(), string);
                                                    break block36;
                                                }
                                                if (actualType != OffsetDateTime.class) break block54;
                                                ctx.statement().setString(ctx.index(), DefaultBinding.format((OffsetDateTime)value));
                                                break block36;
                                            }
                                            if (actualType != YearToMonth.class) break block55;
                                            if (dialect.family() == SQLDialect.POSTGRES) {
                                                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval((YearToMonth)value));
                                            } else {
                                                ctx.statement().setString(ctx.index(), value.toString());
                                            }
                                            break block36;
                                        }
                                        if (actualType != DayToSecond.class) break block56;
                                        if (dialect.family() == SQLDialect.POSTGRES) {
                                            ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval((DayToSecond)value));
                                        } else {
                                            ctx.statement().setString(ctx.index(), value.toString());
                                        }
                                        break block36;
                                    }
                                    if (actualType != UByte.class) break block57;
                                    ctx.statement().setShort(ctx.index(), ((UByte)value).shortValue());
                                    break block36;
                                }
                                if (actualType != UShort.class) break block58;
                                ctx.statement().setInt(ctx.index(), ((UShort)value).intValue());
                                break block36;
                            }
                            if (actualType != UInteger.class) break block59;
                            ctx.statement().setLong(ctx.index(), ((UInteger)value).longValue());
                            break block36;
                        }
                        if (actualType != ULong.class) break block60;
                        ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value.toString()));
                        break block36;
                    }
                    if (actualType != UUID.class) break block61;
                    switch (dialect.family()) {
                        case H2: 
                        case POSTGRES: {
                            ctx.statement().setObject(ctx.index(), value);
                            break;
                        }
                        default: {
                            ctx.statement().setString(ctx.index(), value.toString());
                            break;
                        }
                    }
                    break block36;
                }
                if (!actualType.isArray()) break block62;
                switch (dialect.family()) {
                    case POSTGRES: {
                        ctx.statement().setString(ctx.index(), PostgresUtils.toPGArrayString((Object[])value));
                        break block36;
                    }
                    case HSQLDB: {
                        Object[] a = (Object[])value;
                        Class<Object> t = actualType;
                        if (actualType == UUID[].class) {
                            a = Convert.convertArray(a, byte[][].class);
                            t = byte[][].class;
                        }
                        ctx.statement().setArray(ctx.index(), new MockArray<Object>(dialect, a, t));
                        break block36;
                    }
                    case H2: {
                        ctx.statement().setObject(ctx.index(), value);
                        break block36;
                    }
                    default: {
                        throw new SQLDialectNotSupportedException("Cannot bind ARRAY types in dialect " + (Object)((Object)dialect));
                    }
                }
            }
            if (EnumType.class.isAssignableFrom(actualType)) {
                ctx.statement().setString(ctx.index(), ((EnumType)value).getLiteral());
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        block21: {
            T value;
            block36: {
                block37: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block27: {
                                                    block28: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block20: {
                                                                                Configuration configuration = ctx.configuration();
                                                                                value = this.converter.to(ctx.value());
                                                                                if (value != null) break block20;
                                                                                ctx.output().writeObject(null);
                                                                                break block21;
                                                                            }
                                                                            if (this.type != Blob.class) break block22;
                                                                            ctx.output().writeBlob((Blob)value);
                                                                            break block21;
                                                                        }
                                                                        if (this.type != Boolean.class) break block23;
                                                                        ctx.output().writeBoolean((Boolean)value);
                                                                        break block21;
                                                                    }
                                                                    if (this.type != BigInteger.class) break block24;
                                                                    ctx.output().writeBigDecimal(new BigDecimal((BigInteger)value));
                                                                    break block21;
                                                                }
                                                                if (this.type != BigDecimal.class) break block25;
                                                                ctx.output().writeBigDecimal((BigDecimal)value);
                                                                break block21;
                                                            }
                                                            if (this.type != Byte.class) break block26;
                                                            ctx.output().writeByte((Byte)value);
                                                            break block21;
                                                        }
                                                        if (this.type != byte[].class) break block27;
                                                        if (!this.isLob) break block28;
                                                        Blob blob = null;
                                                        try {
                                                            blob = (Blob)Reflect.on("oracle.sql.BLOB").call("createTemporary", Reflect.on(ctx.output()).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.BLOB").get("DURATION_SESSION")).get();
                                                            blob.setBytes(1L, (byte[])value);
                                                            ctx.output().writeBlob(blob);
                                                        }
                                                        catch (Throwable throwable) {
                                                            DefaultExecuteContext.register(blob);
                                                            throw throwable;
                                                        }
                                                        DefaultExecuteContext.register(blob);
                                                        break block21;
                                                    }
                                                    ctx.output().writeBytes((byte[])value);
                                                    break block21;
                                                }
                                                if (this.type != Clob.class) break block29;
                                                ctx.output().writeClob((Clob)value);
                                                break block21;
                                            }
                                            if (!Tools.isDate(this.type)) break block30;
                                            java.sql.Date date = DefaultBinding.getDate(this.type, value);
                                            ctx.output().writeDate(date);
                                            break block21;
                                        }
                                        if (this.type != Double.class) break block31;
                                        ctx.output().writeDouble((Double)value);
                                        break block21;
                                    }
                                    if (this.type != Float.class) break block32;
                                    ctx.output().writeFloat(((Float)value).floatValue());
                                    break block21;
                                }
                                if (this.type != Integer.class) break block33;
                                ctx.output().writeInt((Integer)value);
                                break block21;
                            }
                            if (this.type != Long.class) break block34;
                            ctx.output().writeLong((Long)value);
                            break block21;
                        }
                        if (this.type != Short.class) break block35;
                        ctx.output().writeShort((Short)value);
                        break block21;
                    }
                    if (this.type != String.class) break block36;
                    if (!this.isLob) break block37;
                    Clob clob = null;
                    try {
                        clob = (Clob)Reflect.on("oracle.sql.CLOB").call("createTemporary", Reflect.on(ctx.output()).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.CLOB").get("DURATION_SESSION")).get();
                        clob.setString(1L, (String)value);
                        ctx.output().writeClob(clob);
                    }
                    catch (Throwable throwable) {
                        DefaultExecuteContext.register(clob);
                        throw throwable;
                    }
                    DefaultExecuteContext.register(clob);
                    break block21;
                }
                ctx.output().writeString((String)value);
                break block21;
            }
            if (Tools.isTime(this.type)) {
                ctx.output().writeTime(DefaultBinding.getTime(this.type, value));
            } else if (Tools.isTimestamp(this.type)) {
                ctx.output().writeTimestamp(DefaultBinding.getTimestamp(this.type, value));
            } else if (this.type == YearToMonth.class) {
                ctx.output().writeString(value.toString());
            } else if (this.type == DayToSecond.class) {
                ctx.output().writeString(value.toString());
            } else if (UNumber.class.isAssignableFrom(this.type)) {
                ctx.output().writeString(value.toString());
            } else if (this.type == UUID.class) {
                ctx.output().writeString(value.toString());
            } else if (EnumType.class.isAssignableFrom(this.type)) {
                ctx.output().writeString(((EnumType)value).getLiteral());
            } else if (UDTRecord.class.isAssignableFrom(this.type)) {
                ctx.output().writeObject((UDTRecord)value);
            } else {
                throw new UnsupportedOperationException("Type " + this.type + " is not supported");
            }
        }
    }

    @Override
    public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.resultSet().getBlob(ctx.index());
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), (Boolean)ctx.resultSet().getBoolean(ctx.index()));
        } else if (this.type == BigInteger.class) {
            BigDecimal b;
            result = ctx.configuration().dialect() == SQLDialect.SQLITE ? Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigInteger.class) : ((b = ctx.resultSet().getBigDecimal(ctx.index())) == null ? null : b.toBigInteger());
        } else if (this.type == BigDecimal.class) {
            result = ctx.configuration().dialect() == SQLDialect.SQLITE ? Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigDecimal.class) : ctx.resultSet().getBigDecimal(ctx.index());
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Byte.valueOf(ctx.resultSet().getByte(ctx.index())));
        } else if (this.type == byte[].class) {
            result = ctx.resultSet().getBytes(ctx.index());
        } else if (this.type == Clob.class) {
            result = ctx.resultSet().getClob(ctx.index());
        } else if (this.type == java.sql.Date.class) {
            result = DefaultBinding.getDate(ctx.family(), ctx.resultSet(), ctx.index());
        } else if (this.type == Double.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Double.valueOf(ctx.resultSet().getDouble(ctx.index())));
        } else if (this.type == Float.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Float.valueOf(ctx.resultSet().getFloat(ctx.index())));
        } else if (this.type == Integer.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Integer.valueOf(ctx.resultSet().getInt(ctx.index())));
        } else if (this.type == LocalDate.class) {
            result = DefaultBinding.localDate(DefaultBinding.getDate(ctx.family(), ctx.resultSet(), ctx.index()));
        } else if (this.type == LocalTime.class) {
            result = DefaultBinding.localTime(DefaultBinding.getTime(ctx.family(), ctx.resultSet(), ctx.index()));
        } else if (this.type == LocalDateTime.class) {
            result = DefaultBinding.localDateTime(DefaultBinding.getTimestamp(ctx.family(), ctx.resultSet(), ctx.index()));
        } else if (this.type == Long.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Long.valueOf(ctx.resultSet().getLong(ctx.index())));
        } else if (this.type == OffsetTime.class) {
            result = DefaultBinding.offsetTime(ctx.resultSet().getString(ctx.index()));
        } else if (this.type == OffsetDateTime.class) {
            result = DefaultBinding.offsetDateTime(ctx.resultSet().getString(ctx.index()));
        } else if (this.type == Short.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Short.valueOf(ctx.resultSet().getShort(ctx.index())));
        } else if (this.type == String.class) {
            result = ctx.resultSet().getString(ctx.index());
        } else if (this.type == Time.class) {
            result = DefaultBinding.getTime(ctx.family(), ctx.resultSet(), ctx.index());
        } else if (this.type == Timestamp.class) {
            result = DefaultBinding.getTimestamp(ctx.family(), ctx.resultSet(), ctx.index());
        } else if (this.type == YearToMonth.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.resultSet().getObject(ctx.index())) == null ? null : PostgresUtils.toYearToMonth(object)) : ((string = ctx.resultSet().getString(ctx.index())) == null ? null : YearToMonth.valueOf(string));
        } else if (this.type == DayToSecond.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.resultSet().getObject(ctx.index())) == null ? null : PostgresUtils.toDayToSecond(object)) : ((string = ctx.resultSet().getString(ctx.index())) == null ? null : DayToSecond.valueOf(string));
        } else if (this.type == UByte.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UByte.class);
        } else if (this.type == UShort.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UShort.class);
        } else if (this.type == UInteger.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UInteger.class);
        } else if (this.type == ULong.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), ULong.class);
        } else if (this.type == UUID.class) {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    result = ctx.resultSet().getObject(ctx.index());
                    break;
                }
                default: {
                    result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UUID.class);
                    break;
                }
            }
        } else if (this.type.isArray()) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgGetArray(ctx, ctx.resultSet(), this.type, ctx.index());
                    break;
                }
                default: {
                    result = DefaultBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.type);
                    break;
                }
            }
        } else if (EnumType.class.isAssignableFrom(this.type)) {
            result = DefaultBinding.getEnumType(this.type, ctx.resultSet().getString(ctx.index()));
        } else if (Record.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgNewRecord(this.type, null, ctx.resultSet().getObject(ctx.index()));
                    break;
                }
                default: {
                    result = ctx.resultSet().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
                    break;
                }
            }
        } else if (Result.class.isAssignableFrom(this.type)) {
            ResultSet nested = (ResultSet)ctx.resultSet().getObject(ctx.index());
            result = DSL.using(ctx.configuration()).fetch(nested);
        } else {
            result = DefaultBinding.unlob(ctx.resultSet().getObject(ctx.index()));
        }
        if (result instanceof Attachable && Tools.attachRecords(ctx.configuration())) {
            ((Attachable)result).attach(ctx.configuration());
        }
        ctx.value(this.converter.from((Blob)result));
    }

    private static final LocalDate localDate(java.sql.Date date) {
        return date == null ? null : date.toLocalDate();
    }

    private static final LocalTime localTime(Time time) {
        return time == null ? null : time.toLocalTime();
    }

    private static final LocalDateTime localDateTime(Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    private static final OffsetTime offsetTime(String string) {
        return string == null ? null : OffsetTime.parse(DefaultBinding.preparse(string, false));
    }

    private static final OffsetDateTime offsetDateTime(String string) {
        return string == null ? null : OffsetDateTime.parse(DefaultBinding.preparse(string, true));
    }

    private static final String preparse(String formatted, boolean includeDate) {
        Matcher m3 = LENIENT_OFFSET_PATTERN.matcher(formatted);
        if (m3.find()) {
            StringBuilder sb = new StringBuilder();
            String group1 = m3.group(1);
            if (includeDate && group1 != null) {
                sb.append(group1);
                sb.append('T');
            }
            sb.append(m3.group(2));
            if (m3.group(3) == null) {
                sb.append(":00");
            }
            if (m3.group(4) != null) {
                sb.append(m3.group(5));
                String group6 = m3.group(6);
                String group8 = m3.group(8);
                sb.append(group6 == null ? "0" : group6);
                sb.append(m3.group(7));
                sb.append(group8 == null ? ":00" : group8);
            } else {
                sb.append("+00:00");
            }
            return sb.toString();
        }
        return formatted;
    }

    private static final String replaceZ(String format) {
        return StringUtils.replace(format, "Z", "+00:00");
    }

    private static final String format(OffsetTime val) {
        return DefaultBinding.replaceZ(val.format(DateTimeFormatter.ISO_OFFSET_TIME));
    }

    private static final String format(OffsetDateTime val) {
        String format = DefaultBinding.formatISO(val);
        return DefaultBinding.replaceZ(format.substring(0, 10) + ' ' + format.substring(11));
    }

    private static final String formatISO(OffsetDateTime val) {
        return val.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.statement().getBlob(ctx.index());
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.statement(), (Boolean)ctx.statement().getBoolean(ctx.index()));
        } else if (this.type == BigInteger.class) {
            BigDecimal d = ctx.statement().getBigDecimal(ctx.index());
            result = d == null ? null : d.toBigInteger();
        } else if (this.type == BigDecimal.class) {
            result = ctx.statement().getBigDecimal(ctx.index());
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Byte.valueOf(ctx.statement().getByte(ctx.index())));
        } else if (this.type == byte[].class) {
            result = ctx.statement().getBytes(ctx.index());
        } else if (this.type == Clob.class) {
            result = ctx.statement().getClob(ctx.index());
        } else if (Tools.isDate(this.type)) {
            result = ctx.statement().getDate(ctx.index());
            if (result != null && this.type == LocalDate.class) {
                result = ((java.sql.Date)result).toLocalDate();
            }
        } else if (this.type == Double.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Double.valueOf(ctx.statement().getDouble(ctx.index())));
        } else if (this.type == Float.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Float.valueOf(ctx.statement().getFloat(ctx.index())));
        } else if (this.type == Integer.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Integer.valueOf(ctx.statement().getInt(ctx.index())));
        } else if (this.type == Long.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Long.valueOf(ctx.statement().getLong(ctx.index())));
        } else if (this.type == Short.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Short.valueOf(ctx.statement().getShort(ctx.index())));
        } else if (this.type == String.class) {
            result = ctx.statement().getString(ctx.index());
        } else if (Tools.isTime(this.type)) {
            result = ctx.statement().getTime(ctx.index());
            if (result != null && this.type == LocalTime.class) {
                result = ((Time)result).toLocalTime();
            }
        } else if (Tools.isTimestamp(this.type)) {
            result = ctx.statement().getTimestamp(ctx.index());
            if (result != null && this.type == LocalDateTime.class) {
                result = ((Timestamp)result).toLocalDateTime();
            }
        } else if (this.type == OffsetTime.class) {
            result = DefaultBinding.offsetTime(ctx.statement().getString(ctx.index()));
        } else if (this.type == OffsetDateTime.class) {
            result = DefaultBinding.offsetDateTime(ctx.statement().getString(ctx.index()));
        } else if (this.type == YearToMonth.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.statement().getObject(ctx.index())) == null ? null : PostgresUtils.toYearToMonth(object)) : ((string = ctx.statement().getString(ctx.index())) == null ? null : YearToMonth.valueOf(string));
        } else if (this.type == DayToSecond.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.statement().getObject(ctx.index())) == null ? null : PostgresUtils.toDayToSecond(object)) : ((string = ctx.statement().getString(ctx.index())) == null ? null : DayToSecond.valueOf(string));
        } else if (this.type == UByte.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UByte.valueOf(string);
        } else if (this.type == UShort.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UShort.valueOf(string);
        } else if (this.type == UInteger.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UInteger.valueOf(string);
        } else if (this.type == ULong.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : ULong.valueOf(string);
        } else if (this.type == UUID.class) {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    result = ctx.statement().getObject(ctx.index());
                    break;
                }
                default: {
                    result = Convert.convert((Object)ctx.statement().getString(ctx.index()), UUID.class);
                    break;
                }
            }
        } else if (this.type.isArray()) {
            result = DefaultBinding.convertArray(ctx.statement().getObject(ctx.index()), this.type);
        } else if (EnumType.class.isAssignableFrom(this.type)) {
            result = DefaultBinding.getEnumType(this.type, ctx.statement().getString(ctx.index()));
        } else if (Record.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgNewRecord(this.type, null, ctx.statement().getObject(ctx.index()));
                    break;
                }
                default: {
                    result = ctx.statement().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
                    break;
                }
            }
        } else if (Result.class.isAssignableFrom(this.type)) {
            ResultSet nested = (ResultSet)ctx.statement().getObject(ctx.index());
            result = DSL.using(ctx.configuration()).fetch(nested);
        } else {
            result = ctx.statement().getObject(ctx.index());
        }
        if (result instanceof Attachable && Tools.attachRecords(ctx.configuration())) {
            ((Attachable)result).attach(ctx.configuration());
        }
        ctx.value(this.converter.from((Blob)result));
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration) {
        return DefaultBinding.typeMap(type, configuration, new HashMap());
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration, Map<String, Class<?>> result) {
        try {
            if (UDTRecord.class.isAssignableFrom(type)) {
                Class<?> t = type;
                result.put(Tools.getMappedUDTName(configuration, t), t);
                UDTRecord r = (UDTRecord)t.newInstance();
                for (Field<?> field : r.getUDT().fields()) {
                    DefaultBinding.typeMap(field.getType(), configuration, result);
                }
            }
        }
        catch (Exception e) {
            throw new MappingException("Error while collecting type map", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.input().readBlob();
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.input(), (Boolean)ctx.input().readBoolean());
        } else if (this.type == BigInteger.class) {
            BigDecimal d = ctx.input().readBigDecimal();
            result = d == null ? null : d.toBigInteger();
        } else if (this.type == BigDecimal.class) {
            result = ctx.input().readBigDecimal();
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.input(), Byte.valueOf(ctx.input().readByte()));
        } else if (this.type == byte[].class) {
            if (this.isLob) {
                Blob blob = null;
                try {
                    blob = ctx.input().readBlob();
                    result = blob == null ? null : blob.getBytes(1L, (int)blob.length());
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            } else {
                result = ctx.input().readBytes();
            }
        } else if (this.type == Clob.class) {
            result = ctx.input().readClob();
        } else if (Tools.isDate(this.type)) {
            result = ctx.input().readDate();
            if (result != null && this.type == LocalDate.class) {
                result = ((java.sql.Date)result).toLocalDate();
            }
        } else if (this.type == Double.class) {
            result = JDBCUtils.wasNull(ctx.input(), Double.valueOf(ctx.input().readDouble()));
        } else if (this.type == Float.class) {
            result = JDBCUtils.wasNull(ctx.input(), Float.valueOf(ctx.input().readFloat()));
        } else if (this.type == Integer.class) {
            result = JDBCUtils.wasNull(ctx.input(), Integer.valueOf(ctx.input().readInt()));
        } else if (this.type == Long.class) {
            result = JDBCUtils.wasNull(ctx.input(), Long.valueOf(ctx.input().readLong()));
        } else if (this.type == Short.class) {
            result = JDBCUtils.wasNull(ctx.input(), Short.valueOf(ctx.input().readShort()));
        } else if (this.type == String.class) {
            result = ctx.input().readString();
        } else if (Tools.isTime(this.type)) {
            result = ctx.input().readTime();
            if (result != null && this.type == LocalTime.class) {
                result = ((Time)result).toLocalTime();
            }
        } else if (Tools.isTimestamp(this.type)) {
            result = ctx.input().readTimestamp();
            if (result != null && this.type == LocalDateTime.class) {
                result = ((Timestamp)result).toLocalDateTime();
            }
        } else {
            java.sql.Array array;
            String string;
            result = this.type == YearToMonth.class ? ((string = ctx.input().readString()) == null ? null : YearToMonth.valueOf(string)) : (this.type == DayToSecond.class ? ((string = ctx.input().readString()) == null ? null : DayToSecond.valueOf(string)) : (this.type == UByte.class ? ((string = ctx.input().readString()) == null ? null : UByte.valueOf(string)) : (this.type == UShort.class ? ((string = ctx.input().readString()) == null ? null : UShort.valueOf(string)) : (this.type == UInteger.class ? ((string = ctx.input().readString()) == null ? null : UInteger.valueOf(string)) : (this.type == ULong.class ? ((string = ctx.input().readString()) == null ? null : ULong.valueOf(string)) : (this.type == UUID.class ? Convert.convert((Object)ctx.input().readString(), UUID.class) : (this.type.isArray() ? ((array = ctx.input().readArray()) == null ? null : array.getArray()) : (EnumType.class.isAssignableFrom(this.type) ? DefaultBinding.getEnumType(this.type, ctx.input().readString()) : (UDTRecord.class.isAssignableFrom(this.type) ? ctx.input().readObject() : DefaultBinding.unlob(ctx.input().readObject()))))))))));
        }
        ctx.value(this.converter.from((Blob)result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object unlob(Object object) throws SQLException {
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        }
        return object;
    }

    private static final <E extends EnumType> E getEnumType(Class<? extends E> type, String literal) {
        try {
            EnumType[] list;
            for (EnumType e : list = Tools.enums(type)) {
                if (!e.getLiteral().equals(literal)) continue;
                return (E)e;
            }
        }
        catch (Exception e) {
            throw new DataTypeException("Unknown enum literal found : " + literal);
        }
        return null;
    }

    private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
        if (array instanceof Object[]) {
            return Convert.convert(array, type);
        }
        if (array instanceof java.sql.Array) {
            return DefaultBinding.convertArray((java.sql.Array)array, type);
        }
        return null;
    }

    private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
        if (array != null) {
            return Convert.convert(array.getArray(), type);
        }
        return null;
    }

    private static final java.sql.Date getDate(SQLDialect family, ResultSet rs, int index) throws SQLException {
        if (family == SQLDialect.SQLITE) {
            String date = rs.getString(index);
            return date == null ? null : new java.sql.Date(DefaultBinding.parse(java.sql.Date.class, date));
        }
        return rs.getDate(index);
    }

    private static final Time getTime(SQLDialect family, ResultSet rs, int index) throws SQLException {
        if (family == SQLDialect.SQLITE) {
            String time = rs.getString(index);
            return time == null ? null : new Time(DefaultBinding.parse(Time.class, time));
        }
        return rs.getTime(index);
    }

    private static final Timestamp getTimestamp(SQLDialect family, ResultSet rs, int index) throws SQLException {
        if (family == SQLDialect.SQLITE) {
            String timestamp = rs.getString(index);
            return timestamp == null ? null : new Timestamp(DefaultBinding.parse(Timestamp.class, timestamp));
        }
        return rs.getTimestamp(index);
    }

    private static final long parse(Class<? extends Date> type, String date) throws SQLException {
        try {
            return Long.valueOf(date);
        }
        catch (NumberFormatException e) {
            if (type == Timestamp.class) {
                return Timestamp.valueOf(date).getTime();
            }
            if (type == java.sql.Date.class) {
                return java.sql.Date.valueOf(date.split(" ")[0]).getTime();
            }
            if (type == Time.class) {
                return Time.valueOf(date).getTime();
            }
            throw new SQLException("Could not parse date " + date, e);
        }
    }

    private static final <T> T pgFromString(Class<T> type, String string) {
        return DefaultBinding.pgFromString(Converters.identity(type), string);
    }

    private static final <T> T pgFromString(Converter<?, T> converter, String string) {
        Class<T> type = converter.toType();
        if (string == null) {
            return null;
        }
        if (type != Blob.class) {
            if (type == Boolean.class) {
                return (T)Convert.convert((Object)string, Boolean.class);
            }
            if (type == BigInteger.class) {
                return (T)new BigInteger(string);
            }
            if (type == BigDecimal.class) {
                return (T)new BigDecimal(string);
            }
            if (type == Byte.class) {
                return (T)Byte.valueOf(string);
            }
            if (type == byte[].class) {
                return (T)PostgresUtils.toBytes(string);
            }
            if (type != Clob.class) {
                if (type == java.sql.Date.class) {
                    return (T)java.sql.Date.valueOf(string);
                }
                if (type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Float.class) {
                    return (T)Float.valueOf(string);
                }
                if (type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == String.class) {
                    return (T)string;
                }
                if (type == Time.class) {
                    return (T)Time.valueOf(string);
                }
                if (type == Timestamp.class) {
                    return (T)Timestamp.valueOf(string);
                }
                if (type == LocalTime.class) {
                    return (T)LocalTime.parse(string);
                }
                if (type == LocalDate.class) {
                    return (T)LocalDate.parse(string);
                }
                if (type == LocalDateTime.class) {
                    return (T)LocalDateTime.parse(string);
                }
                if (type == OffsetTime.class) {
                    return (T)DefaultBinding.offsetTime(string);
                }
                if (type == OffsetDateTime.class) {
                    return (T)DefaultBinding.offsetDateTime(string);
                }
                if (type == UByte.class) {
                    return (T)UByte.valueOf(string);
                }
                if (type == UShort.class) {
                    return (T)UShort.valueOf(string);
                }
                if (type == UInteger.class) {
                    return (T)UInteger.valueOf(string);
                }
                if (type == ULong.class) {
                    return (T)ULong.valueOf(string);
                }
                if (type == UUID.class) {
                    return (T)UUID.fromString(string);
                }
                if (type.isArray()) {
                    return (T)DefaultBinding.pgNewArray(type, string);
                }
                if (EnumType.class.isAssignableFrom(type)) {
                    return DefaultBinding.getEnumType(type, string);
                }
                if (Record.class.isAssignableFrom(type)) {
                    return (T)DefaultBinding.pgNewRecord(type, null, string);
                }
                if (type == Object.class) {
                    return (T)string;
                }
                if (type != converter.fromType()) {
                    Converter<?, ?> c = converter;
                    return c.from(DefaultBinding.pgFromString(c.fromType(), string));
                }
            }
        }
        throw new UnsupportedOperationException("Class " + type + " is not supported");
    }

    static final Record pgNewRecord(Class<?> type, Field<?>[] fields, Object object) {
        if (object == null) {
            return null;
        }
        final List<String> values = PostgresUtils.toPGObject(object.toString());
        if (fields == null && type == Record.class) {
            fields = Tools.fields(values.size(), SQLDataType.VARCHAR);
        }
        return Tools.newRecord(true, type, fields).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) {
                Row row = record.fieldsRow();
                for (int i = 0; i < row.size(); ++i) {
                    DefaultBinding.pgSetValue(record, row.field(i), (String)values.get(i));
                }
                return record;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T pgGetArray(Scope ctx, ResultSet rs, Class<T> type, int index) throws SQLException {
        java.sql.Array array = null;
        try {
            array = rs.getArray(index);
            if (array == null) {
                T t = null;
                return t;
            }
            if (byte[][].class == type) {
                throw new ControlFlowSignal("GOTO the next array deserialisation strategy");
            }
            Object[] objectArray = DefaultBinding.convertArray(array, type);
            return (T)objectArray;
        }
        finally {
            JDBCUtils.safeFree(array);
        }
    }

    private static final Object[] pgNewArray(Class<?> type, String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> component = type.getComponentType();
            List<String> values = PostgresUtils.toPGArray(string);
            if (values.isEmpty()) {
                return (Object[])Array.newInstance(component, 0);
            }
            Object[] result = (Object[])Array.newInstance(component, values.size());
            for (int i = 0; i < values.size(); ++i) {
                result[i] = DefaultBinding.pgFromString(type.getComponentType(), values.get(i));
            }
            return result;
        }
        catch (Exception e) {
            throw new DataTypeException("Error while creating array", e);
        }
    }

    static final <T> void pgSetValue(Record record, Field<T> field, String value) {
        record.set(field, DefaultBinding.pgFromString(field.getConverter(), value));
    }

    private static final void pgRenderEnumCast(RenderContext render, Class<?> type) {
        Class<?> enumType = type.isArray() ? type.getComponentType() : type;
        EnumType[] enums = Tools.enums(enumType);
        if (enums == null || enums.length == 0) {
            throw new IllegalArgumentException("Not a valid EnumType : " + type);
        }
        Schema schema = enums[0].getSchema();
        if (schema != null) {
            render.sql("::");
            schema = DSL.using(render.configuration()).map(schema);
            if (schema != null && Boolean.TRUE.equals(render.configuration().settings().isRenderSchema())) {
                render.visit(schema);
                render.sql('.');
            }
            render.visit(DSL.name(enums[0].getName()));
        }
        if (type.isArray()) {
            render.sql("[]");
        }
    }

    public String toString() {
        return "DefaultBinding [type=" + this.type + ", converter=" + this.converter + "]";
    }
}

