/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world.generation;

import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.world.generation.WSBlockVolume;
import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public class SpigotBlockVolume
implements WSBlockVolume {
    private ChunkGenerator.ChunkData data;
    private int x;
    private int z;
    private Random random;
    private ChunkGenerator.BiomeGrid biome;

    public SpigotBlockVolume(ChunkGenerator.ChunkData data, int x, int z, Random random, ChunkGenerator.BiomeGrid biome) {
        this.data = data;
        this.x = x;
        this.z = z;
        this.random = random;
        this.biome = biome;
    }

    @Override
    public Vector3i getBlockMin() {
        return new Vector3i(this.x * 16, 0, this.z * 16);
    }

    @Override
    public Vector3i getBlockMax() {
        return new Vector3i(this.x * 16 + 15, this.data.getMaxHeight(), this.z * 16 + 15);
    }

    @Override
    public Vector3i getBlockSize() {
        return this.getBlockMax().sub(this.getBlockMin()).add(1, 1, 1);
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return this.data.getType(x, y, z) == Material.AIR;
    }

    @Override
    public WSBlockType getBlock(int x, int y, int z) {
        MaterialData materialData = this.data.getTypeAndData(x % 16, y, z % 16);
        return ((SpigotBlockType)WSBlockTypes.getById(materialData.getItemTypeId()).orElse(WSBlockTypes.AIR.getDefaultState())).readMaterialData(materialData);
    }

    @Override
    public boolean setBlock(int x, int y, int z, WSBlockType blockType) {
        this.data.setBlock(x % 16, y, z % 16, ((SpigotBlockType)blockType).toMaterialData());
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Random getRandom() {
        return this.random;
    }

    public ChunkGenerator.BiomeGrid getBiome() {
        return this.biome;
    }

    public ChunkGenerator.ChunkData getHandled() {
        return this.data;
    }
}

