/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world.edit;

import com.degoos.wetsponge.SpongeWetSponge;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinChunk;
import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinChunkProviderServer;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.parser.packet.SpongePacketParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.world.WSWorld;
import com.degoos.wetsponge.world.edit.WSWorldQueue;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.scheduler.Task;

public class SpongeWorldQueue
implements WSWorldQueue {
    private Map<Vector2i, Map<Vector3i, WSBlockType>> types;
    private WSWorld world;

    public SpongeWorldQueue(WSWorld world) {
        this.world = world;
        this.types = new HashMap<Vector2i, Map<Vector3i, WSBlockType>>();
    }

    @Override
    public void setBlock(Vector3i position, WSBlockType blockType) {
        if (position.getY() < 0 || position.getY() > this.world.getProperties().getMaxHeight()) {
            return;
        }
        Vector2i chunk = new Vector2i(position.getX() >> 4, position.getZ() >> 4);
        Map<Vector3i, WSBlockType> chunkMap = this.types.get(chunk);
        if (chunkMap == null) {
            chunkMap = new HashMap<Vector3i, WSBlockType>();
        }
        chunkMap.put(position, blockType);
        this.types.put(chunk, chunkMap);
    }

    @Override
    public void flush(boolean sendPacket, boolean async) {
        if (Thread.currentThread() != WetSponge.getMainThread()) {
            Task.builder().execute(() -> this.flush(sendPacket, async)).submit((Object)SpongeWetSponge.getInstance());
            return;
        }
        try {
            HashMap chunks = new HashMap();
            this.types.keySet().forEach(vector -> chunks.put(vector, ((WSMixinChunkProviderServer)this.world.getChunkProvider()).vanillaProvideChunk(vector.getX(), vector.getY())));
            chunks.values().forEach(chunk -> ((WSMixinChunk)chunk).setCanBeUnloaded(false));
            Thread thread = new Thread(() -> {
                if (sendPacket) {
                    Set<WSPlayer> players = this.world.getPlayers();
                    this.types.forEach((vector2i, blocks) -> {
                        try {
                            Chunk chunk = (Chunk)chunks.get(vector2i);
                            blocks.forEach((vector3i, blockType) -> {
                                chunk.func_177436_a(new BlockPos(vector3i.getX(), vector3i.getY(), vector3i.getZ()), SpongePacketParser.getBlockState(blockType));
                                WSSPacketBlockChange packet = WSSPacketBlockChange.of(blockType, vector3i);
                                players.forEach(player -> player.sendPacket(packet));
                            });
                            ((WSMixinChunk)chunk).setCanBeUnloaded(true);
                        }
                        catch (Exception ex) {
                            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                        }
                    });
                    return;
                }
                this.types.forEach((vector2i, blocks) -> {
                    try {
                        Chunk chunk = (Chunk)chunks.get(vector2i);
                        if (!chunk.func_177410_o()) {
                            chunk.func_76631_c();
                        }
                        blocks.forEach((vector3i, blockType) -> chunk.func_177436_a(new BlockPos(vector3i.getX(), vector3i.getY(), vector3i.getZ()), SpongePacketParser.getBlockState(blockType)));
                        ((WSMixinChunk)chunk).setCanBeUnloaded(true);
                    }
                    catch (Exception ex) {
                        InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                    }
                });
            });
            if (async) {
                thread.start();
            } else {
                thread.run();
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
        }
    }
}

