/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world.edit;

import com.degoos.wetsponge.world.edit.WSRegionFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractRegionFormat
implements WSRegionFormat {
    private String name;
    private int compressionLevel;
    private Set<String> aliases;

    public AbstractRegionFormat(String name, int compressionLevel, String ... aliases) {
        this.name = name;
        this.aliases = new HashSet<String>(Arrays.asList(aliases));
        if (compressionLevel > 9) {
            this.compressionLevel = 9;
        }
        this.compressionLevel = compressionLevel < 0 ? 0 : compressionLevel;
    }

    public AbstractRegionFormat(String name, String ... aliases) {
        this(name, 9, aliases);
    }

    @Override
    public InputStream getReader(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(inputStream));
    }

    @Override
    public OutputStream getWriter(OutputStream outputStream) throws IOException {
        return new BufferedOutputStream(new GZIPOutputStream(outputStream, this.compressionLevel));
    }

    @Override
    public boolean isFormat(File file) {
        return file.getName().endsWith("." + this.name) || this.aliases.stream().anyMatch(ext -> file.getName().endsWith("." + ext));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAliases() {
        return this.aliases;
    }
}

