/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.map.WSMapView;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinChunk;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.parser.packet.SpongePacketParser;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.resource.WSObjectCollection;
import com.degoos.wetsponge.resource.WSObjectIterator;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.world.SpongeChunk;
import com.degoos.wetsponge.world.SpongeExplosion;
import com.degoos.wetsponge.world.SpongeWorldBorder;
import com.degoos.wetsponge.world.SpongeWorldProperties;
import com.degoos.wetsponge.world.WSChunk;
import com.degoos.wetsponge.world.WSChunkLoaderSavable;
import com.degoos.wetsponge.world.WSExplosion;
import com.degoos.wetsponge.world.WSWorld;
import com.degoos.wetsponge.world.WSWorldBorder;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.degoos.wetsponge.world.generation.SpongeWorldGenerator;
import com.degoos.wetsponge.world.generation.WSWorldGenerator;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.Human;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;

public class SpongeWorld
implements WSWorld {
    private World world;
    private WSWorldProperties worldProperties;
    private WSWorldGenerator worldGenerator;
    private WSChunkLoaderSavable chunkLoader;
    private ChunkProviderServer chunkProvider;
    private Long2ObjectMap long2ObjectMap;
    private WSWorldBorder worldBorder;
    private Map<Integer, WSMapView> mapViews;

    public SpongeWorld(Object world) {
        this((World)world);
    }

    public SpongeWorld(World world) {
        Validate.notNull(world, "World cannot be null!");
        this.world = world;
        this.worldBorder = new SpongeWorldBorder(world.getWorldBorder());
        this.mapViews = new HashMap<Integer, WSMapView>();
        this.worldProperties = new SpongeWorldProperties(world.getProperties());
        this.worldGenerator = new SpongeWorldGenerator(world.getWorldGenerator());
        try {
            this.chunkProvider = (ChunkProviderServer)ReflectionUtils.getFirstObject(net.minecraft.world.World.class, IChunkProvider.class, world);
            this.chunkLoader = (WSChunkLoaderSavable)ReflectionUtils.getFirstObject(ChunkProviderServer.class, IChunkLoader.class, this.chunkProvider);
            Field chunkMapField = ReflectionUtils.getFirstField(this.chunkProvider.getClass(), Long2ObjectMap.class);
            ReflectionUtils.setAccessible(chunkMapField);
            this.long2ObjectMap = new Long2ObjectOpenHashMap<net.minecraft.world.chunk.Chunk>((Long2ObjectMap)chunkMapField.get(this.chunkProvider)){

                public net.minecraft.world.chunk.Chunk remove(long l) {
                    net.minecraft.world.chunk.Chunk chunk = (net.minecraft.world.chunk.Chunk)this.get(l);
                    if (chunk == null) {
                        return null;
                    }
                    if (((WSMixinChunk)chunk).isPreparedToCancelUnload()) {
                        ((WSMixinChunk)chunk).setPreparedToCancelUnload(false);
                        return null;
                    }
                    return (net.minecraft.world.chunk.Chunk)super.remove(l);
                }

                public ObjectCollection<net.minecraft.world.chunk.Chunk> values() {
                    return new WSObjectCollection<net.minecraft.world.chunk.Chunk>(super.values()){

                        @Override
                        public ObjectIterator<net.minecraft.world.chunk.Chunk> iterator() {
                            return new WSObjectIterator<net.minecraft.world.chunk.Chunk>(super.iterator()){

                                @Override
                                public void remove() {
                                    net.minecraft.world.chunk.Chunk current = (net.minecraft.world.chunk.Chunk)this.current();
                                    if (((WSMixinChunk)current).isPreparedToCancelUnload()) {
                                        ((WSMixinChunk)current).setPreparedToCancelUnload(false);
                                    } else {
                                        super.remove();
                                    }
                                }
                            };
                        }
                    };
                }
            };
            chunkMapField.set(this.chunkProvider, this.long2ObjectMap);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public Set<WSEntity> getEntities() {
        return this.world.getEntities().stream().map(SpongeEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public Set<WSPlayer> getPlayers() {
        return this.getHandled().getPlayers().stream().map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId())).collect(Collectors.toSet());
    }

    @Override
    public UUID getUniqueId() {
        return this.world.getUniqueId();
    }

    @Override
    public <T extends WSEntity> Optional<T> spawnEntity(Class<T> entityClass, Vector3d location) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            Optional<EnumEntityType> optional = EnumEntityType.getByClass(entityClass);
            if (!optional.isPresent()) {
                WetSponge.getTimings().stopTiming();
                return Optional.empty();
            }
            Optional<WSEntity> entity = this.spawnEntity(optional.get(), location);
            WetSponge.getTimings().stopTiming();
            return entity;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSEntity> spawnEntity(EnumEntityType type, Vector3d location) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            EntityType spongeType = SpongeEntityParser.getSuperEntityType(type);
            if (spongeType.equals(EntityTypes.UNKNOWN)) {
                WetSponge.getTimings().stopTiming();
                return Optional.empty();
            }
            Entity spongeEntity = this.world.createEntity(spongeType, location);
            if (!this.world.spawnEntity(spongeEntity)) {
                WetSponge.getTimings().stopTiming();
                return Optional.empty();
            }
            Optional<WSEntity> optional = Optional.ofNullable(SpongeEntityParser.getWSEntity(spongeEntity));
            WetSponge.getTimings().stopTiming();
            return optional;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public boolean spawnEntity(WSEntity entity) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            boolean b = this.world.spawnEntity(((SpongeEntity)entity).getHandled());
            WetSponge.getTimings().stopTiming();
            return b;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return false;
        }
    }

    @Override
    public <T extends WSEntity> Optional<T> createEntity(Class<T> entityClass, Vector3d location) {
        WetSponge.getTimings().startTiming("Parse entity type");
        try {
            Optional<EnumEntityType> optional = EnumEntityType.getByClass(entityClass);
            if (!optional.isPresent()) {
                WetSponge.getTimings().stopTiming();
                return Optional.empty();
            }
            WetSponge.getTimings().stopTiming();
            return this.createEntity(optional.get(), location);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSEntity> createEntity(EnumEntityType type, Vector3d location) {
        WetSponge.getTimings().startTiming("Create entity type");
        try {
            EntityType spongeType = SpongeEntityParser.getSuperEntityType(type);
            if (spongeType.equals(EntityTypes.UNKNOWN)) {
                WetSponge.getTimings().stopTiming();
                return Optional.empty();
            }
            Optional<WSEntity> entity = Optional.ofNullable(SpongeEntityParser.getWSEntity(this.world.createEntity(spongeType, location)));
            WetSponge.getTimings().stopTiming();
            return entity;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSHuman> createNPC(WSGameProfile gameProfile, Vector3d vector3d) {
        WetSponge.getTimings().startTiming("Create NPC");
        try {
            Human player = (Human)new EntityPlayer((net.minecraft.world.World)this.world, (GameProfile)gameProfile.getHandled()){

                public boolean func_175149_v() {
                    return false;
                }

                public boolean func_184812_l_() {
                    return false;
                }
            };
            WSEntity entity = SpongeEntityParser.getWSEntity((Entity)player);
            if (!(entity instanceof WSHuman)) {
                return Optional.empty();
            }
            WetSponge.getTimings().stopTiming();
            return Optional.ofNullable((WSHuman)entity);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a NPC!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public WSWorldProperties getProperties() {
        return this.worldProperties;
    }

    @Override
    public WSWorldGenerator getGenerator() {
        return this.worldGenerator;
    }

    @Override
    public Optional<WSChunk> getChunk(int x, int z) {
        return this.world.getChunk(x, 0, z).map(SpongeChunk::new);
    }

    @Override
    public Optional<WSChunk> getChunkAtLocation(int x, int z) {
        return this.world.getChunkAtBlock(x, 0, z).map(SpongeChunk::new);
    }

    @Override
    public Optional<WSChunk> loadChunk(int x, int z, boolean generate) {
        try {
            WetSponge.getTimings().startTiming("Load chunk");
            Optional<WSChunk> chunk = this.world.loadChunk(x, 0, z, generate).map(SpongeChunk::new);
            WetSponge.getTimings().stopTiming();
            return chunk;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was loading a chunk!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSChunk> loadChunkAtLocation(int x, int z, boolean shouldGenerate) {
        return this.loadChunk(x >> 4, z >> 4, shouldGenerate);
    }

    @Override
    public Set<WSChunk> getLoadedChunks() {
        HashSet<WSChunk> chunks = new HashSet<WSChunk>();
        this.world.getLoadedChunks().forEach(chunk -> chunks.add(new SpongeChunk((Chunk)chunk)));
        return chunks;
    }

    @Override
    public EnumBiomeType getBiome(int x, int y, int z) {
        return EnumBiomeType.getBySpongeName(this.world.getBiome(x, y, z).getName()).orElseThrow(NullPointerException::new);
    }

    @Override
    public void setBiome(int x, int y, int z, EnumBiomeType biome) {
        this.world.setBiome(x, y, z, (BiomeType)Sponge.getRegistry().getType(BiomeType.class, biome.getSpongeName()).orElseThrow(NullPointerException::new));
    }

    @Override
    public boolean isAutoSave() {
        return !((WorldServer)this.world).field_73058_d;
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        ((WorldServer)this.world).field_73058_d = !autoSave;
    }

    @Override
    public void save() {
        try {
            this.world.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flushUnloadedChunksQueue() {
        this.chunkProvider.func_73156_b();
    }

    @Override
    public void shutdownAllChunks() {
        this.long2ObjectMap.clear();
    }

    @Override
    public boolean canBeSaved() {
        return this.chunkLoader.canSaveChunks(this);
    }

    @Override
    public void setCanBeSaved(boolean canSave) {
        this.chunkLoader.setSaveChunks(canSave, this);
    }

    @Override
    public void saveAllChunks() {
        this.chunkLoader.saveAllChunks(this);
    }

    @Override
    public WSBlockType getBlockType(Vector3i position) {
        return this.getBlockType(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public WSBlockType getBlockType(int x, int y, int z) {
        return SpongePacketParser.getMaterial(((net.minecraft.world.World)this.world).func_72964_e(x >> 4, z >> 4).func_177435_g(new BlockPos(x, y, z)));
    }

    @Override
    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i pos1, Vector3i pos2) {
        return this.getBlockTypesInArea(pos1, pos2, false);
    }

    @Override
    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i pos1, Vector3i pos2, boolean getAir) {
        WetSponge.getTimings().startTiming("Get block types in area");
        Vector3i min2 = new Vector3i(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
        Vector3i max = new Vector3i(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
        Vector2i minChunk = new Vector2i(min2.getX() >> 4, min2.getZ() >> 4);
        Vector2i maxChunk = new Vector2i(max.getX() >> 4, max.getZ() >> 4);
        HashMap<Vector3i, WSBlockType> blockTypes = new HashMap<Vector3i, WSBlockType>();
        try {
            net.minecraft.world.World nmsWorld = (net.minecraft.world.World)this.world;
            for (int cx = minChunk.getX(); cx <= maxChunk.getX(); ++cx) {
                for (int cz = minChunk.getY(); cz <= maxChunk.getY(); ++cz) {
                    net.minecraft.world.chunk.Chunk chunk = this.chunkLoader.loadVanillaChunk(nmsWorld, cx, cz);
                    if (chunk == null) continue;
                    int minX = 0;
                    int minZ = 0;
                    int maxX = 15;
                    int maxZ = 15;
                    if (cx == minChunk.getX()) {
                        minX = min2.getX() - (cx << 4);
                    }
                    if (cz == minChunk.getY()) {
                        minZ = min2.getZ() - (cz << 4);
                    }
                    if (cx == maxChunk.getX()) {
                        maxX = max.getX() - (cx << 4);
                    }
                    if (cz == maxChunk.getY()) {
                        maxZ = max.getZ() - (cz << 4);
                    }
                    for (int x = minX; x <= maxX; ++x) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            for (int y = min2.getY(); y <= max.getY(); ++y) {
                                int fx = (cx << 4) + x;
                                int fz = (cz << 4) + z;
                                WSBlockType blockType = SpongePacketParser.getMaterial(chunk.func_186032_a(fx, y, fz));
                                if (!getAir && blockType.getNumericalId() == 0) continue;
                                blockTypes.put(new Vector3i(fx, y, fz), blockType);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the block types of an area!");
        }
        WetSponge.getTimings().stopTiming();
        return blockTypes;
    }

    @Override
    public Map<Vector2i, EnumMapBaseColor> getMapColors(Vector3i pos1, Vector3i pos2) {
        WetSponge.getTimings().startTiming("Get map colors");
        Vector3i min2 = new Vector3i(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
        Vector3i max = new Vector3i(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
        Vector2i minChunk = new Vector2i(min2.getX() >> 4, min2.getZ() >> 4);
        Vector2i maxChunk = new Vector2i(max.getX() >> 4, max.getZ() >> 4);
        HashMap<Vector2i, EnumMapBaseColor> colors = new HashMap<Vector2i, EnumMapBaseColor>();
        net.minecraft.world.World nmsWorld = (net.minecraft.world.World)this.world;
        try {
            for (int cx = minChunk.getX(); cx <= maxChunk.getX(); ++cx) {
                for (int cz = minChunk.getY(); cz <= maxChunk.getY(); ++cz) {
                    net.minecraft.world.chunk.Chunk chunk = this.chunkLoader.loadVanillaChunk(nmsWorld, cx, cz);
                    if (chunk == null) continue;
                    int minX = 0;
                    int minZ = 0;
                    int maxX = 15;
                    int maxZ = 15;
                    if (cx == minChunk.getX()) {
                        minX = min2.getX() - (cx << 4);
                    }
                    if (cz == minChunk.getY()) {
                        minZ = min2.getZ() - (cz << 4);
                    }
                    if (cx == maxChunk.getX()) {
                        maxX = max.getX() - (cx << 4);
                    }
                    if (cz == maxChunk.getY()) {
                        maxZ = max.getZ() - (cz << 4);
                    }
                    for (int x = minX; x <= maxX; ++x) {
                        block5: for (int z = minZ; z <= maxZ; ++z) {
                            for (int y = max.getY(); y >= min2.getY(); --y) {
                                int fx = (cx << 4) + x;
                                int fz = (cz << 4) + z;
                                IBlockState state = chunk.func_186032_a(fx, y, fz);
                                EnumMapBaseColor mapColor = EnumMapBaseColor.getById(state.func_185909_g((IBlockAccess)nmsWorld, (BlockPos)new BlockPos((int)fx, (int)y, (int)fz)).field_76290_q).orElse(EnumMapBaseColor.AIR);
                                if (mapColor.equals((Object)EnumMapBaseColor.AIR)) continue;
                                colors.put(new Vector2i(fx, fz), mapColor);
                                continue block5;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the block types of an area!");
        }
        WetSponge.getTimings().stopTiming();
        return colors;
    }

    @Override
    public void triggerExplosion(WSExplosion explosion) {
        this.world.triggerExplosion(((SpongeExplosion)explosion).getHandler());
    }

    @Override
    public WSWorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public Map<Integer, WSMapView> getMapViews() {
        return new HashMap<Integer, WSMapView>(this.mapViews);
    }

    @Override
    public Optional<WSMapView> getMapView(int mapId) {
        return Optional.ofNullable(this.mapViews.getOrDefault(mapId, null));
    }

    @Override
    public void putMapView(int mapId, WSMapView mapView) {
        Validate.notNull(mapView, "Map view cannot be null!");
        this.mapViews.put(mapId, mapView);
    }

    @Override
    public void removeMapView(int mapId) {
        this.mapViews.remove(mapId);
    }

    @Override
    public void clearMapViews() {
        this.mapViews.clear();
    }

    @Override
    public File getWorldFolder() {
        return ((net.minecraft.world.World)this.world).func_72860_G().func_75765_b();
    }

    public ChunkProviderServer getChunkProvider() {
        return this.chunkProvider;
    }

    public WSChunkLoaderSavable getChunkLoader() {
        return this.chunkLoader;
    }

    public World getHandled() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeWorld that = (SpongeWorld)o;
        return this.world != null ? this.world.equals(that.world) : that.world == null;
    }

    public int hashCode() {
        return this.world != null ? this.world.hashCode() : 0;
    }
}

