/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.block.SpongeBlock;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.listener.sponge.SpongeWorldListener;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.NumericUtils;
import com.degoos.wetsponge.world.SpongeWorld;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityTypes;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class SpongeLocation
implements WSLocation {
    public static Map<String, List<SpongeLocation>> locations = new HashMap<String, List<SpongeLocation>>();
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private Transform<World> spongeLocation;
    private World spongeWorld;

    public SpongeLocation(String worldName, double x, double y, double z, float yaw, float pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.spongeWorld = SpongeWorldListener.getWorld(worldName).orElse(null);
        this.putInMap();
    }

    public SpongeLocation(World world, double x, double y, double z, float yaw, float pitch) {
        this.worldName = world.getName();
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        this.putInMap();
    }

    public SpongeLocation(Location<World> location) {
        this.worldName = ((World)location.getExtent()).getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.spongeWorld = (World)location.getExtent();
        this.putInMap();
    }

    public SpongeLocation(Location<World> location, Vector3d rotation) {
        this.worldName = ((World)location.getExtent()).getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = (float)rotation.getY();
        this.pitch = (float)rotation.getX();
        this.spongeWorld = (World)location.getExtent();
        this.putInMap();
    }

    public SpongeLocation(Transform<World> transform) {
        this.worldName = ((World)transform.getExtent()).getName();
        this.x = transform.getLocation().getX();
        this.y = transform.getLocation().getY();
        this.z = transform.getLocation().getZ();
        this.yaw = (float)transform.getRotation().getY();
        this.pitch = (float)transform.getRotation().getX();
        this.spongeWorld = (World)transform.getExtent();
        this.putInMap();
    }

    public SpongeLocation(WSLocation location) {
        this.worldName = location.getWorldName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        this.putInMap();
    }

    public SpongeLocation(String string) {
        String[] sl = string.split(";");
        if (NumericUtils.isDouble(sl[0])) {
            this.worldName = sl[5];
            this.x = Double.parseDouble(sl[0]);
            this.y = Double.parseDouble(sl[1]);
            this.z = Double.parseDouble(sl[2]);
            this.pitch = Float.parseFloat(sl[3]);
            this.yaw = Float.parseFloat(sl[4]);
        } else {
            this.worldName = sl[0];
            this.x = Double.parseDouble(sl[1]);
            this.y = Double.parseDouble(sl[2]);
            this.z = Double.parseDouble(sl[3]);
            this.yaw = Float.parseFloat(sl[4]);
            this.pitch = Float.parseFloat(sl[5]);
        }
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        this.putInMap();
    }

    public SpongeLocation(Player player) {
        Location playerLocation = player.getLocation();
        this.worldName = ((World)playerLocation.getExtent()).getName();
        this.x = playerLocation.getX();
        this.y = playerLocation.getY();
        this.z = playerLocation.getZ();
        this.yaw = (float)player.getRotation().getX();
        this.pitch = (float)player.getRotation().getZ();
        this.spongeWorld = (World)playerLocation.getExtent();
        this.putInMap();
    }

    private void putInMap() {
        if (locations.containsKey(this.worldName)) {
            locations.get(this.worldName).add(this);
        } else {
            ArrayList<SpongeLocation> list = new ArrayList<SpongeLocation>();
            list.add(this);
            locations.put(this.worldName, list);
        }
        if (this.spongeWorld != null) {
            this.spongeLocation = new Transform((Extent)this.spongeWorld, new Vector3d(this.x, this.y, this.z), this.getRotation().toVector3().toDouble());
        }
    }

    @Override
    public String toString() {
        return this.worldName + ";" + this.x + ";" + this.y + ";" + this.z + ";" + this.yaw + ";" + this.pitch;
    }

    public Transform<World> getLocation() {
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        if (this.spongeWorld != null && this.spongeLocation == null) {
            this.spongeLocation = new Transform((Extent)this.spongeWorld, new Vector3d(this.x, this.y, this.z), new Vector3d(this.pitch, this.yaw, 0.0f));
        }
        if (this.spongeWorld == null) {
            InternalLogger.sendError("ERROR: world " + this.worldName + " doesn't exist!");
            Optional optional = Sponge.getServer().getWorlds().stream().findFirst();
            return optional.map(world -> new Transform((Extent)this.spongeWorld, new Vector3d(this.x, this.y, this.z), this.getRotation().toVector3().toDouble())).orElse(null);
        }
        return this.spongeLocation;
    }

    @Override
    public SpongeBlock getBlock() {
        if (this.spongeWorld != null && this.spongeLocation == null) {
            this.spongeLocation = new Transform((Extent)this.spongeWorld, new Vector3d(this.x, this.y, this.z), new Vector3d(this.pitch, this.yaw, 0.0f));
        }
        if (this.spongeLocation == null) {
            return null;
        }
        return new SpongeBlock((Location<World>)this.spongeLocation.getLocation());
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public SpongeLocation setWorldName(String worldName) {
        locations.get(this.worldName).remove(this);
        this.worldName = worldName;
        this.spongeWorld = SpongeWorldListener.getWorld(worldName).orElse(null);
        this.putInMap();
        return this;
    }

    @Override
    public SpongeWorld getWorld() {
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        return (SpongeWorld)WorldParser.getOrCreateWorld(this.spongeWorld.getName(), this.spongeWorld);
    }

    @Override
    public WSLocation setWorld(WSWorld world) {
        this.setWorldName(world.getName());
        return this;
    }

    @Override
    public WSLocation updateWorld() {
        this.spongeWorld = SpongeWorldListener.getWorld(this.worldName).orElse(null);
        this.spongeLocation = this.spongeLocation != null ? this.spongeLocation.setExtent((Extent)this.spongeWorld) : new Transform((Extent)this.spongeWorld, new Vector3d(this.x, this.y, this.z), this.getRotation().toVector3().toDouble());
        return this;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public SpongeLocation setX(double x) {
        this.x = x;
        if (this.getLocation() != null) {
            this.spongeLocation = this.spongeLocation.setPosition(new Vector3d(x, this.spongeLocation.getPosition().getY(), this.spongeLocation.getPosition().getZ()));
        }
        return this;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public SpongeLocation setY(double y) {
        this.y = y;
        if (this.getLocation() != null) {
            this.spongeLocation = this.spongeLocation.setPosition(new Vector3d(this.spongeLocation.getPosition().getX(), y, this.spongeLocation.getPosition().getZ()));
        }
        return this;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public SpongeLocation setZ(double z) {
        this.z = z;
        if (this.getLocation() != null) {
            this.spongeLocation = this.spongeLocation.setPosition(new Vector3d(this.spongeLocation.getPosition().getX(), this.spongeLocation.getPosition().getY(), z));
        }
        return this;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public SpongeLocation setYaw(float yaw) {
        this.setRotation(new Vector2f(this.pitch, yaw));
        return this;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public SpongeLocation setPitch(float pitch) {
        this.setRotation(new Vector2f(pitch, this.yaw));
        return this;
    }

    @Override
    public Vector2f getRotation() {
        return new Vector2f(this.pitch, this.yaw);
    }

    @Override
    public WSLocation setRotation(Vector2f rotation) {
        this.pitch = rotation.getX();
        this.yaw = rotation.getY();
        this.spongeLocation.setRotation(new Vector3d(this.pitch, this.yaw, 0.0f));
        return this;
    }

    @Override
    public int getBlockX() {
        return NumericUtils.floor(this.x);
    }

    @Override
    public int getBlockY() {
        return NumericUtils.floor(this.y);
    }

    @Override
    public int getBlockZ() {
        return NumericUtils.floor(this.z);
    }

    @Override
    public double distance(WSLocation location) {
        return Math.sqrt(Math.pow(location.getX() - this.x, 2.0) + Math.pow(location.getY() - this.y, 2.0) + Math.pow(location.getZ() - this.z, 2.0));
    }

    public double distance(Location location) {
        return Math.sqrt(Math.pow(location.getX() - this.x, 2.0) + Math.pow(location.getY() - this.y, 2.0) + Math.pow(location.getZ() - this.z, 2.0));
    }

    @Override
    public double distance(double x, double y, double z) {
        return Math.sqrt(Math.pow(x - this.x, 2.0) + Math.pow(y - this.y, 2.0) + Math.pow(z - this.z, 2.0));
    }

    @Override
    public double distance(Vector3d vector3d) {
        return this.distance(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    @Override
    public SpongeLocation add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        if (this.getLocation() != null) {
            this.spongeLocation = this.spongeLocation.setLocation(this.spongeLocation.getLocation().add(x, y, z));
        }
        return this;
    }

    @Override
    public WSLocation add(Vector3d vector3d) {
        return this.add(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public Set<Entity> getEntitiesOnBlock() {
        if (this.getLocation() == null) {
            return new HashSet<Entity>();
        }
        return this.spongeWorld.getEntities().stream().filter(entity -> new SpongeLocation((Location<World>)entity.getLocation()).equalsBlock(this)).collect(Collectors.toSet());
    }

    public <T extends Entity> Set<T> getEntitiesOnBlock(Class<T> entityType) {
        if (this.getLocation() == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        this.spongeWorld.getEntities().stream().filter(entity -> entityType.isInstance(entity) && new SpongeLocation((Location<World>)entity.getLocation()).equalsBlock(this)).forEach(entity -> set.add(entity));
        return set;
    }

    @Override
    public SpongeLocation clone() {
        return new SpongeLocation(this);
    }

    @Override
    public SpongeLocation getBlockLocation() {
        return new SpongeLocation(this.worldName, (double)this.getBlockX(), (double)this.getBlockY(), (double)this.getBlockZ(), 0.0f, 0.0f);
    }

    @Override
    public EnumBiomeType getBiome() {
        return this.getWorld().getBiome(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    @Override
    public void setBiome(EnumBiomeType biome) {
        this.getWorld().setBiome(this.getBlockX(), this.getBlockY(), this.getBlockZ(), biome);
    }

    @Override
    public Collection<WSEntity> getNearbyEntities(Vector3d radius) {
        if (this.getLocation() == null) {
            return new HashSet<WSEntity>();
        }
        return this.spongeWorld.getEntities().stream().filter(entity -> {
            Location location = entity.getLocation();
            return Math.abs(location.getX() - this.x) < radius.getX() && Math.abs(location.getY() - this.y) < radius.getY() && Math.abs(location.getZ() - this.z) < radius.getZ();
        }).map(SpongeEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    public Set<WSEntity> getNearbyEntities(double radius) {
        if (this.getLocation() == null) {
            return new HashSet<WSEntity>();
        }
        return this.spongeWorld.getEntities().stream().filter(entity -> this.distance(entity.getLocation()) <= radius).map(SpongeEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public <T extends WSEntity> Collection<T> getNearbyEntities(Vector3d radius, Class<T> entityType) {
        if (this.spongeWorld == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        try {
            this.spongeWorld.getEntities().stream().map(SpongeEntityParser::getWSEntity).filter(entity -> {
                WSLocation location = entity.getLocation();
                return entityType.isInstance(entity) && Math.abs(location.getX() - this.x) < radius.getX() && Math.abs(location.getY() - this.y) < radius.getY() && Math.abs(location.getZ() - this.z) < radius.getZ();
            }).forEach(entity -> set.add(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return set;
    }

    @Override
    public <T extends WSEntity> Collection<T> getNearbyEntities(double radius, Class<T> entityType) {
        if (this.spongeWorld == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        try {
            this.spongeWorld.getEntities().stream().map(SpongeEntityParser::getWSEntity).filter(entity -> entityType.isInstance(entity) && this.distance(entity.getLocation()) <= radius).forEach(entity -> set.add(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return set;
    }

    @Override
    public Collection<WSPlayer> getNearbyPlayers(Vector3d radius) {
        return this.getNearbyEntities(radius, WSPlayer.class);
    }

    @Override
    public Collection<WSPlayer> getNearbyPlayers(double radius) {
        return this.getNearbyEntities(radius, WSPlayer.class);
    }

    @Override
    public int getHighestY() {
        return ((World)this.spongeLocation.getExtent()).getHighestYAt(this.getBlockX(), this.getBlockZ());
    }

    @Override
    public WSLocation updateSign(String[] lines) {
        if (lines.length != 4) {
            return this;
        }
        if (this.spongeWorld == null) {
            this.getLocation();
        }
        if (this.spongeWorld == null) {
            return this;
        }
        Optional optional = this.spongeLocation.getLocation().getTileEntity();
        if (!optional.isPresent() || !((TileEntity)optional.get()).getType().equals(TileEntityTypes.SIGN)) {
            return this;
        }
        Sign sign = (Sign)optional.get();
        SignData data = sign.getSignData();
        for (int i = 0; i < 4; ++i) {
            data.set((BaseValue)data.lines().set(i, (Object)Text.of((String)lines[i])));
        }
        sign.offer((ValueContainer)data);
        return this;
    }

    @Override
    public boolean equalsBlock(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocation that = (SpongeLocation)o;
        return this.getBlockX() == that.getBlockX() && this.getBlockY() == that.getBlockY() && this.getBlockZ() == that.getBlockZ();
    }

    @Override
    public Vector3d getFacingDirection() {
        double xz = Math.cos(Math.toRadians(this.pitch));
        return new Vector3d(-xz * Math.sin(Math.toRadians(this.yaw)), -Math.sin(Math.toRadians(this.pitch)), xz * Math.cos(Math.toRadians(this.yaw)));
    }

    @Override
    public Vector3d toVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    @Override
    public Vector3i toVector3i() {
        return new Vector3i(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    public World getHandledWorld() {
        return this.spongeWorld;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocation that = (SpongeLocation)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Float.compare(that.yaw, this.yaw) == 0 && Float.compare(that.pitch, this.pitch) == 0 && (this.worldName != null ? this.worldName.equals(that.worldName) : that.worldName == null);
    }

    public int hashCode() {
        int result = this.worldName != null ? this.worldName.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        return result;
    }
}

