/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.explosive.WSExplosive;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.world.SpongeLocation;
import com.degoos.wetsponge.world.WSExplosion;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;

public class SpongeExplosion
implements WSExplosion {
    private Explosion explosion;

    public SpongeExplosion(Explosion explosion) {
        this.explosion = explosion;
    }

    @Override
    public Optional<WSExplosive> getSourceExplosive() {
        Explosive explosive = this.explosion.getSourceExplosive().orElse(null);
        if (explosive == null) {
            return Optional.empty();
        }
        WSEntity entity = SpongeEntityParser.getWSEntity((Entity)explosive);
        if (entity instanceof WSExplosive) {
            return Optional.of((WSExplosive)entity);
        }
        return Optional.empty();
    }

    @Override
    public float getRadius() {
        return this.explosion.getRadius();
    }

    @Override
    public boolean canCauseFire() {
        return this.explosion.canCauseFire();
    }

    @Override
    public boolean shouldPlaySmoke() {
        return this.explosion.shouldPlaySmoke();
    }

    @Override
    public boolean shouldBreakBlocks() {
        return this.explosion.shouldBreakBlocks();
    }

    @Override
    public boolean shouldDamageEntities() {
        return this.explosion.shouldDamageEntities();
    }

    @Override
    public WSLocation getLocation() {
        return new SpongeLocation((Location<World>)this.explosion.getLocation());
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.explosion.getWorld().getName(), this.explosion.getWorld());
    }

    @Override
    public WSExplosion.Builder toBuilder() {
        return new Builder().sourceExplosive(this.getSourceExplosive().orElse(null)).radius(this.getRadius()).canCauseFire(this.canCauseFire()).shouldPlaySmoke(this.shouldPlaySmoke()).shouldBreakBlocks(this.shouldBreakBlocks()).shouldDamageEntities(this.shouldDamageEntities()).location(this.getLocation());
    }

    public Explosion getHandler() {
        return this.explosion;
    }

    public static class Builder
    implements WSExplosion.Builder {
        private Explosion.Builder builder = Explosion.builder();

        @Override
        public WSExplosion.Builder location(WSLocation location) {
            Validate.notNull(location, "Location cannot be null!");
            this.builder.location(((SpongeLocation)location).getLocation().getLocation());
            return this;
        }

        @Override
        public WSExplosion.Builder sourceExplosive(@Nullable WSExplosive explosive) {
            if (explosive == null) {
                this.builder.sourceExplosive(null);
            }
            return this;
        }

        @Override
        public WSExplosion.Builder radius(float radius) {
            this.builder.radius(radius);
            return this;
        }

        @Override
        public WSExplosion.Builder canCauseFire(boolean canCauseFire) {
            this.builder.canCauseFire(canCauseFire);
            return this;
        }

        @Override
        public WSExplosion.Builder shouldDamageEntities(boolean shouldDamageEntities) {
            this.builder.shouldDamageEntities(shouldDamageEntities);
            return this;
        }

        @Override
        public WSExplosion.Builder shouldPlaySmoke(boolean shouldPlaySmoke) {
            this.builder.shouldPlaySmoke(shouldPlaySmoke);
            return this;
        }

        @Override
        public WSExplosion.Builder shouldBreakBlocks(boolean shouldBreakBlocks) {
            this.builder.shouldBreakBlocks(shouldBreakBlocks);
            return this;
        }

        @Override
        public WSExplosion build() throws IllegalArgumentException {
            return new SpongeExplosion(this.builder.build());
        }
    }
}

